(function($){
 
    $.fn.shuffle = function() {
 
        var allElems = this.get(),
            getRandom = function(max) {
                return Math.floor(Math.random() * max);
            },
            shuffled = $.map(allElems, function(){
                var random = getRandom(allElems.length),
                    randEl = $(allElems[random]).clone(true)[0];
                allElems.splice(random, 1);
                return randEl;
           });
 
        this.each(function(i){
            $(this).replaceWith($(shuffled[i]));
        });
 
        return $(shuffled);
 
    };
 
})(jQuery);



(function ($) {
    $('#toggle-twitch-sidebar').click(function (e) {
        e.stopPropagation();

        if ($('#mini-icons .twitch').hasClass('active')) {

            $('#mini-icons div').removeClass('active');

            $('#twitch-sidebar').css({'left': '-300px'});
            $('#mini-icons').css({'left': '0'});

        }
        else {
            $('#youtube-sidebar').css({'left': '-300px'});
            $('#mini-icons div').removeClass('active');

            $('#twitch-sidebar').css({'left': '0'});
            $('#mini-icons').css({'left': '300px'});
            $('#mini-icons .twitch').addClass('active');
        }

    });


    $('#twitch-sidebar .close').click(function (e) {

$('#youtube-sidebar').css({'left': '-300px'});
        $('#mini-icons div').removeClass('active');

        $('#twitch-sidebar').css({'left': '-300px'});
        $('#mini-icons').css({'left': '0'});
        $('#mini-icons .twitch').removeClass('active');
        e.stopPropagation();

    
    });

    $('#toggle-youtube-sidebar').click(function (e) {

        e.stopPropagation();

        if ($('#mini-icons .youtube').hasClass('active')) {

            $('#mini-icons div').removeClass('active');

            $('#youtube-sidebar').css({'left': '-300px'});
            $('#mini-icons').css({'left': '0'});

        }
        else {

            $('#twitch-sidebar').css({'left': '-300px'});
            $('#mini-icons div').removeClass('active');
                
            $('#youtube-sidebar').css({'left': '0'});
            $('#mini-icons').css({'left': '300px'});
            $('#mini-icons .youtube').addClass('active');

        }

    });

       
    $('#youtube-sidebar .close').click(function (e) {

        $('#youtube-sidebar').css({'left': '-300px'});
        $('#mini-icons').css({'left': '0'});
        $('#mini-icons .youtube').removeClass('active');
        e.stopPropagation();


    });


    $('html').click(function () {
        $('#twitch-sidebar').css({'left': '-300px'});
        $('#youtube-sidebar').css({'left': '-300px'});
        $('#mini-icons').css({'left': '0'});
$('#mini-icons div').removeClass('active');
        $('#mini-icons div').removeClass('active');
//event.stopPropagation();
    });

    $('#twitch-sidebar').click(function (event) {
        event.stopPropagation();
    });

    function languageSlide() {
        var iL = $('.current-language').width();
        var lW = $('.languages').width();
        var lC = $('.languages a').length;
        $('.languages').css({"width": iL * lC, "left": -iL * lC});
        $('.languages a').css({width: iL});
        $('.languagewrapper').mouseover(function () {
            $('.languages').css({"left": iL});
        });
        $('.languagewrapper').mouseout(function () {
            $('.languages').css({"left": -iL * lC});
        });
    };

    function contentHeight() {
        var cH = $('.content-area').height();
        var sH = $('.sidebar').height();

        if (sH > cH) {
            $('.content-area').css({"min-height": sH});
        }
    };

    // gleiche Höhe für Elemente
    function equalHeights() {
        $('.row').each(function () {
            var highestBox = 0;
            $('.equal-height', this).each(function () {
                if ($(this).outerHeight() > highestBox) {
                    highestBox = $(this).outerHeight();
                }
            });
            $('.equal-height', this).outerHeight(highestBox);
        });
    };

    $(window).load(function () {

    });




    $(document).ready(function () {



      $(".discord-widget").addClass("active");

    $(".wiki-bubble").addClass("active");




        languageSlide();
        equalHeights();
        contentHeight();
        if ($('#slider-topper').find('.item').length > 1) {

            
            $("#slider-topper.owl-carousel .item").shuffle();






            $('#slider-topper.owl-carousel').owlCarousel({
                loop: true,
                margin: 0,
                dots: true,
                items: 1,
                autoplay: true,
                autoplayHoverPause: true,
                autoplayTimeout: 5000,         
            });

            
        }
        


        if (window.location.pathname === '/')
            $('.navbar a[href="' + (window.location.href).substring(0, (window.location.href).length - 1) + '"]').closest('li').addClass('active');
        else
            $('.navbar a[href="' + window.location.href + '"]').closest('li').addClass('active');

        $('.navbar a[href]').on('click', function (e) {
            $('.navbar li').removeClass('active');
            $(this).parent('li').addClass('active');
        });

        //Easylogin
        $('.easylogin-box[data-target]').on('click', function () {
            var alreadyOpen = '';
            if ($('.easylogin-extend-area:visible').length) {
                alreadyOpen = $('.easylogin-extend-area:visible').attr('id');

                $('.easylogin-extend-area:visible').slideToggle();
                $('.easylogin-box.selected').removeClass('selected');
            }

            if ($(this).attr('data-target') !== '#' + alreadyOpen) {
                $(this).addClass('selected');
                $($(this).attr('data-target')).slideToggle();
            }
        });

        $('.easylogin-box .easylogin-delete').on('click', function (e) {
            e.stopPropagation();
            var easyLoginBox = $(this).prev('.easylogin-user');
            var userToDelete = $.trim(easyLoginBox.html());
            $.get('easy-login/delete/' + userToDelete, function (data) {
            });

            $($(this).parent('.easylogin-box').attr('data-target')).remove();
            var parentEasyLoginBox = easyLoginBox.closest('.easylogin-box');

            parentEasyLoginBox.addClass('animated zoomOutUp');
            $(parentEasyLoginBox).one('webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend', function () {
                $(this).remove();

                if ($('.easylogin-box[data-target]').length === 0) {
                    $('.login-area').toggle();
                }
            });
        });

        $('#acc_change_rbguard input[name="rbguard_state"]').on('change', function () {

            $('#rubinum_guard_change_confirm').fadeIn();

            if ($(this).is(':checked')) {
                //$('#rubinum_guard_change_confirm').fadeOut();
                //$('#rbguard-confirm-code input[name="gcode"]').attr('required', false);
                
            } else {
                //$('#rubinum_guard_change_confirm').fadeIn();
                //$('#rbguard-confirm-code input[name="gcode"]').attr('required', true).focus();
            }
        });


        $('#acc_change_rbguard .delete-guard-token').on('click', function () {

            $(this).addClass('removing');

            var token = $(this).data('token');
            var el = $(this);
            
            $.ajax({
        async: false,
        url: '/rubinum-guard/delete-token/' + token,
        type: "GET",
        traditional: true
    }).done(function (result) {

        //console.log(result)

        if (result == 'deleted') {
            el.parent().parent().fadeOut('slow', function() {
                $(this).remove();
            });
        }

    });

});


    $('#acc_change_rbguard .delete-guard-hwid').on('click', function () {

            $(this).addClass('removing');

            var hwid = $(this).data('token');
            var el = $(this);
            
            $.ajax({
        async: false,
        url: '/rubinum-guard/delete-hwid/' + hwid,
        type: "GET",
        traditional: true
    }).done(function (result) {

        //console.log(result)

        if (result == 'deleted') {
            el.parent().parent().fadeOut('slow', function() {
                $(this).remove();
            });
        }

    });



        });



        $('[data-type="add-new-account-to-easylogin"]').on('click', function () {
            $('.login-area').toggle();
        });

        // Code Input Fields
        $('.code-input-group input').on('keypress paste', function (e) {
            var pressedKey = e.keyCode;

            if ((e.metaKey || e.ctrlKey) && pressedKey === 82) {
                return;
            }

            if ((e.metaKey || e.ctrlKey) && pressedKey === 86) {
                return $(this).trigger('paste');
            }

            e.preventDefault();

            if (e.type === 'paste') {
                if (!e.originalEvent)
                    return;

                var pastedText = e.originalEvent.clipboardData.getData('Text');

                if ($.isNumeric(pastedText)) {
                    pastedText = pastedText.toString();

                    for (codePart in pastedText) {
                        var focusedElement = $(':focus');

                        focusedElement.val(pastedText[codePart]);
                        focusedElement.next('input').focus();
                    }
                }

                $(this).closest('form').submit();

                return;
            }

            if (pressedKey === 8) {
                if ($(this).val().length > 0) {
                    $(this).val('');
                    return;
                }
                if ($(this).prev('input').length) {
                    $(this).prev('input').val('').focus();
                    return;
                }
            }

            /*
            if ((pressedKey >= 48 && pressedKey <= 57) || (pressedKey >= 96 && pressedKey <= 105)) {
                if (pressedKey >= 96 && pressedKey <= 105)
                    pressedKey = pressedKey - 48;

                $(this).val(String.fromCharCode(pressedKey));
                if (!$(this).next('input').length) {
                    $(this).blur();
                }
                $(this).next('input').focus();
            } else {
                $(this).val('');
            }
            */


            var regex = new RegExp("^[a-zA-Z0-9]+$");
            var key = String.fromCharCode(!e.charCode ? e.which : e.charCode);
            if (regex.test(key)) {
                $(this).val(key);
                if (!$(this).next('input').length) {
                    $(this).blur();
                }
                $(this).next('input').focus();
            } else {
               $(this).val('');
            }


        });
    });

    $(window).resize(function () {

    });

    $(window).scroll(function () {

        if($(document).scrollTop() > 100) {
            $(".navbar .logo img").addClass("shrink");
        } else {
            $(".navbar .logo img").removeClass("shrink");
        }

    });



        $('.metins-count-change').on('click', function () {
			
			
			var target = 'metins-count';

            //if ($('.inventory-title .inventory-name').hasClass('animated'))
             //   return;
            var activeInventory = $('.' + target + ' .inventory-title .inventory-name.active');
            var nextInventory = activeInventory.next('.inventory-name');
            var prevInventory = activeInventory.prev('.inventory-name');
            var directionOut = 'Left';
            var directionIn = 'Right';
            var firstInventory = $('.' + target + ' .inventory-title .inventory-name').first();
            var lastInventory = $('.' + target + ' .inventory-title .inventory-name').last();
            var requestedInventory;

            if ($(this).hasClass('back')) {
                directionOut = 'Right';
                directionIn = 'Left';
            }

            if (directionOut === 'Right' && prevInventory.length)
                requestedInventory = prevInventory;
            else if (directionOut === 'Right' && !prevInventory.length)
                requestedInventory = lastInventory;
            else if (directionOut === 'Left' && nextInventory.length)
                requestedInventory = nextInventory;
            else if (directionOut === 'Left' && !nextInventory.length)
                requestedInventory = firstInventory;

            var currentInventoryPage = $('.' + target + ' .'+activeInventory.attr('data-inventory'));
            var requestedInventoryPage = $('.' + target + ' .'+requestedInventory.attr('data-inventory'));

            currentInventoryPage.addClass('animated slideOut' + directionOut);
            activeInventory.addClass('animated slideOut' + directionOut)
                .one('webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend', function () {
                    activeInventory.removeClass('active animated slideOut' + directionOut);
                    currentInventoryPage.removeClass('active animated slideOut' + directionOut);

                    requestedInventoryPage.addClass('active animated slideIn' + directionIn);
                    requestedInventory.addClass('active animated slideIn' + directionIn)
                        .one('webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend', function () {
                            requestedInventory.removeClass('animated slideIn' + directionIn);
                            requestedInventoryPage.removeClass('animated slideIn' + directionIn);
                        });
                });
        });

     
        $('.dungeon-fastest-change').on('click', function () {

            //if ($('.inventory-title .inventory-name').hasClass('animated'))
             //   return;
            var activeInventory = $('.dungeon-fastest .inventory-title .inventory-name.active');
            var nextInventory = activeInventory.next('.inventory-name');
            var prevInventory = activeInventory.prev('.inventory-name');
            var directionOut = 'Left';
            var directionIn = 'Right';
            var firstInventory = $('.dungeon-fastest .inventory-title .inventory-name').first();
            var lastInventory = $('.dungeon-fastest .inventory-title .inventory-name').last();
            var requestedInventory;

            if ($(this).hasClass('back')) {
                directionOut = 'Right';
                directionIn = 'Left';
            }

            if (directionOut === 'Right' && prevInventory.length)
                requestedInventory = prevInventory;
            else if (directionOut === 'Right' && !prevInventory.length)
                requestedInventory = lastInventory;
            else if (directionOut === 'Left' && nextInventory.length)
                requestedInventory = nextInventory;
            else if (directionOut === 'Left' && !nextInventory.length)
                requestedInventory = firstInventory;

            var currentInventoryPage = $('.dungeon-fastest .'+activeInventory.attr('data-inventory'));
            var requestedInventoryPage = $('.dungeon-fastest .'+requestedInventory.attr('data-inventory'));

            currentInventoryPage.addClass('animated slideOut' + directionOut);
            activeInventory.addClass('animated slideOut' + directionOut)
                .one('webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend', function () {
                    activeInventory.removeClass('active animated slideOut' + directionOut);
                    currentInventoryPage.removeClass('active animated slideOut' + directionOut);

                    requestedInventoryPage.addClass('active animated slideIn' + directionIn);
                    requestedInventory.addClass('active animated slideIn' + directionIn)
                        .one('webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend', function () {
                            requestedInventory.removeClass('animated slideIn' + directionIn);
                            requestedInventoryPage.removeClass('animated slideIn' + directionIn);
                        });
                });
        });


        $('.dungeon-count-change').on('click', function () {

            //if ($('.inventory-title .inventory-name').hasClass('animated'))
             //   return;
            var activeInventory = $('.dungeon-count .inventory-title .inventory-name.active');
            var nextInventory = activeInventory.next('.inventory-name');
            var prevInventory = activeInventory.prev('.inventory-name');
            var directionOut = 'Left';
            var directionIn = 'Right';
            var firstInventory = $('.dungeon-count .inventory-title .inventory-name').first();
            var lastInventory = $('.dungeon-count .inventory-title .inventory-name').last();
            var requestedInventory;

            if ($(this).hasClass('back')) {
                directionOut = 'Right';
                directionIn = 'Left';
            }

            if (directionOut === 'Right' && prevInventory.length)
                requestedInventory = prevInventory;
            else if (directionOut === 'Right' && !prevInventory.length)
                requestedInventory = lastInventory;
            else if (directionOut === 'Left' && nextInventory.length)
                requestedInventory = nextInventory;
            else if (directionOut === 'Left' && !nextInventory.length)
                requestedInventory = firstInventory;

            var currentInventoryPage = $('.dungeon-count .'+activeInventory.attr('data-inventory'));
            var requestedInventoryPage = $('.dungeon-count .'+requestedInventory.attr('data-inventory'));

            currentInventoryPage.addClass('animated slideOut' + directionOut);
            activeInventory.addClass('animated slideOut' + directionOut)
                .one('webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend', function () {
                    activeInventory.removeClass('active animated slideOut' + directionOut);
                    currentInventoryPage.removeClass('active animated slideOut' + directionOut);

                    requestedInventoryPage.addClass('active animated slideIn' + directionIn);
                    requestedInventory.addClass('active animated slideIn' + directionIn)
                        .one('webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend', function () {
                            requestedInventory.removeClass('animated slideIn' + directionIn);
                            requestedInventoryPage.removeClass('animated slideIn' + directionIn);
                        });
                });
        });


        $('.dungeon-dmg-change').on('click', function () {

            //if ($('.inventory-title .inventory-name').hasClass('animated'))
             //   return;
            var activeInventory = $('.dungeon-dmg .inventory-title .inventory-name.active');
            var nextInventory = activeInventory.next('.inventory-name');
            var prevInventory = activeInventory.prev('.inventory-name');
            var directionOut = 'Left';
            var directionIn = 'Right';
            var firstInventory = $('.dungeon-dmg .inventory-title .inventory-name').first();
            var lastInventory = $('.dungeon-dmg .inventory-title .inventory-name').last();
            var requestedInventory;

            if ($(this).hasClass('back')) {
                directionOut = 'Right';
                directionIn = 'Left';
            }

            if (directionOut === 'Right' && prevInventory.length)
                requestedInventory = prevInventory;
            else if (directionOut === 'Right' && !prevInventory.length)
                requestedInventory = lastInventory;
            else if (directionOut === 'Left' && nextInventory.length)
                requestedInventory = nextInventory;
            else if (directionOut === 'Left' && !nextInventory.length)
                requestedInventory = firstInventory;

            var currentInventoryPage = $('.dungeon-dmg .'+activeInventory.attr('data-inventory'));
            var requestedInventoryPage = $('.dungeon-dmg .'+requestedInventory.attr('data-inventory'));

            currentInventoryPage.addClass('animated slideOut' + directionOut);
            activeInventory.addClass('animated slideOut' + directionOut)
                .one('webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend', function () {
                    activeInventory.removeClass('active animated slideOut' + directionOut);
                    currentInventoryPage.removeClass('active animated slideOut' + directionOut);

                    requestedInventoryPage.addClass('active animated slideIn' + directionIn);
                    requestedInventory.addClass('active animated slideIn' + directionIn)
                        .one('webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend', function () {
                            requestedInventory.removeClass('animated slideIn' + directionIn);
                            requestedInventoryPage.removeClass('animated slideIn' + directionIn);
                        });
                });
        });














    $('#support_token_show').on('click', function() {
        $("#support_token").show();
        $("#support_token span").html('<i class="fa fa-spinner fa-spin"></i>' );
        $.get('/my-account/change-data/support-token/show', function( result ) {
            $("#support_token span").html( result );
        });
    })

    $('#support_token_generate').on('click', function() {
        $("#support_token").show();
        $("#support_token span").html('<i class="fa fa-spinner fa-spin"></i>' );
        $.get('/my-account/change-data/support-token/generate', function( result ) {
            $("#support_token span").html( result );
        });
    })

    $('#support_token_revoke').on('click', function() {
        $("#support_token").show();
        $("#support_token span").html('<i class="fa fa-spinner fa-spin"></i>' );
        $.get('/my-account/change-data/support-token/revoke', function( result ) {
            $("#support_token span").html('Revoked');
        });
    })



})(jQuery);

function generateCountdown(elementSelector, end, format) {
    if (!format)
        format = '%I:%M:%S';

    $(elementSelector).countdown(end, function (e) {
        $(this).text(e.strftime(format));
    })
}

function callApi(url, data) {
    $.ajax({
        async: false,
        url: url,
        type: "POST",
        data: data,
        traditional: true
    }).done(function (result) {
        try {
            return $.parseJSON(result);
        } catch (e) {
            return result;
        }
    });
}

$.fn.extend({
    animateCss: function (animationName, callback) {
        var animationEnd = 'webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend';
        this.addClass('animated ' + animationName).one(animationEnd, function () {
            $(this).removeClass('animated ' + animationName);
            if (callback)
                callback(this);
        });
        return this;
    }
});