# Thanks to ProfessorEnte (ScriptVorlage mit Scrollbar)
# By Kilroy
import ui
import app
import chat
import net
import constInfo
import event

class WarpSystem(ui.ScriptWindow):

	picture_names = [
		{"picture" : "warppictures/spass.tga", "name" : "Grota Exilului"},
		{"picture" : "warppictures/spass.tga", "name" : "name2"},
		{"picture" : "warppictures/spass.tga", "name" : "name3"},
		{"picture" : "warppictures/spass.tga", "name" : "name4"}
	]

	def __init__(self):
		ui.ScriptWindow.__init__(self)
		self.Loaded = 0

	def BuildWindow(self):
		if self.Loaded > 0:
			self.Show()
			self.board.Show()
			return

		self.Loaded = 1
		self.board = self.CreateBoard(520, 320, 200, 100)
		self.board.SetTitleName("System Teleportare")
		self.board.SetCloseEvent(self.Open)
		self.board.SetCenterPosition()
		self.gui = {
				"scrollbar" : self.CreateScrollbar(self.board,self.board.GetHeight()-50,self.board.GetWidth()-25,35),
				"boards" : []
				}

		board_count = 3

		for i in xrange(min(board_count, len(self.picture_names))):
			self.gui["boards"].append(ExampleBoard(self.board, 10, 35 + 90 * i))
			self.gui["boards"][i].SetBoardInfo(i, self.picture_names[i]["picture"], self.picture_names[i]["name"])

		if len(self.picture_names) <= board_count:
			self.gui["scrollbar"].Hide()
		else:
			self.gui["scrollbar"].SetMiddleBarSize(float(board_count) / float(len(self.picture_names)))
			self.gui["scrollbar"].Show()
		self.gui["scrollbar"].SetScrollEvent(self.__OnScroll)

		self.Show()

	def __OnScroll(self):
		board_count = len(self.gui["boards"]) 
		pos = int(self.gui["scrollbar"].GetPos() * (len(self.picture_names) - board_count))

		for i in xrange(board_count):
			realPos = i + pos 
			self.gui["boards"][i].SetBoardInfo(realPos, self.picture_names[realPos]["picture"], self.picture_names[realPos]["name"])

	def CreateBoard(self, width, height, x, y):
		board = ui.BoardWithTitleBar()
		board.SetSize(width, height)
		board.SetPosition(x, y)
		board.AddFlag("movable")
		board.Show()
		return board

	def CreateScrollbar(self, parent, height, x, y):
		scrollbar = ui.ScrollBar()
		scrollbar.SetParent(parent)
		scrollbar.SetScrollBarSize(height)
		scrollbar.SetPosition(x, y)
		scrollbar.Show()
		return scrollbar

	def Open(self):
		if self.IsShow():
			self.board.Hide()
			self.Hide()
			return
		self.BuildWindow()

	def OnPressEscapeKey(self):
		self.Close()
		return TRUE

class ExampleBoard(ui.ScriptWindow):
	def __init__(self, parent, x, y):
		ui.ScriptWindow.__init__(self)
		self.board = self.CreateBoard(parent, 470, 90, x, y)
		self.gui = {
				"buttons" : {
					"warp" : self.CreateButton(self.board, 30 + 50 * 7, 10 + 20 * 2, "Teleport", self.Warp_func)
					},
				"textlines" : {
					"name": self.CreateTextline(self.board, 10 + 50 * 8, 20 + 20 * 0)
					},
				"image" : {
					"picture": self.CreateImage(self.board, 10 + 50 * 0, 10 + 25 * 0)
					},
				}

	def Warp_func(self):
		constInfo.WARPSYSTEM_BY_KILROY["CMD"] = str(self.index)
		event.QuestButtonClick(constInfo.WARPSYSTEM_BY_KILROY["index"])
		#chat.AppendChat(chat.CHAT_TYPE_INFO, "on index %d" % (self.index))

	def SetBoardInfo(self, index, picture, name):
		self.index = index
		self.gui["textlines"]["name"].SetText(name)
		self.gui["image"]["picture"].LoadImage(picture)

	def CreateTextline(self, parent, x, y):
		textline = ui.TextLine()
		textline.SetParent(parent)
		textline.SetPosition(x,y)
		textline.SetHorizontalAlignCenter()
		textline.Show()
		return textline

	def CreateImage(self, parent, x, y):
		image = ui.ExpandedImageBox()
		image.SetParent(parent)
		image.SetPosition(x,y)
		image.Show()
		return image

	def CreateBoard(self, parent, width, height, x, y):
		board = ui.Board()
		board.SetParent(parent)
		board.SetSize(width, height)
		board.SetPosition(x, y)
		board.SetTop()
		board.Show()
		return board

	def CreateButton(self, parent, x, y, text, event):
		button = ui.Button()
		button.SetParent(parent)
		button.SetPosition(x, y)
		button.SetUpVisual("d:/ymir work/ui/public/Middle_Button_01.sub")
		button.SetOverVisual("d:/ymir work/ui/public/Middle_Button_02.sub")
		button.SetDownVisual("d:/ymir work/ui/public/Middle_Button_03.sub")
		button.SetText(text)
		button.SetEvent(event)
		button.Show()
		return button

