import os
import ui
import player
import mouseModule
import net
import uiCommon
import app
import snd
import item
import player
import chat
import grp
import uiScriptLocale
import uiToolTip
import localeInfo
import gameInfo
import constInfo
import ime
import wndMgr
import translate
import skill
import nonplayer
from ui_wrapper import _ui

class PopupDialog(ui.ScriptWindow):
	def __init__(self, parent):
		ui.ScriptWindow.__init__(self)
		self.__Load()
		self.__Bind()
	def __del__(self):
		ui.ScriptWindow.__del__(self)
	def __Load(self):
		try:
			pyScrLoader = ui.PythonScriptLoader()
			pyScrLoader.LoadScriptFile(self, "UIScript/PopupDialog.py")
		except:
			import exception
			exception.Abort("PopupDialog.__Load")
	def __Bind(self):
		try:
			self.textLine=self.GetChild("message")
			self.okButton=self.GetChild("accept")
		except:
			import exception
			exception.Abort("PopupDialog.__Bind")
		self.okButton.SAFE_SetEvent(self.__OnOK)
	def Open(self, msg):
		self.textLine.SetText(msg)
		self.SetCenterPosition()
		self.Show()
		self.SetTop()
	def __OnOK(self):
		self.Hide()

class YoutubeWindow(ui.ScriptWindow):
	def __init__(self):
		ui.ScriptWindow.__init__(self)
		self.__LoadWindow()
		self.interface=None
		
	def __del__(self):
		ui.ScriptWindow.__del__(self)

	def Close(self):
		self.Hide()

	def __LoadWindow(self):
		try:
			pyScrLoader = ui.PythonScriptLoader()
			pyScrLoader.LoadScriptFile(self, "uiscript/youtuber.py")
		except:
			import exception
			exception.Abort("PetItemWindow.LoadWindow")			
		try:
			self.petfeed = self.GetChild("board")
			self.closebtn = self.GetChild("TitleYoutube")
			self.TitleName = self.GetChild("TitleName")
			self.okButton = self.GetChild("okButton")
			self.viewButton = self.GetChild("viewButton")
			self.editline = self.GetChild("InputValue2")
			self.editline2 = self.GetChild("InputValue")
			self.button3 = self.GetChild("button3")
			self.okButton.SAFE_SetEvent(self.Tamamla)
			self.viewButton.SAFE_SetEvent(self.Onizleme)
			self.button3.SAFE_SetEvent(self.Close)
			self.editline.OnPressEscapeKey = self.Close
			self.editline2.OnPressEscapeKey = self.Close
		except:
			import exception
			exception.Abort("PetItemWindow.LoadWindow")

		# self.editline.SetReturnEvent(ui.__mem_func__(self.Ara))
		# self.editline2.SetReturnEvent(ui.__mem_func__(self.Ara))
		self.popupDialog=PopupDialog(self)
		self.SetTop()
		self.SetCenterPosition()

	def Show(self):
		ui.ScriptWindow.Show(self)
		self.SetTop()
		self.editline2.SetFocus()

	def BindInterfaceClass(self, interface):
		self.interface = interface
		
	def Tamamla(self):
		if (self.interface):
			val = int(len(self.editline.GetText()))
			url=str(self.editline.GetText())
			if val < 3:
				chat.AppendChat(5, "Link ok ksa")
				return
			val2 = int(len(self.editline2.GetText()))
			baslik=str(self.editline2.GetText())
			if val2 < 3:
				chat.AppendChat(5, "Balk ok ksa")
				return
		self.interface.YeniLink()
		link = chat.GetLinkYoutube(url, baslik)
		ime.PasteString(link)
		self.Close()

	def Onizleme(self):
		if (self.interface):
			val = int(len(self.editline.GetText()))
			if val > 1:
				url = "http://ruya2.com/videos.php?youtube=%s" % str(self.editline.GetText())
				self.interface.YoutubeShow(url)
			else:
				chat.AppendChat(5, "Link ok ksa")

	def __PopupMessage(self, msg):
		self.popupDialog.Open(msg)
		
	def __ShowMenuToolTip(self, msg):
		self.toolTip.ClearToolTip()
		self.toolTip.AppendTextLine(msg)
		self.toolTip.Show()

	def __OverOutButtonMenu(self):
		self.toolTip.Hide()
	# def OnPressEscapeKey(self):
		# self.Close()
		# return True
