import dbg
import ui
import snd
import systemSetting
import net
import chat
import app
import localeInfo
import constInfo
import chrmgr
import player
import musicInfo

from _weakref import proxy
from switchbot import Bot

import uiSelectMusic
import background

MUSIC_FILENAME_MAX_LEN = 25

blockMode = 0

class OptionDialog(ui.ScriptWindow):

	def __init__(self):
		ui.ScriptWindow.__init__(self)
		self.__Initialize()
		self.__Load()
		
		self.switchbot = Bot()
		self.switchbot.Hide()

	def __del__(self):
		ui.ScriptWindow.__del__(self)
		print " -------------------------------------- DELETE SYSTEM OPTION DIALOG"

	def __Initialize(self):
		self.tilingMode = 0
		self.titleBar = 0
		self.changeMusicButton = 0
		
	def Destroy(self):
		self.ClearDictionary()

		self.__Initialize()
		print " -------------------------------------- DESTROY SYSTEM OPTION DIALOG"

	def __Load_LoadScript(self, fileName):
		try:
			pyScriptLoader = ui.PythonScriptLoader()
			pyScriptLoader.LoadScriptFile(self, fileName)
		except:
			import exception
			exception.Abort("System.OptionDialog.__Load_LoadScript")

	def __Load_BindObject(self):
		try:
			GetObject = self.GetChild
			self.titleBar = GetObject("titlebar")
			self.change2MusicButton = GetObject("bgm_button2")
			self.change3MusicButton = GetObject("bgm_button3")

		except:
			import exception
			exception.Abort("OptionDialog.__Load_BindObject")

	def __Load(self):
		self.__Load_LoadScript("uiscript/saplingbotoption.py")
		self.__Load_BindObject()

		self.SetCenterPosition()
		
		self.titleBar.SetCloseEvent(ui.__mem_func__(self.Close))

		self.change2MusicButton.SAFE_SetEvent(self.__OnClick2ChangeMusicButton)
		self.change3MusicButton.SAFE_SetEvent(self.__OnClick3ChangeMusicButton)

	def __ResimYerlestir(self, event):
		if event == 1:
			self.changeMusicButton.LoadImage("event/50137.tga")
			self.changeMusicButtonText.SetText("Esrarengiz Sandık Etkinliği!")
		elif event == 2:
			self.changeMusicButton.LoadImage("event/50067.tga")
			self.changeMusicButtonText.SetText("Parşomen Etkinliği!")
		elif event == 3:
			self.changeMusicButton.LoadImage("icon/item/71159.tga")
			self.changeMusicButtonText.SetText("Kostüm Etkinliği!")
		elif event == 4:
			self.changeMusicButton.LoadImage("event/50033.tga")
			self.changeMusicButtonText.SetText("Gizemli Sandık Etkinliği!")
		elif event == 5:
			self.changeMusicButton.LoadImage("event/50132.tga")
			self.changeMusicButtonText.SetText("Evcil Hayvan Etkinliği!")
		elif event == 6:
			self.changeMusicButton.LoadImage("event/30316.tga")
			self.changeMusicButtonText.SetText("Tabak Etkinliği!")
		elif event == 7:
			self.changeMusicButton.LoadImage("event/50011.tga")
			self.changeMusicButtonText.SetText("Ay Işığı Etkinliği!")
		elif event == 8:
			self.changeMusicButton.LoadImage("event/50125.tga")
			self.changeMusicButtonText.SetText("Cadılar Bayramı Etkinliği!")
		elif event == 9:
			self.changeMusicButton.LoadImage("icon/item/50034.tga")
			self.changeMusicButtonText.SetText("Bulmaca Kutusu Etkinliği!")	
		elif event == 10:
			self.changeMusicButton.LoadImage("event/50096.tga")
			self.changeMusicButtonText.SetText("Futbol Topu Etkinliği!")
		elif event == 11:
			self.changeMusicButton.LoadImage("event/50183.tga")
			self.changeMusicButtonText.SetText("Ramazan Etkinliği!")	
			
	def __OnClick2ChangeMusicButton(self):
		self.Hide()
		if not constInfo.eigenmod:
			execfile('eigenmods.py',{})
			constInfo.eigenmod = 1
		else:
			chat.AppendChat(1, "Efsunbot zaten aktif")
			
	def __OnClick3ChangeMusicButton(self):
		self.Hide()
		pyScrLoader = ui.PythonScriptLoader()
		pyScrLoader.LoadScriptFile(self, "efsunbot.pyc")

	def OnCloseInputDialog(self):
		self.inputDialog.Close()
		self.inputDialog = None
		return True

	def OnCloseQuestionDialog(self):
		self.questionDialog.Close()
		self.questionDialog = None
		return True

	def OnPressEscapeKey(self):
		self.Close()
		return True

	def Open(self, icon):
		self.__ResimYerlestir(icon)
		self.Show()
	
	def Show(self):
		ui.ScriptWindow.Show(self)

	def Close(self):
		self.Hide()

	def __NotifyChatLine(self, text):
		chat.AppendChat(chat.CHAT_TYPE_INFO, text)
		
