import os
import ui
import player
import mouseModule
import net
import app
import snd
import item
import player
import chat
import grp
import uiScriptLocale
import localeInfo
import constInfo
import ime
import wndMgr
import uiCommon

class PetFeedWindow(ui.ScriptWindow):

	def __init__(self):
		ui.ScriptWindow.__init__(self)
		self.is_showed = False
		self.arryfeed = [-1, -1, -1, -1, -1, -1, -1, -1, -1]
		self.arrysize = [0, 0, 0, 0, 0, 0, 0, 0, 0]
		self.questionDialog = None
		self.__LoadWindow()
		

	def __del__(self):
		ui.ScriptWindow.__del__(self)
		
	def IsShow(self):
		return self.is_showed

	def Show(self):
		self.is_showed = True
		ui.ScriptWindow.Show(self)

	def Close(self):
		for x in range(len(self.arryfeed)):
			self.arryfeed[x] = -1
			self.arrysize[x] = 0
			self.petslot.ClearSlot(x)
			self.petslot.RefreshSlot()
		self.Hide()
		self.is_showed = False
	
	def __LoadWindow(self):
		try:
			pyScrLoader = ui.PythonScriptLoader()
			pyScrLoader.LoadScriptFile(self, "uiscript/PetFeedWindow.py")
		except:
			import exception
			exception.Abort("PetFeedWindow.LoadWindow.LoadObject")
			
		try:
			self.petfeed = self.GetChild("board")
			self.closebtn = self.GetChild("PetFeed_TitleBar")
			self.petslot = self.GetChild("FeedItemSlot")
			self.feedbtn = self.GetChild("FeedButton")
			
			##PetSlot
			
			self.petslot.SetSelectEmptySlotEvent(ui.__mem_func__(self.SelectEmptySlot))
			self.petslot.SetSelectItemSlotEvent(ui.__mem_func__(self.SelectItemSlot))
			#self.petslot.SetUnselectItemSlotEvent(ui.__mem_func__(self.UseItemSlot))
			#self.petslot.SetUseSlotEvent(ui.__mem_func__(self.UseItemSlot))
			
			##Event secondari
			
			self.feedbtn.SetEvent(ui.__mem_func__(self.SendPetItem))
			self.closebtn.SetCloseEvent(self.Close)
			
			
		except:
			import exception
			exception.Abort("PetFeedWindow.LoadWindow.BindObject")
			
	def OnCloseQuestionDialog(self):
		if self.questionDialog:
			self.questionDialog.Close()

		self.questionDialog = None
	
	def SelectEmptySlot(self, selectedSlotPos):
		#chat.AppendChat(chat.CHAT_TYPE_INFO, "Empty"+str(selectedSlotPos))		

		if mouseModule.mouseController.isAttached():

			attachedSlotType = mouseModule.mouseController.GetAttachedType()
			attachedSlotPos = mouseModule.mouseController.GetAttachedSlotNumber()
			attachedItemCount = mouseModule.mouseController.GetAttachedItemCount()
			attachedItemIndex = mouseModule.mouseController.GetAttachedItemIndex()
			if attachedItemCount > 1:
				chat.AppendChat(chat.CHAT_TYPE_INFO, "Not enough items.")
				return
			if attachedItemCount == 1:
				attachedItemCount = 0
			item.SelectItem(attachedItemIndex)
			(width, height) = item.GetItemSize()
			#chat.AppendChat(chat.CHAT_TYPE_INFO, "Empty"+str(width)+"a"+str(height))			
			if player.SLOT_TYPE_INVENTORY == attachedSlotType and not attachedSlotPos in self.arryfeed and self.CanMoveItem(height, selectedSlotPos):
				itemCount = player.GetItemCount(attachedSlotPos)
				attachedCount = mouseModule.mouseController.GetAttachedItemCount()
				self.arryfeed[selectedSlotPos] = attachedSlotPos
				self.arrysize[selectedSlotPos] = height
				self.petslot.SetItemSlot(selectedSlotPos, attachedItemIndex, attachedItemCount)
			else:
				chat.AppendChat(chat.CHAT_TYPE_INFO, "Invalid Input")

			mouseModule.mouseController.DeattachObject()
	
	def SelectItemSlot(self, itemSlotIndex):
		#chat.AppendChat(chat.CHAT_TYPE_INFO, "Select"+str(itemSlotIndex))
		self.arryfeed[itemSlotIndex] = -1
		self.arrysize[itemSlotIndex] = 0
		self.petslot.ClearSlot(itemSlotIndex)
		self.petslot.RefreshSlot()
		
	def CanMoveItem(self, size, destindex):
		for x in range(0, len(self.arrysize)):
			if self.arrysize[x] > 0:
				for y in range(0, self.arrysize[x]):
					if x+(y*3) == destindex:
						return False
		return True
	
	#def UseItemSlot(self, slotIndex):
		#chat.AppendChat(chat.CHAT_TYPE_INFO, "Select"+str(slotIndex))
		
	def SendPetItem(self):
		self.questionDialog = uiCommon.QuestionDialog()
		self.questionDialog.SetText("Esti sigur ca vrei sa hranesti animalutul?")
		self.questionDialog.SetAcceptEvent(ui.__mem_func__(self.ConfirmPetItem))
		self.questionDialog.SetCancelEvent(ui.__mem_func__(self.OnCloseQuestionDialog))
		self.questionDialog.Open()
		
	def ConfirmPetItem(self):
		for i in range(len(self.arryfeed)):
			if self.arryfeed[i] != -1:
				#chat.AppendChat(chat.CHAT_TYPE_INFO, "Oggetto inviato in pos"+str(i))
				net.SendChatPacket("/cubepetadd add %d %d" % (i, self.arryfeed[i]))
		net.SendChatPacket("/feedcubepet %d" % (constInfo.FEEDWIND))
		for x in range(len(self.arryfeed)):
			self.arryfeed[x] = -1
			self.arrysize[x] = 0
			self.petslot.ClearSlot(x)
			self.petslot.RefreshSlot()
		self.OnCloseQuestionDialog()


