import app
import ui
import localeInfo
import uiScriptLocale
import constInfo
import event
import chat
import time
import net
import interfaceModule
import uiguild


liderlist = None


class PopupDialog(ui.ScriptWindow):
	def __init__(self, parent):
		print "NEW POPUP WINDOW   ----------------------------------------------------------------------------"	
		ui.ScriptWindow.__init__(self)

		self.__Load()
		self.__Bind()

	def __del__(self):
		ui.ScriptWindow.__del__(self)
		print "---------------------------------------------------------------------------- DELETE POPUP WINDOW"

	def __Load(self):
		try:
			pyScrLoader = ui.PythonScriptLoader()
			pyScrLoader.LoadScriptFile(self, "UIScript/PopupDialog.py")
		except:
			import exception
			exception.Abort("PopupDialog.__Load")

	def __Bind(self):
		try:
			self.textLine=self.GetChild("message")
			self.okButton=self.GetChild("accept")
		except:
			import exception
			exception.Abort("PopupDialog.__Bind")

		self.okButton.SetEvent(ui.__mem_func__(self.__OnOK))

	def Open(self, msg):
		self.textLine.SetText(msg)
		self.SetCenterPosition()
		self.Show()
		self.SetTop()

	def __OnOK(self):
		self.Hide()

class LiderSelectDialog(ui.ScriptWindow):
	def __init__(self):
		print "NEW MARK LIST WINDOW   ----------------------------------------------------------------------------"
		ui.ScriptWindow.__init__(self)

		self.selectEvent=None
		self.isLoaded=0
		self.yenileme=0
		self.interface=None
		import constInfo
		import event
		constInfo.lider_list = []
		event.QuestButtonClick(constInfo.lonca_lider_q)
		

	def __del__(self):
		ui.ScriptWindow.__del__(self)
		print "---------------------------------------------------------------------------- DELETE MARK LIST WINDOW"

	def Show(self):
		if self.isLoaded==0:
			self.isLoaded=1

			self.__Load()

		ui.ScriptWindow.Show(self)

	def Open(self):
		self.Show()

		self.SetCenterPosition()
		self.SetTop()
		event.QuestButtonClick(constInfo.lonca_lider_q)
		
		if self.liderlist.IsEmpty():
			self.__PopupMessage("Nu este nici un lider activ.")

	def Close(self):
		self.popupDialog.Hide()
		self.Hide()

	def OnPressEscapeKey(self):
		self.Close()
		return TRUE

	def SAFE_SetSelectEvent(self, event):
		self.selectEvent=ui.__mem_func__(event)

	def __Createliderlist(self):
		liderlist=ui.ListBoxEx()
		liderlist.SetParent(self)
		liderlist.SetPosition(15, 50)
		liderlist.Show()
		return liderlist

	def __Load(self):
		self.popupDialog=PopupDialog(self)

		try:
			pyScrLoader = ui.PythonScriptLoader()
			if localeInfo.IsVIETNAM():
				pyScrLoader.LoadScriptFile(self, uiScriptLocale.LOCALE_UISCRIPT_PATH + "leaderwindow.py")
			else:
				pyScrLoader.LoadScriptFile(self, "UIScript/leaderwindow.py")
		except:
			import exception
			exception.Abort("liderlist.__Load")

		try:
			self.liderlist=self.__Createliderlist()
			self.__ClearFileList()
			self.liderlist.SetScrollBar(self.GetChild("ScrollBar"))


			self.board=self.GetChild("board")
			self.cancelButton=self.GetChild("cancel")
			self.refreshButton=self.GetChild("refresh")
			self.savasButton=self.GetChild("savasgonder")

		except:
			import exception
			exception.Abort("liderlist.__Bind")

		self.refreshButton.SetEvent(ui.__mem_func__(self.__OnRefresh))
		self.cancelButton.SetEvent(ui.__mem_func__(self.__OnCancel))
		self.savasButton.SetEvent(ui.__mem_func__(self.__savas))
		self.board.SetCloseEvent(ui.__mem_func__(self.__OnCancel))
		

		
		self.UpdateRect()
		
		if len(constInfo.lider_list) != 0:
			for i in xrange(0, len(constInfo.lider_list)):
				self.liderlist.AppendItem(markla(constInfo.lider_list[i].split("#")[2] + " : Lider : "+constInfo.lider_list[i].split("#")[1]))
				
		self.yenile = app.GetTime()+5



	def __savas(self):
		secc = self.liderlist.GetSelectedItem()
		if secc:
			secileen = secc.GetText()
			secileenn = secileen.split(" : Lider : ")[0]
			self.savas = uiguild.DeclareGuildWarDialog()
			self.savas.Open2(secileenn)

	def __PopupMessage(self, msg):
		self.popupDialog.Open(msg)

	def __OnCancel(self):
		self.Hide()

	def __OnRefresh(self):
		if self.yenile > app.GetTime():
			chat.AppendChat(chat.CHAT_TYPE_INFO, "Poti actualiza lista odata la 5 secunde. Secunde ramase: "+str(int(self.yenile)-int(app.GetTime())))
		else:
			self.__ClearFileList()
			event.QuestButtonClick(constInfo.lonca_lider_q)
			for i in xrange(0, len(constInfo.lider_list)):
				# self.liderlist.AppendItem(markla(constInfo.lider_list[i]))
				self.liderlist.AppendItem(markla(constInfo.lider_list[i].split("#")[2] + " : Lider : "+constInfo.lider_list[i].split("#")[1]))
				
			chat.AppendChat(chat.CHAT_TYPE_INFO, "Am actualizat lista cu liderii activi.")
			self.yenile = app.GetTime()+5
		
		

	def OnUpdate(self):
		if self.yenile > app.GetTime():
			return
			# chat.AppendChat(chat.CHAT_TYPE_INFO, "5 saniyede bir listeyi gncelleyebilirsiniz. Kalan Sre : "+str(int(self.yenile)-int(app.GetTime())))
		else:
			self.__ClearFileList()
			event.QuestButtonClick(constInfo.lonca_lider_q)
			for i in xrange(0, len(constInfo.lider_list)):
				# self.liderlist.AppendItem(markla(constInfo.lider_list[i]))
				self.liderlist.AppendItem(markla(constInfo.lider_list[i].split("#")[2] + " : Lider : "+constInfo.lider_list[i].split("#")[1]))
				
			# chat.AppendChat(chat.CHAT_TYPE_INFO, "Aktif Lonca Liderleri Yenilendi.")
			self.yenile = app.GetTime()+5
	
	
	
	def __ClearFileList(self):
		self.liderlist.RemoveAllItems()


	def __AppendFile(self, fileName):
		self.liderlist.AppendItem(markla(fileName))

class markla(ui.ListBoxEx.Item):
	def __init__(self, fileName):
		ui.ListBoxEx.Item.__init__(self)
		self.imgWidth=0
		self.imgHeight=0
		self.canLoad=0
		self.textLine=self.__CreateTextLine(fileName)
		self.imgBox=self.__CreateImageBox()

	def __del__(self):
		ui.ListBoxEx.Item.__del__(self)

	def GetText(self):
		return self.textLine.GetText()

	def SetSize(self, width, height):
		ui.ListBoxEx.Item.SetSize(self, 20 + 6*len(self.textLine.GetText()) + 4, height)

	def __CreateTextLine(self, fileName):
		textLine=ui.TextLine()
		textLine.SetParent(self)
		textLine.SetPosition(20, 0)
		textLine.SetText(fileName)
		textLine.Show()
		return textLine

	def __CreateImageBox(self):
		imgBox=ui.ImageBox()
		imgBox.AddFlag("not_pick")
		imgBox.SetParent(self)
		imgBox.SetPosition(0, 2)
		imgBox.LoadImage("d:/ymir work/ui/game/windows/messenger_list_online.sub")
		imgBox.Show()
		return imgBox

		
		
class LiderrSelectDialog(ui.ScriptWindow):
	def __init__(self):
		print "NEW SYMBOL LIST WINDOW   ----------------------------------------------------------------------------"
		ui.ScriptWindow.__init__(self)

		self.selectEvent=None
		self.isLoaded=0

	def __del__(self):
		ui.ScriptWindow.__del__(self)
		print "---------------------------------------------------------------------------- DELETE SYMBOL LIST WINDOW"

	def Show(self):
		if self.isLoaded==0:
			self.isLoaded=1

			self.__Load()

		ui.ScriptWindow.Show(self)

	def Open(self):
		self.Show()

		self.SetCenterPosition()
		self.SetTop()

	def Close(self):
		self.popupDialog.Hide()
		self.Hide()

	def OnPressEscapeKey(self):
		self.Close()
		return TRUE

	def SAFE_SetSelectEvent(self, event):
		self.selectEvent=ui.__mem_func__(event)

	def __Createliderlistt(self):
		liderlistt=ui.ListBoxEx()
		liderlistt.SetParent(self)
		liderlistt.SetPosition(15, 50)
		liderlistt.Show()
		return liderlistt

	def __Load(self):
		self.popupDialog=PopupDialog(self)

		try:
			pyScrLoader = ui.PythonScriptLoader()
			pyScrLoader.LoadScriptFile(self, "UIScript/MarkListWindow.py")
		except:
			import exception
			exception.Abort("liderlistt.__Load")

		try:
			self.liderlistt=self.__Createliderlistt()
			self.liderlistt.SetScrollBar(self.GetChild("ScrollBar"))

			self.popupText = self.popupDialog.GetChild("message")
			self.popupDialog.GetChild("accept").SetEvent(ui.__mem_func__(self.popupDialog.Hide))

			self.board=self.GetChild("board")
			self.okButton=self.GetChild("ok")
			self.cancelButton=self.GetChild("cancel")
			self.refreshButton=self.GetChild("refresh")

		except:
			import exception
			exception.Abort("liderlistt.__Bind")

		self.board.SetCloseEvent(ui.__mem_func__(self.__OnCancel))

		self.UpdateRect()

		self.__RefreshFileList()

	def __OnCancel(self):
		self.Hide()


	def __AppendFile(self, fileName):
		self.liderlistt.AppendItem((fileName))
