import ui
import snd
import systemSetting
import net
import chat
import app
import localeInfo
import constInfo
import chrmgr
import player
import uiPrivateShopBuilder # ȣ
import interfaceModule # ȣ
import background
import serverInfo
import os
import officialfilesgame
import uiOfflineShopBuilder
if app.ENABLE_MELEY_LAIR_DUNGEON:
	import background
blockMode = 0
viewChatMode = 0

MOBILE = FALSE

if localeInfo.IsYMIR():
	MOBILE = TRUE

class OptionDialog(ui.ScriptWindow):

	def __init__(self):
		ui.ScriptWindow.__init__(self)
		self.__Initialize()
		self.__Load()
		self.RefreshViewChat()
		self.RefreshAlwaysShowName()
		self.RefreshShowDamage()
		self.RefreshShowSalesText()
		if app.WJ_SHOW_MOB_INFO:
			self.RefreshShowMobInfo()
		self.RefreshShow()
		self.RefreshShowNightText()
		# self.RefreshShowMor()
		self.RefreshShowKritik()
		# self.RefreshShowDuello()
		# self.RefreshShowTest()
		self.RefreshShowOfflineShop()

	def __del__(self):
		ui.ScriptWindow.__del__(self)
		print " -------------------------------------- DELETE GAME OPTION DIALOG"

	def __Initialize(self):
		self.titleBar = 0
		self.nameColorModeButtonList = []
		self.viewTargetBoardButtonList = []
		self.pvpModeButtonDict = {}
		self.blockButtonList = []
		self.viewChatButtonList = []
		self.alwaysShowNameButtonList = []
		self.showDamageButtonList = []
		self.showsalesTextButtonList = []
		if app.WJ_SHOW_MOB_INFO:
			self.showMobInfoButtonList = []
		self.KarmiLao = []
		self.showNightButtonList = []
		self.snowtexturesTextButtonList = []
		# self.showMor = []
		self.showKritik = []
		# self.showDuello = []
		# self.showTest = []
		self.AutoPickUpButtonList = []
		self.showOfflineShopButtonList = []
		# self.YangdropButtonList = []
		self.petsButtonList = []
		self.mountsButtonList = []
		
	def Destroy(self):
		self.ClearDictionary()

		self.__Initialize()
		print " -------------------------------------- DESTROY GAME OPTION DIALOG"
	
	def __Load_LoadScript(self, fileName):
		try:
			pyScriptLoader = ui.PythonScriptLoader()
			pyScriptLoader.LoadScriptFile(self, fileName)
		except:
			import exception
			exception.Abort("OptionDialog.__Load_LoadScript")

	def __Load_BindObject(self):
		try:
			GetObject = self.GetChild
			self.titleBar = GetObject("titlebar")
			self.nameColorModeButtonList.append(GetObject("name_color_normal"))
			self.nameColorModeButtonList.append(GetObject("name_color_empire"))
			self.viewTargetBoardButtonList.append(GetObject("target_board_no_view"))
			self.viewTargetBoardButtonList.append(GetObject("target_board_view"))
			self.pvpModeButtonDict[player.PK_MODE_PEACE] = GetObject("pvp_peace")
			self.pvpModeButtonDict[player.PK_MODE_REVENGE] = GetObject("pvp_revenge")
			self.pvpModeButtonDict[player.PK_MODE_GUILD] = GetObject("pvp_guild")
			self.pvpModeButtonDict[player.PK_MODE_FREE] = GetObject("pvp_free")
			self.blockButtonList.append(GetObject("block_exchange_button"))
			self.blockButtonList.append(GetObject("block_party_button"))
			self.blockButtonList.append(GetObject("block_guild_button"))
			self.blockButtonList.append(GetObject("block_whisper_button"))
			self.blockButtonList.append(GetObject("block_friend_button"))
			self.blockButtonList.append(GetObject("block_party_request_button"))
			#self.blockButtonList.append(GetObject("block_view_equipment_button"))
			#self.blockButtonList.append(GetObject("block_tec_request_button"))
			self.viewChatButtonList.append(GetObject("view_chat_on_button"))
			self.viewChatButtonList.append(GetObject("view_chat_off_button"))
			self.alwaysShowNameButtonList.append(GetObject("always_show_name_on_button"))
			self.alwaysShowNameButtonList.append(GetObject("always_show_name_off_button"))
			self.showDamageButtonList.append(GetObject("show_damage_on_button"))
			self.showDamageButtonList.append(GetObject("show_damage_off_button"))
			self.showsalesTextButtonList.append(GetObject("salestext_on_button"))
			self.showsalesTextButtonList.append(GetObject("salestext_off_button"))
			if app.WJ_SHOW_MOB_INFO:
				self.showMobInfoButtonList.append(GetObject("show_mob_level_button"))
				self.showMobInfoButtonList.append(GetObject("show_mob_AI_flag_button"))
			self.showNightButtonList.append(GetObject("showNight_on_button"))
			self.showNightButtonList.append(GetObject("showNight_off_button"))
			self.snowtexturesTextButtonList.append(GetObject("snowtextures_on_button"))
			self.snowtexturesTextButtonList.append(GetObject("snowtextures_off_button"))
			#yangdrop
			# self.YangdropButtonList.append(GetObject("yangdrop_on_button"))
			# self.YangdropButtonList.append(GetObject("yangdrop_off_button"))
			#yangdrop

			self.KarmiLao.append(GetObject("kar_on"))
			self.KarmiLao.append(GetObject("kar_off"))

			# self.showMor.append(GetObject("mor_effect_on"))
			# self.showMor.append(GetObject("mor_effect_off"))

			self.showKritik.append(GetObject("kritik_effect_on"))
			self.showKritik.append(GetObject("kritik_effect_off"))
						
			# self.showDuello.append(GetObject("acce_effect_on"))
			# self.showDuello.append(GetObject("acce_effect_off"))
					
			# self.showTest.append(GetObject("binek_effect_on"))
			# self.showTest.append(GetObject("binek_effect_off"))

			self.AutoPickUpButtonList.append(GetObject("auto_pick_up_on_button"))
			self.AutoPickUpButtonList.append(GetObject("auto_pick_up_off_button"))

			self.showOfflineShopButtonList.append(GetObject("show_offline_shop_on"))
			self.showOfflineShopButtonList.append(GetObject("show_offline_shop_off"))
			
			self.petsButtonList.append(GetObject("pets_on_button"))
			self.petsButtonList.append(GetObject("pets_off_button"))
			
			self.mountsButtonList.append(GetObject("mounts_on_button"))
			self.mountsButtonList.append(GetObject("mounts_off_button"))

			global MOBILE
			if MOBILE:
				self.inputMobileButton = GetObject("input_mobile_button")
				self.deleteMobileButton = GetObject("delete_mobile_button")
			if app.ENABLE_SHOPNAMES_RANGE:
				self.ctrlShopNamesRange = GetObject("salestext_range_controller")

		except:
			import exception
			exception.Abort("OptionDialog.__Load_BindObject")

	def __Load(self):
		global MOBILE
		if MOBILE:
			self.__Load_LoadScript("uiscript/gameoptiondialog_formobile.py")
		else:
			self.__Load_LoadScript("uiscript/gameoptiondialog.py")

		self.__Load_BindObject()

		self.SetCenterPosition()

		self.titleBar.SetCloseEvent(ui.__mem_func__(self.Close))

		self.nameColorModeButtonList[0].SAFE_SetEvent(self.__OnClickNameColorModeNormalButton)
		self.nameColorModeButtonList[1].SAFE_SetEvent(self.__OnClickNameColorModeEmpireButton)

		self.viewTargetBoardButtonList[0].SAFE_SetEvent(self.__OnClickTargetBoardViewButton)
		self.viewTargetBoardButtonList[1].SAFE_SetEvent(self.__OnClickTargetBoardNoViewButton)

		self.pvpModeButtonDict[player.PK_MODE_PEACE].SAFE_SetEvent(self.__OnClickPvPModePeaceButton)
		self.pvpModeButtonDict[player.PK_MODE_REVENGE].SAFE_SetEvent(self.__OnClickPvPModeRevengeButton)
		self.pvpModeButtonDict[player.PK_MODE_GUILD].SAFE_SetEvent(self.__OnClickPvPModeGuildButton)
		self.pvpModeButtonDict[player.PK_MODE_FREE].SAFE_SetEvent(self.__OnClickPvPModeFreeButton)

		self.blockButtonList[0].SetToggleUpEvent(self.__OnClickBlockExchangeButton)
		self.blockButtonList[1].SetToggleUpEvent(self.__OnClickBlockPartyButton)
		self.blockButtonList[2].SetToggleUpEvent(self.__OnClickBlockGuildButton)
		self.blockButtonList[3].SetToggleUpEvent(self.__OnClickBlockWhisperButton)
		self.blockButtonList[4].SetToggleUpEvent(self.__OnClickBlockFriendButton)
		self.blockButtonList[5].SetToggleUpEvent(self.__OnClickBlockPartyRequest)
		#self.blockButtonList[6].SetToggleUpEvent(self.__OnClickBlockViewEquipmentButton)
		#self.blockButtonList[6].SetToggleUpEvent(self.__OnClickBlockTecButton)

		self.blockButtonList[0].SetToggleDownEvent(self.__OnClickBlockExchangeButton)
		self.blockButtonList[1].SetToggleDownEvent(self.__OnClickBlockPartyButton)
		self.blockButtonList[2].SetToggleDownEvent(self.__OnClickBlockGuildButton)
		self.blockButtonList[3].SetToggleDownEvent(self.__OnClickBlockWhisperButton)
		self.blockButtonList[4].SetToggleDownEvent(self.__OnClickBlockFriendButton)
		self.blockButtonList[5].SetToggleDownEvent(self.__OnClickBlockPartyRequest)
		#self.blockButtonList[6].SetToggleDownEvent(self.__OnClickBlockViewEquipmentButton)
		#self.blockButtonList[6].SetToggleDownEvent(self.__OnClickBlockTecButton)

		self.viewChatButtonList[0].SAFE_SetEvent(self.__OnClickViewChatOnButton)
		self.viewChatButtonList[1].SAFE_SetEvent(self.__OnClickViewChatOffButton)

		self.alwaysShowNameButtonList[0].SAFE_SetEvent(self.__OnClickAlwaysShowNameOnButton)
		self.alwaysShowNameButtonList[1].SAFE_SetEvent(self.__OnClickAlwaysShowNameOffButton)

		self.showDamageButtonList[0].SAFE_SetEvent(self.__OnClickShowDamageOnButton)
		self.showDamageButtonList[1].SAFE_SetEvent(self.__OnClickShowDamageOffButton)
		
		self.showsalesTextButtonList[0].SAFE_SetEvent(self.__OnClickSalesTextOnButton)
		self.showsalesTextButtonList[1].SAFE_SetEvent(self.__OnClickSalesTextOffButton)		

		if app.WJ_SHOW_MOB_INFO:
			self.showMobInfoButtonList[0].SetToggleUpEvent(self.__OnClickShowMobLevelButton)
			self.showMobInfoButtonList[1].SetToggleUpEvent(self.__OnClickShowMobAIFlagButton)

			self.showMobInfoButtonList[0].SetToggleDownEvent(self.__OnClickShowMobLevelButton)
			self.showMobInfoButtonList[1].SetToggleDownEvent(self.__OnClickShowMobAIFlagButton)
		
		self.KarmiLao[0].SAFE_SetEvent(self._karvar)
		self.KarmiLao[1].SAFE_SetEvent(self._karyok)

		self.showNightButtonList[0].SAFE_SetEvent(self.__OnClickShowNightOnButton)
		self.showNightButtonList[1].SAFE_SetEvent(self.__OnClickShowNightOffButton)

		self.showKritik[0].SAFE_SetEvent(self.Kritikefektacik)
		self.showKritik[1].SAFE_SetEvent(self.Kritikefektkapali)
		
		# self.showDuello[0].SAFE_SetEvent(self.Acceefektacik)
		# self.showDuello[1].SAFE_SetEvent(self.Acceefektkapali)
		
		# self.showTest[0].SAFE_SetEvent(self.Binekefektacik)
		# self.showTest[1].SAFE_SetEvent(self.Binekefektkapali)
		
		# self.showMor[0].SAFE_SetEvent(self.morpotacik)
		# self.showMor[1].SAFE_SetEvent(self.morpotkapali)
		
		self.snowtexturesTextButtonList[0].SAFE_SetEvent(self.__OnClickShowSnowTextures)
		self.snowtexturesTextButtonList[1].SAFE_SetEvent(self.__OnClickHideSnowTextures)	

		self.AutoPickUpButtonList[0].SAFE_SetEvent(self.__OnClickEnableAutoPickUp)
		self.AutoPickUpButtonList[1].SAFE_SetEvent(self.__OnClickDisableAutoPickUp)
		
		self.showOfflineShopButtonList[0].SAFE_SetEvent(self.__OnClickOfflineShopOnButton)
		self.showOfflineShopButtonList[1].SAFE_SetEvent(self.__OnClickOfflineShopOffButton)

		#yangdrop
		# self.YangdropButtonList[0].SAFE_SetEvent(self.__OnClickEnableYangdrop)
		# self.YangdropButtonList[1].SAFE_SetEvent(self.__OnClickDisableYangdrop)
		#yangdrop
		
		self.petsButtonList[0].SAFE_SetEvent(self.__OnClickPetsOnButton)
		self.petsButtonList[1].SAFE_SetEvent(self.__OnClickPetsOffButton)
		
		self.mountsButtonList[0].SAFE_SetEvent(self.__OnClickMountsOnButton)
		self.mountsButtonList[1].SAFE_SetEvent(self.__OnClickMountsOffButton)
		
		self.__ClickRadioButton(self.nameColorModeButtonList, constInfo.GET_CHRNAME_COLOR_INDEX())
		self.__ClickRadioButton(self.viewTargetBoardButtonList, constInfo.GET_VIEW_OTHER_EMPIRE_PLAYER_TARGET_BOARD())
		self.__SetPeacePKMode()

		#global MOBILE
		if MOBILE:
			self.inputMobileButton.SetEvent(ui.__mem_func__(self.__OnChangeMobilePhoneNumber))
			self.deleteMobileButton.SetEvent(ui.__mem_func__(self.__OnDeleteMobilePhoneNumber))
		if app.ENABLE_SHOPNAMES_RANGE:
			self.ctrlShopNamesRange.SetSliderPos(float(systemSetting.GetShopNamesRange()))
			self.ctrlShopNamesRange.SetEvent(ui.__mem_func__(self.OnChangeShopNamesRange))

	if app.ENABLE_SHOPNAMES_RANGE:
		def OnChangeShopNamesRange(self):
			pos = self.ctrlShopNamesRange.GetSliderPos()
			systemSetting.SetShopNamesRange(pos)
			if systemSetting.IsShowSalesText():
				uiPrivateShopBuilder.UpdateADBoard()
				uiOfflineShopBuilder.UpdateADBoard()

	def __IsSpecialMap(self):
		Blocked_MAPS = [
			"season1/metin2_map_oxevent",
			"season2/metin2_map_guild_inside01",
			"season2/metin2_map_empirewar01",
			"season2/metin2_map_empirewar02",
			"season2/metin2_map_empirewar03",
			"metin2_map_dragon_timeattack_01",
			"metin2_map_dragon_timeattack_02",
			"metin2_map_dragon_timeattack_03",
			"metin2_map_skipia_dungeon_boss",
			"metin2_map_skipia_dungeon_boss2",
			"metin2_map_devilsCatacomb",
			"metin2_map_deviltower1",
			"metin2_map_t1",
			"metin2_map_t2",
			"metin2_map_t3",
			"metin2_map_t4",
			"metin2_map_t5",
			"metin2_map_wedding_01",
			"metin2_map_ring",
			"metin2_map_gemi",
			"gm_guild_build",
			"metin2_map_duel"
		]

		if str(background.GetCurrentMapName()) in Blocked_MAPS:
			return TRUE

		return FALSE
		
	def __ClickRadioButton(self, buttonList, buttonIndex):
		try:
			selButton=buttonList[buttonIndex]
		except IndexError:
			return

		for eachButton in buttonList:
			eachButton.SetUp()

		selButton.Down()

	def _karvar(self):
		background.SetEnvironmentData(1)
		background.EnableSnow(1)
		constInfo.Kar = 1
		self.RefreshShow()

	def _karyok(self):
		background.SetEnvironmentData(0)
		background.EnableSnow(0)
		constInfo.Kar = 0
		self.RefreshShow()

	def RefreshShow(self):
		if constInfo.Kar == 1:
			self.KarmiLao[0].Down()
			self.KarmiLao[1].SetUp()
		else:
			self.KarmiLao[0].SetUp()
			self.KarmiLao[1].Down()
			
	def Kritikefektacik(self):
		systemSetting.SetShowKritik(TRUE)
		chat.AppendChat(chat.CHAT_TYPE_INFO, officialfilesgame.KRITIKACIK)
		self.RefreshShowKritik()

	def Kritikefektkapali(self):
		systemSetting.SetShowKritik(FALSE)
		chat.AppendChat(chat.CHAT_TYPE_INFO, officialfilesgame.KRITIKKAPALI)
		self.RefreshShowKritik()
			
	def RefreshShowKritik(self):
		if systemSetting.IsShowKritik():
			self.showKritik[0].Down()
			self.showKritik[1].SetUp()
		else:
			self.showKritik[0].SetUp()
			self.showKritik[1].Down()
			
	# def Acceefektacik(self):
		# systemSetting.SetShowDuello(TRUE)
		# chat.AppendChat(chat.CHAT_TYPE_INFO, officialfilesgame.ACCEACIK)
		# self.RefreshShowDuello()

	# def Acceefektkapali(self):
		# systemSetting.SetShowDuello(FALSE)
		# chat.AppendChat(chat.CHAT_TYPE_INFO, officialfilesgame.ACCEKAPALI)
		# self.RefreshShowDuello()
			
	# def RefreshShowDuello(self):
		# if systemSetting.IsShowDuello():
			# self.showDuello[0].Down()
			# self.showDuello[1].SetUp()
		# else:
			# self.showDuello[0].SetUp()
			# self.showDuello[1].Down()
			
	# def Binekefektacik(self):
		# systemSetting.SetShowTest(TRUE)
		# chat.AppendChat(chat.CHAT_TYPE_INFO, officialfilesgame.BINEKACIK)
		# self.RefreshShowTest()

	# def Binekefektkapali(self):
		# systemSetting.SetShowTest(FALSE)
		# chat.AppendChat(chat.CHAT_TYPE_INFO, officialfilesgame.BINEKKAPALI)
		# self.RefreshShowTest()
			
	# def RefreshShowTest(self):
		# if systemSetting.IsShowTest():
			# self.showTest[0].Down()
			# self.showTest[1].SetUp()
		# else:
			# self.showTest[0].SetUp()
			# self.showTest[1].Down()
			
	# def morpotacik(self):
		# systemSetting.SetShowMor(TRUE)
		# chat.AppendChat(chat.CHAT_TYPE_INFO, officialfilesgame.MORPOTACIK)
		# self.RefreshShowMor()

	# def morpotkapali(self):
		# systemSetting.SetShowMor(FALSE)
		# chat.AppendChat(chat.CHAT_TYPE_INFO, officialfilesgame.MORPOTKAPALI)
		# self.RefreshShowMor()
			
	# def RefreshShowMor(self):
		# if systemSetting.IsShowMor():
			# self.showMor[0].Down()
			# self.showMor[1].SetUp()
		# else:
			# self.showMor[0].SetUp()
			# self.showMor[1].Down()
		
	def __OnClickShowSnowTextures(self):
		systemSetting.SetSnowTexturesMode(TRUE)
		self.RefreshShowSnowTextures()
		if background.GetCurrentMapName():
			snow_maps = [
				"metin2_map_a1",
				"metin2_map_b1",
				"metin2_map_c1"
			]
			snow_maps_textures = {
				"metin2_map_a1" : "textureset\metin2_a1_snow.txt",
				"metin2_map_b1" : "textureset\metin2_b1_snow.txt",
				"metin2_map_c1" : "textureset\metin2_c1_snow.txt", }
			if str(background.GetCurrentMapName()) in snow_maps:
				background.TextureChange(snow_maps_textures[str(background.GetCurrentMapName())])
				
	def __OnClickHideSnowTextures(self):
		systemSetting.SetSnowTexturesMode(FALSE)
		self.RefreshShowSnowTextures()
		if background.GetCurrentMapName():
			snow_maps = [
				"metin2_map_a1",
				"metin2_map_b1",
				"metin2_map_c1"
			]
			snow_maps_textures = {
				"metin2_map_a1" : "textureset\metin2_a1.txt",
				"metin2_map_b1" : "textureset\metin2_b1.txt",
				"metin2_map_c1" : "textureset\metin2_c1.txt", }
			if str(background.GetCurrentMapName()) in snow_maps:
				background.TextureChange(snow_maps_textures[str(background.GetCurrentMapName())])	
				
	
	def RefreshShowSnowTextures(self):
		if systemSetting.IsSnowTexturesMode():
			self.snowtexturesTextButtonList[0].Down()
			self.snowtexturesTextButtonList[1].SetUp()
		else:
			self.snowtexturesTextButtonList[0].SetUp()
			self.snowtexturesTextButtonList[1].Down()

	def __SetNameColorMode(self, index):
		constInfo.SET_CHRNAME_COLOR_INDEX(index)
		self.__ClickRadioButton(self.nameColorModeButtonList, index)

	def __SetTargetBoardViewMode(self, flag):
		constInfo.SET_VIEW_OTHER_EMPIRE_PLAYER_TARGET_BOARD(flag)
		self.__ClickRadioButton(self.viewTargetBoardButtonList, flag)

	def __OnClickNameColorModeNormalButton(self):
		self.__SetNameColorMode(0)

	def __OnClickNameColorModeEmpireButton(self):
		self.__SetNameColorMode(1)

	def __OnClickTargetBoardViewButton(self):
		self.__SetTargetBoardViewMode(0)

	def __OnClickTargetBoardNoViewButton(self):
		self.__SetTargetBoardViewMode(1)

	def __OnClickCameraModeShortButton(self):
		self.__SetCameraMode(0)

	def __OnClickCameraModeLongButton(self):
		self.__SetCameraMode(1)

	def __OnClickFogModeLevel0Button(self):
		self.__SetFogLevel(0)

	def __OnClickFogModeLevel1Button(self):
		self.__SetFogLevel(1)

	def __OnClickFogModeLevel2Button(self):
		self.__SetFogLevel(2)

	def __OnClickBlockExchangeButton(self):
		self.RefreshBlock()
		global blockMode
		net.SendChatPacket("/setblockmode " + str(blockMode ^ player.BLOCK_EXCHANGE))
	def __OnClickBlockPartyButton(self):
		self.RefreshBlock()
		global blockMode
		net.SendChatPacket("/setblockmode " + str(blockMode ^ player.BLOCK_PARTY))
	# def __OnClickBlockViewEquipmentButton(self):
		# self.RefreshBlock()
		# global blockMode
		# net.SendChatPacket("/setblockmode " + str(blockMode ^ player.BLOCK_VIEW_EQUIPMENT))
	def __OnClickBlockGuildButton(self):
		self.RefreshBlock()
		global blockMode
		net.SendChatPacket("/setblockmode " + str(blockMode ^ player.BLOCK_GUILD))
	def __OnClickBlockWhisperButton(self):
		self.RefreshBlock()
		global blockMode
		net.SendChatPacket("/setblockmode " + str(blockMode ^ player.BLOCK_WHISPER))
	def __OnClickBlockFriendButton(self):
		self.RefreshBlock()
		global blockMode
		net.SendChatPacket("/setblockmode " + str(blockMode ^ player.BLOCK_FRIEND))
	def __OnClickBlockPartyRequest(self):
		self.RefreshBlock()
		global blockMode
		net.SendChatPacket("/setblockmode " + str(blockMode ^ player.BLOCK_PARTY_REQUEST))
	# def __OnClickBlockTecButton(self):
		# #self.RefreshBlock()
		# global blockMode
		# net.SendChatPacket("/setblockmode " + str(blockMode ^ player.BLOCK_POINT_EXP))			

	def __OnClickViewChatOnButton(self):
		global viewChatMode
		viewChatMode = 1
		systemSetting.SetViewChatFlag(viewChatMode)
		self.RefreshViewChat()
	def __OnClickViewChatOffButton(self):
		global viewChatMode
		viewChatMode = 0
		systemSetting.SetViewChatFlag(viewChatMode)
		self.RefreshViewChat()

	def __OnClickAlwaysShowNameOnButton(self):
		systemSetting.SetAlwaysShowNameFlag(TRUE)
		self.RefreshAlwaysShowName()

	def __OnClickAlwaysShowNameOffButton(self):
		systemSetting.SetAlwaysShowNameFlag(FALSE)
		self.RefreshAlwaysShowName()

	def __OnClickShowDamageOnButton(self):
		systemSetting.SetShowDamageFlag(TRUE)
		self.RefreshShowDamage()

	def __OnClickShowDamageOffButton(self):
		systemSetting.SetShowDamageFlag(FALSE)
		self.RefreshShowDamage()
		
	def __OnClickSalesTextOnButton(self):
		systemSetting.SetShowSalesTextFlag(TRUE)
		self.RefreshShowSalesText()
		uiPrivateShopBuilder.UpdateADBoard()
		uiOfflineShopBuilder.UpdateADBoard()

	def __OnClickSalesTextOffButton(self):
		systemSetting.SetShowSalesTextFlag(FALSE)
		self.RefreshShowSalesText()	
	
	def __OnClickShowMobLevelButton(self):
		if app.WJ_SHOW_MOB_INFO:
			if systemSetting.IsShowMobLevel():
				systemSetting.SetShowMobLevel(False)
			else:
				systemSetting.SetShowMobLevel(True)

			self.RefreshShowMobInfo()

	def __OnClickShowMobAIFlagButton(self):
		if app.WJ_SHOW_MOB_INFO:
			if systemSetting.IsShowMobAIFlag():
				systemSetting.SetShowMobAIFlag(False)
			else:
				systemSetting.SetShowMobAIFlag(True)

			self.RefreshShowMobInfo()
	
	#Yangdrop
	# def __OnClickEnableYangdrop(self):
		# self.YangdropButtonList[0].Down()
		# self.YangdropButtonList[1].SetUp()

		# constInfo.YangDrop = 1
		# chat.AppendChat(chat.CHAT_TYPE_INFO, "|cffFFC125Yang Drop Bilgisi Gosterme Aktif.")

	# def __OnClickDisableYangdrop(self):
		# self.YangdropButtonList[0].SetUp()
		# self.YangdropButtonList[1].Down()

		# constInfo.YangDrop = 0
		# chat.AppendChat(chat.CHAT_TYPE_INFO, "|cffFFC125Yang Drop Gosterme Deaktif.")
	#Yangdrop
	
	def __OnClickPetsOffButton(self):
		systemSetting.SetShowPetsFlag(False)
		self.RefreshPets()
		
	def __OnClickMountsOnButton(self):
		systemSetting.SetShowMountsFlag(True)
		self.RefreshMounts()
	
	def __OnClickShowNightOnButton(self):
		background.RegisterEnvironmentData(1, constInfo.ENVIRONMENT_NIGHT)
		background.SetEnvironmentData(1)
		constInfo.Night = 1
		self.RefreshShowNightText()

	def __OnClickShowNightOffButton(self):
		background.SetEnvironmentData(0)
		constInfo.Night = 0
		self.RefreshShowNightText()

	def __OnClickEnableAutoPickUp(self):
		self.AutoPickUpButtonList[0].Down()
		self.AutoPickUpButtonList[1].SetUp()

		constInfo.AUTO_PICK_UP = 1
		chat.AppendChat(chat.CHAT_TYPE_INFO, "Auto-colectarea a fost activata!")

	def __OnClickDisableAutoPickUp(self):
		self.AutoPickUpButtonList[0].SetUp()
		self.AutoPickUpButtonList[1].Down()

		constInfo.AUTO_PICK_UP = 0
		chat.AppendChat(chat.CHAT_TYPE_INFO, "Auto-colectarea a fost dezactivata!")
		
	def __OnClickOfflineShopOnButton(self):
		systemSetting.SetShowOfflineShop(1)
		self.RefreshShowOfflineShop()
		uiPrivateShopBuilder.UpdateADBoard()
		uiOfflineShopBuilder.UpdateADBoard()
		
	def __OnClickOfflineShopWoOnButton(self):
		systemSetting.SetShowOfflineShop(2)
		self.RefreshShowOfflineShop()
		uiPrivateShopBuilder.UpdateADBoard()
		uiOfflineShopBuilder.UpdateADBoard()
	
	def __OnClickOfflineShopOffButton(self):
		systemSetting.SetShowOfflineShop(0)
		self.RefreshShowOfflineShop()
		uiPrivateShopBuilder.UpdateADBoard()	
	
	def __OnClickPetsOnButton(self):
		systemSetting.SetShowPetsFlag(True)
		self.RefreshPets()
		
	def __OnClickPetsOffButton(self):
		systemSetting.SetShowPetsFlag(False)
		self.RefreshPets()
		
	def __OnClickMountsOnButton(self):
		systemSetting.SetShowMountsFlag(True)
		self.RefreshMounts()
		
	def __OnClickMountsOffButton(self):
		systemSetting.SetShowMountsFlag(False)
		self.RefreshMounts()
	
	def __CheckPvPProtectedLevelPlayer(self):	
		if player.GetStatus(player.LEVEL)<constInfo.PVPMODE_PROTECTED_LEVEL:
			self.__SetPeacePKMode()
			chat.AppendChat(chat.CHAT_TYPE_INFO, localeInfo.OPTION_PVPMODE_PROTECT % (constInfo.PVPMODE_PROTECTED_LEVEL))
			return 1

		return 0

	def __SetPKMode(self, mode):
		for btn in self.pvpModeButtonDict.values():
			btn.SetUp()
		if self.pvpModeButtonDict.has_key(mode):
			self.pvpModeButtonDict[mode].Down()

	def __SetPeacePKMode(self):
		self.__SetPKMode(player.PK_MODE_PEACE)

	def __RefreshPVPButtonList(self):
		self.__SetPKMode(player.GetPKMode())
		
	if app.ENABLE_MELEY_LAIR_DUNGEON:
		def setMeleyMap(self):
			mapName = background.GetCurrentMapName()
			if mapName == "metin2_map_n_flame_dragon":
				if player.GetGuildID() != 0 and player.GetPKMode() != player.PK_MODE_GUILD:
					for btn in self.pvpModeButtonDict.values():
						btn.SetUp()
					
					net.SendChatPacket("/pkmode 4", chat.CHAT_TYPE_TALKING)
					self.pvpModeButtonDict[player.PK_MODE_GUILD].Down()

		def isMeleyMap(self, button):
			mapName = background.GetCurrentMapName()
			if mapName == "metin2_map_n_flame_dragon":
				if self.pvpModeButtonDict[button]:
					self.pvpModeButtonDict[button].SetUp()
				
				chat.AppendChat(chat.CHAT_TYPE_INFO, localeInfo.CANNOT_CHANGE_FIGHT_MODE)
				return 1
			
			return 0

	def __OnClickPvPModePeaceButton(self):
		if app.ENABLE_MELEY_LAIR_DUNGEON:
			if self.isMeleyMap(player.PK_MODE_PEACE):
				return
		if self.__CheckPvPProtectedLevelPlayer():
			return

		self.__RefreshPVPButtonList()

		if constInfo.PVPMODE_ENABLE:
			net.SendChatPacket("/pkmode 0", chat.CHAT_TYPE_TALKING)
		else:
			chat.AppendChat(chat.CHAT_TYPE_INFO, localeInfo.OPTION_PVPMODE_NOT_SUPPORT)

	def __OnClickPvPModeRevengeButton(self):
		if app.ENABLE_MELEY_LAIR_DUNGEON:
			if self.isMeleyMap(player.PK_MODE_REVENGE):
				return
		if self.__CheckPvPProtectedLevelPlayer():
			return

		self.__RefreshPVPButtonList()

		if constInfo.PVPMODE_ENABLE:
			net.SendChatPacket("/pkmode 1", chat.CHAT_TYPE_TALKING)
		else:
			chat.AppendChat(chat.CHAT_TYPE_INFO, localeInfo.OPTION_PVPMODE_NOT_SUPPORT)

	def __OnClickPvPModeFreeButton(self):
		if app.ENABLE_MELEY_LAIR_DUNGEON:
			if self.isMeleyMap(player.PK_MODE_FREE):
				return
		if self.__CheckPvPProtectedLevelPlayer():
			return

		self.__RefreshPVPButtonList()

		if constInfo.PVPMODE_ENABLE:
			net.SendChatPacket("/pkmode 2", chat.CHAT_TYPE_TALKING)
		else:
			chat.AppendChat(chat.CHAT_TYPE_INFO, localeInfo.OPTION_PVPMODE_NOT_SUPPORT)

	def __OnClickPvPModeGuildButton(self):
		if app.ENABLE_MELEY_LAIR_DUNGEON:
			if self.isMeleyMap(player.PK_MODE_GUILD):
				return
		if self.__CheckPvPProtectedLevelPlayer():
			return

		self.__RefreshPVPButtonList()

		if 0 == player.GetGuildID():
			chat.AppendChat(chat.CHAT_TYPE_INFO, localeInfo.OPTION_PVPMODE_CANNOT_SET_GUILD_MODE)
			return

		if constInfo.PVPMODE_ENABLE:
			net.SendChatPacket("/pkmode 4", chat.CHAT_TYPE_TALKING)
		else:
			chat.AppendChat(chat.CHAT_TYPE_INFO, localeInfo.OPTION_PVPMODE_NOT_SUPPORT)

	def OnChangePKMode(self):
		self.__RefreshPVPButtonList()

	def __OnChangeMobilePhoneNumber(self):
		global MOBILE
		if not MOBILE:
			return

		import uiCommon
		inputDialog = uiCommon.InputDialog()
		inputDialog.SetTitle(localeInfo.MESSENGER_INPUT_MOBILE_PHONE_NUMBER_TITLE)
		inputDialog.SetMaxLength(13)
		inputDialog.SetAcceptEvent(ui.__mem_func__(self.OnInputMobilePhoneNumber))
		inputDialog.SetCancelEvent(ui.__mem_func__(self.OnCloseInputDialog))
		inputDialog.Open()
		self.inputDialog = inputDialog

	def __OnDeleteMobilePhoneNumber(self):
		global MOBILE
		if not MOBILE:
			return

		import uiCommon
		questionDialog = uiCommon.QuestionDialog()
		questionDialog.SetText(localeInfo.MESSENGER_DO_YOU_DELETE_PHONE_NUMBER)
		questionDialog.SetAcceptEvent(ui.__mem_func__(self.OnDeleteMobile))
		questionDialog.SetCancelEvent(ui.__mem_func__(self.OnCloseQuestionDialog))
		questionDialog.Open()
		self.questionDialog = questionDialog

	def OnInputMobilePhoneNumber(self):
		global MOBILE
		if not MOBILE:
			return

		text = self.inputDialog.GetText()

		if not text:
			return

		text.replace('-', '')
		net.SendChatPacket("/mobile " + text)
		self.OnCloseInputDialog()
		return TRUE

	def OnInputMobileAuthorityCode(self):
		global MOBILE
		if not MOBILE:
			return

		text = self.inputDialog.GetText()
		net.SendChatPacket("/mobile_auth " + text)
		self.OnCloseInputDialog()
		return TRUE

	def OnDeleteMobile(self):
		global MOBILE
		if not MOBILE:
			return

		net.SendChatPacket("/mobile")
		self.OnCloseQuestionDialog()
		return TRUE

	def OnCloseInputDialog(self):
		self.inputDialog.Close()
		self.inputDialog = None
		return TRUE

	def OnCloseQuestionDialog(self):
		self.questionDialog.Close()
		self.questionDialog = None
		return TRUE

	def OnPressEscapeKey(self):
		self.Close()
		return TRUE

	def RefreshMobile(self):
		global MOBILE
		if not MOBILE:
			return

		if player.HasMobilePhoneNumber():
			self.inputMobileButton.Hide()
			self.deleteMobileButton.Show()
		else:
			self.inputMobileButton.Show()
			self.deleteMobileButton.Hide()

	def OnMobileAuthority(self):
		global MOBILE
		if not MOBILE:
			return

		import uiCommon
		inputDialog = uiCommon.InputDialogWithDescription()
		inputDialog.SetTitle(localeInfo.MESSENGER_INPUT_MOBILE_AUTHORITY_TITLE)
		inputDialog.SetDescription(localeInfo.MESSENGER_INPUT_MOBILE_AUTHORITY_DESCRIPTION)
		inputDialog.SetAcceptEvent(ui.__mem_func__(self.OnInputMobileAuthorityCode))
		inputDialog.SetCancelEvent(ui.__mem_func__(self.OnCloseInputDialog))
		inputDialog.SetMaxLength(4)
		inputDialog.SetBoardWidth(310)
		inputDialog.Open()
		self.inputDialog = inputDialog

	def RefreshBlock(self):
		global blockMode
		for i in xrange(len(self.blockButtonList)):
			if 0 != (blockMode & (1 << i)):
				self.blockButtonList[i].Down()
			else:
				self.blockButtonList[i].SetUp()

	def RefreshViewChat(self):
		if systemSetting.IsViewChat():
			self.viewChatButtonList[0].Down()
			self.viewChatButtonList[1].SetUp()
		else:
			self.viewChatButtonList[0].SetUp()
			self.viewChatButtonList[1].Down()

	def RefreshAlwaysShowName(self):
		if systemSetting.IsAlwaysShowName():
			self.alwaysShowNameButtonList[0].Down()
			self.alwaysShowNameButtonList[1].SetUp()
		else:
			self.alwaysShowNameButtonList[0].SetUp()
			self.alwaysShowNameButtonList[1].Down()

	def RefreshShowDamage(self):
		if systemSetting.IsShowDamage():
			self.showDamageButtonList[0].Down()
			self.showDamageButtonList[1].SetUp()
		else:
			self.showDamageButtonList[0].SetUp()
			self.showDamageButtonList[1].Down()
			
	def RefreshShowSalesText(self):
		if systemSetting.IsShowSalesText():
			self.showsalesTextButtonList[0].Down()
			self.showsalesTextButtonList[1].SetUp()
		else:
			self.showsalesTextButtonList[0].SetUp()
			self.showsalesTextButtonList[1].Down()
	
	def RefreshShowMobInfo(self):
		if app.WJ_SHOW_MOB_INFO:
			if systemSetting.IsShowMobLevel():
				self.showMobInfoButtonList[0].Down()
			else:
				self.showMobInfoButtonList[0].SetUp()

			if systemSetting.IsShowMobAIFlag():
				self.showMobInfoButtonList[1].Down()
			else:
				self.showMobInfoButtonList[1].SetUp()
	
	def RefreshShowOfflineShop(self):
		if systemSetting.IsShowOfflineShop() == 1:
			self.showOfflineShopButtonList[0].Down()
			self.showOfflineShopButtonList[1].SetUp()	
		else:
			self.showOfflineShopButtonList[0].SetUp()
			self.showOfflineShopButtonList[1].Down()
			
	def RefreshShowNightText(self):
		if constInfo.Night == 1:
			self.showNightButtonList[0].Down()
			self.showNightButtonList[1].SetUp()
		else:
			self.showNightButtonList[0].SetUp()
			self.showNightButtonList[1].Down()

	def RefreshPets(self):
		if systemSetting.IsShowPets():
			self.petsButtonList[0].Down()
			self.petsButtonList[1].SetUp()
		else:
			self.petsButtonList[0].SetUp()
			self.petsButtonList[1].Down()
			
	def RefreshMounts(self):
		if systemSetting.IsShowMounts():
			self.mountsButtonList[0].Down()
			self.mountsButtonList[1].SetUp()
		else:
			self.mountsButtonList[0].SetUp()
			self.mountsButtonList[1].Down()
	
	def OnBlockMode(self, mode):
		global blockMode
		blockMode = mode
		self.RefreshBlock()

	def Show(self):
		self.RefreshMobile()
		self.RefreshBlock()
		ui.ScriptWindow.Show(self)
		if app.ENABLE_MELEY_LAIR_DUNGEON:
			self.setMeleyMap()

	def Close(self):
		self.Hide()
