import ui
import grp
import player
import localeInfo

class Window(ui.ScriptWindow):
	def __init__(self):
		ui.ScriptWindow.__init__(self)
		self.isLoaded = 0
		self.PositionOut = 0
		self.PositionStartX = 0
		self.PositionStartY = 0
		self.titleBar = None
		self.scrollBar = None
		self.rankLine = None
		self.rankDataBackground = None
		self.rankData = None

	def __del__(self):
		ui.ScriptWindow.__del__(self)

	def Destroy(self):
		self.ClearDictionary()
		self.PositionOut = 0
		self.PositionStartX = 0
		self.PositionStartY = 0
		self.titleBar = None
		self.scrollBar = None
		self.rankLine = None
		self.rankDataBackground = None
		self.rankData = None

	def LoadWindow(self):
		if self.isLoaded:
			return
		
		self.isLoaded = 1
		
		try:
			pyScrLoader = ui.PythonScriptLoader()
			pyScrLoader.LoadScriptFile(self, "uiscript/dragonlairranking.py")
		except:
			import exception
			exception.Abort("GuildDragonLairWindow.LoadDialog.LoadScript")
		
		self.DIFFERENCE = 17
		self.BOARD_WIDTH = 368
		
		try:
			self.titleBar = self.GetChild("TitleBar")
			self.scrollBar = self.GetChild("GuildDragonLairScrollBar")
		except:
			import exception
			exception.Abort("GuildDragonLairWindow.LoadDialog.BindObject")
		
		#build
		self.rankLine = []
		self.rankData = {
							"ID" : [],
							"NAME" : [],
							"EMPIRE" : [],
							"KILL_COUNT" : [],
		}
		
		self.rankDataBackground = {
							"ID" : [],
							"NAME" : [],
							"EMPIRE" : [],
							"KILL_COUNT" : [],
		}
		
		str_lineDown = "d:/ymir work/ui/game/guild/dragonlairranking/line_down.sub"
		
		for i in xrange(16):
			lineStep = 24
			yPos = i * lineStep + 64
			if i == 15:
				yPos = i * lineStep + 75
			
			line = ui.MakeImageBox(self, str_lineDown, 22, yPos)
			self.rankLine.append(line)
			
			#ID_BACKGROUND = ui.MakeSlotBar(self.rankLine[i], 6, 2, 31, 16)
			ID_BACKGROUND = ui.Bar("TOP_MOST")
			ID_BACKGROUND.SetParent(self.rankLine[i])
			ID_BACKGROUND.SetPosition(6, 2)
			
			ID_BACKGROUND.SetSize(31, 16)
			ID_BACKGROUND.SetColor(grp.GenerateColor(0.0, 0.0, 0.0, 0.0))
			ID_BACKGROUND.Show()
			self.rankDataBackground["ID"].append(ID_BACKGROUND)
			
			#NAME_BACKGROUND = ui.MakeSlotBar(self.rankLine[i], 55, 2, 114, 16)
			NAME_BACKGROUND = ui.Bar("TOP_MOST")
			NAME_BACKGROUND.SetParent(self.rankLine[i])
			NAME_BACKGROUND.SetPosition(55, 2)
			
			NAME_BACKGROUND.SetSize(114, 16)
			NAME_BACKGROUND.SetColor(grp.GenerateColor(0.0, 0.0, 0.0, 0.0))
			NAME_BACKGROUND.Show()
			self.rankDataBackground["NAME"].append(NAME_BACKGROUND)
			
			#EMPIRE_BACKGROUND = ui.MakeSlotBar(self.rankLine[i], 192, 2, 22, 16)
			EMPIRE_BACKGROUND = ui.Bar("TOP_MOST")
			EMPIRE_BACKGROUND.SetParent(self.rankLine[i])
			EMPIRE_BACKGROUND.SetPosition(192, 2)
			
			EMPIRE_BACKGROUND.SetSize(22, 16)
			EMPIRE_BACKGROUND.SetColor(grp.GenerateColor(0.0, 0.0, 0.0, 0.0))
			EMPIRE_BACKGROUND.Show()
			self.rankDataBackground["EMPIRE"].append(EMPIRE_BACKGROUND)
			
			#KILL_COUNT_BACKGROUND = ui.MakeSlotBar(self.rankLine[i], 237, 2, 61, 16)
			KILL_COUNT_BACKGROUND = ui.Bar("TOP_MOST")
			KILL_COUNT_BACKGROUND.SetParent(self.rankLine[i])
			KILL_COUNT_BACKGROUND.SetPosition(241, 2)
			
			KILL_COUNT_BACKGROUND.SetSize(61, 16)
			KILL_COUNT_BACKGROUND.SetColor(grp.GenerateColor(0.0, 0.0, 0.0, 0.0))
			KILL_COUNT_BACKGROUND.Show()
			self.rankDataBackground["KILL_COUNT"].append(KILL_COUNT_BACKGROUND)
			
			ID = ui.MakeTextLine(self.rankDataBackground["ID"][i])
			NAME = ui.MakeTextLine(self.rankDataBackground["NAME"][i])
			EMPIRE = ui.MakeImageBox(self.rankDataBackground["EMPIRE"][i], "d:/ymir work/ui/game/rank/empire_0.sub", -7, 0)
			KILL_COUNT = ui.MakeTextLine(self.rankDataBackground["KILL_COUNT"][i])
			self.rankData["ID"].append(ID)
			self.rankData["NAME"].append(NAME)
			self.rankData["EMPIRE"].append(EMPIRE)
			self.rankData["KILL_COUNT"].append(KILL_COUNT)
		
		#self.AddRank(0, "Staff", "24", "23 minutes")
		self.AddRank(15, "-", "0", "-", "-")
		self.scrollBar.SetMiddleBarSize(0.95)
		self.titleBar.SetCloseEvent(ui.__mem_func__(self.Close))

	def AddRank(self, line, name, empire, kill_count, last = None):
		if self.rankData != None:
			str_lineUp = "d:/ymir work/ui/game/guild/dragonlairranking/line_up.sub"
			str_lineDown = "d:/ymir work/ui/game/guild/dragonlairranking/line_down.sub"
			
			if self.rankData["ID"][line]:
				if last != None:
					self.rankData["ID"][line].SetText(str(last))
				else:
					self.rankData["ID"][line].SetText(str(line + 1))
				
				self.rankData["NAME"][line].SetText(str(name))
				#self.rankData["EMPIRE"][line].SetText(str(empire))
				self.rankData["EMPIRE"][line].LoadImage("d:/ymir work/ui/game/rank/empire_%s.sub" % empire)
				self.rankData["KILL_COUNT"][line].SetText(str(kill_count))
				
				if player.GetGuildName() == str(name):
					self.rankLine[line].LoadImage(str_lineUp)
				else:
					self.rankLine[line].LoadImage(str_lineDown)

	def IsOpened(self):
		if self.IsShow() and self.isLoaded:
			return True
		
		return False

	def Open(self):
		if self.IsOpened():
			return
		
		for i in xrange(16):
			self.AddRank(i, "", "0", "", "")
		
		self.PositionOut = 0
		(self.PositionStartX, self.PositionStartY, z) = player.GetMainCharacterPosition()
		self.Show()

	def Close(self):
		self.Hide()

	def OnPressEscapeKey(self):
		self.Close()
		return True

	def OnUpdate(self):
		LIMIT_RANGE = 1000
		(x, y, z) = player.GetMainCharacterPosition()
		if abs(x - self.PositionStartX) >= LIMIT_RANGE or abs(y - self.PositionStartY) >= LIMIT_RANGE:
			if not self.PositionOut:
				self.PositionOut += 1
				self.Close()

