import chr
import chrmgr
import skill
import net
import item
import player
import effect
import constInfo
import localeInfo
import emotion

import app

JOB_WARRIOR		= 0
JOB_ASSASSIN	= 1
JOB_SURA		= 2
JOB_SHAMAN		= 3
JOB_WOLFMAN		= 4

RACE_WARRIOR_M	= 0
RACE_ASSASSIN_W	= 1
RACE_SURA_M		= 2
RACE_SHAMAN_W	= 3
RACE_WARRIOR_W	= 4
RACE_ASSASSIN_M	= 5
RACE_SURA_W		= 6
RACE_SHAMAN_M	= 7
RACE_WOLFMAN_M	= 8

COMBO_TYPE_1 = 0
COMBO_TYPE_2 = 1
COMBO_TYPE_3 = 2

COMBO_INDEX_1 = 0
COMBO_INDEX_2 = 1
COMBO_INDEX_3 = 2
COMBO_INDEX_4 = 3
COMBO_INDEX_5 = 4
COMBO_INDEX_6 = 5

HORSE_SKILL_WILDATTACK = chr.MOTION_SKILL+121
HORSE_SKILL_CHARGE = chr.MOTION_SKILL+122
HORSE_SKILL_SPLASH = chr.MOTION_SKILL+123

GUILD_SKILL_DRAGONBLOOD = chr.MOTION_SKILL+101
GUILD_SKILL_DRAGONBLESS = chr.MOTION_SKILL+102
GUILD_SKILL_BLESSARMOR = chr.MOTION_SKILL+103
GUILD_SKILL_SPPEDUP = chr.MOTION_SKILL+104
GUILD_SKILL_DRAGONWRATH = chr.MOTION_SKILL+105
GUILD_SKILL_MAGICUP = chr.MOTION_SKILL+106

PASSIVE_GUILD_SKILL_INDEX_LIST = ( 151, )
ACTIVE_GUILD_SKILL_INDEX_LIST = ( 152, 153, 154, 155, 156, 157, )

NEW_678TH_SKILL_ENABLE = 0
SKILL_INDEX_DICT = []

def DefineSkillIndexDict():
	global NEW_678TH_SKILL_ENABLE
	global SKILL_INDEX_DICT
	
	NEW_678TH_SKILL_ENABLE = localeInfo.IsYMIR()
	if NEW_678TH_SKILL_ENABLE:
		SKILL_INDEX_DICT = {
			JOB_WARRIOR : { 
				1 : (1, 2, 3, 4, 5, 6, 0, 0, 137, 0, 138, 0, 139, 0,), 
				2 : (16, 17, 18, 19, 20, 21, 0, 0, 137, 0, 138, 0, 139, 0,), 
				"SUPPORT" : (122, 123, 121, 124, 125, 129, 0, 0, 130, 131, 141, 142,),
			},
			JOB_ASSASSIN : { 
				1 : (31, 32, 33, 34, 35, 36, 0, 0, 137, 0, 138, 0, 139, 0, 140,), 
				2 : (46, 47, 48, 49, 50, 51, 0, 0, 137, 0, 138, 0, 139, 0, 140,), 
				"SUPPORT" : (122, 123, 121, 124, 125, 129, 0, 0, 130, 131, 141, 142,),
			},
			JOB_SURA : { 
				1 : (61, 62, 63, 64, 65, 66, 0, 0, 137, 0, 138, 0, 139, 0,),
				2 : (76, 77, 78, 79, 80, 81, 0, 0, 137, 0, 138, 0, 139, 0,),
				"SUPPORT" : (122, 123, 121, 124, 125, 129, 0, 0, 130, 131, 141, 142,),
			},
			JOB_SHAMAN : { 
				1 : (91, 92, 93, 94, 95, 96, 0, 0, 137, 0, 138, 0, 139, 0,),
				2 : (106, 107, 108, 109, 110, 111, 0, 0, 137, 0, 138, 0, 139, 0,),
				"SUPPORT" : (122, 123, 121, 124, 125, 129, 0, 0, 130, 131, 141, 142,),
			},
		}
	else:
		SKILL_INDEX_DICT = {
			JOB_WARRIOR : { 
				1 : (1, 2, 3, 4, 5, 6, 0, 0, 137, 0, 138, 0, 139, 0,), 
				2 : (16, 17, 18, 19, 20, 21, 0, 0, 137, 0, 138, 0, 139, 0,), 
				"SUPPORT" : (122, 123, 121, 124, 125, 129, 0, 0, 130, 131, 141, 142),
			},
			JOB_ASSASSIN : { 
				1 : (31, 32, 33, 34, 35, 36, 0, 0, 137, 0, 138, 0, 139, 0, 140,), 
				2 : (46, 47, 48, 49, 50, 51, 0, 0, 137, 0, 138, 0, 139, 0, 140,), 
				"SUPPORT" : (122, 123, 121, 124, 125, 129, 0, 0, 130, 131, 141, 142),
			},
			JOB_SURA : { 
				1 : (61, 62, 63, 64, 65, 66, 0, 0, 137, 0, 138, 0, 139, 0,),
				2 : (76, 77, 78, 79, 80, 81, 0, 0, 137, 0, 138, 0, 139, 0,),
				"SUPPORT" : (122, 123, 121, 124, 125, 129, 0, 0, 130, 131, 141, 142),
			},
			JOB_SHAMAN : { 
				1 : (91, 92, 93, 94, 95, 96, 0, 0, 137, 0, 138, 0, 139, 0,),
				2 : (106, 107, 108, 109, 110, 111, 0, 0, 137, 0, 138, 0, 139, 0,),
				"SUPPORT" : (122, 123, 121, 124, 125, 129, 0, 0, 130, 131, 141, 142),
			},
			JOB_WOLFMAN : {
				1 : (170, 171, 172, 173, 174, 175, 0, 0, 137, 0, 138, 0, 139, 0,),
				"SUPPORT" : (122, 123, 121, 124, 125, 129, 0, 0, 130, 131, 141, 142),
			}
		}

def RegisterSkill(race, group, empire=0):

	DefineSkillIndexDict()
	
	job = chr.RaceToJob(race)

	## Character Skill
	if SKILL_INDEX_DICT.has_key(job):

		if SKILL_INDEX_DICT[job].has_key(group):
		
			activeSkillList = SKILL_INDEX_DICT[job][group]

			for i in xrange(len(activeSkillList)):
				skillIndex = activeSkillList[i]
				
				## 7 8 ų ⼭ ϸ ȵ
				if i != 6 and i != 7:
					player.SetSkill(i+1, skillIndex)

			supportSkillList = SKILL_INDEX_DICT[job]["SUPPORT"]

			for i in xrange(len(supportSkillList)):
				player.SetSkill(i+100+1, supportSkillList[i])

	## Language Skill
	if 0 != empire:
		languageSkillList = []
		for i in xrange(3):
			if (i+1) != empire:
				languageSkillList.append(player.SKILL_INDEX_LANGUAGE1+i)
		for i in xrange(len(languageSkillList)):
			player.SetSkill(107+i, languageSkillList[i])

	## Guild Skill
	for i in xrange(len(PASSIVE_GUILD_SKILL_INDEX_LIST)):
		player.SetSkill(200+i, PASSIVE_GUILD_SKILL_INDEX_LIST[i])

	for i in xrange(len(ACTIVE_GUILD_SKILL_INDEX_LIST)):
		player.SetSkill(210+i, ACTIVE_GUILD_SKILL_INDEX_LIST[i])

def RegisterSkillAt(race, group, pos, num):
	
	DefineSkillIndexDict()
	
	job = chr.RaceToJob(race)
	tmp = list(SKILL_INDEX_DICT[job][group])
	tmp[pos] = num
	SKILL_INDEX_DICT[job][group] = tuple(tmp)
	player.SetSkill(pos+1, num)

FACE_IMAGE_DICT = {
	RACE_WARRIOR_M	: "d:/ymir work/ui/game/windows/face_warrior.sub",
	RACE_ASSASSIN_W	: "d:/ymir work/ui/game/windows/face_assassin.sub",
	RACE_SURA_M	: "d:/ymir work/ui/game/windows/face_sura.sub",
	RACE_SHAMAN_W	: "d:/ymir work/ui/game/windows/face_shaman.sub",
}

isInitData=0

def SetGeneralMotions(mode, folder):
	chrmgr.SetPathName(folder)
	chrmgr.RegisterMotionMode(mode)
	chrmgr.RegisterCacheMotionData(mode,		chr.MOTION_WAIT,				"wait.msa")
	chrmgr.RegisterCacheMotionData(mode,		chr.MOTION_WALK,				"walk.msa")
	chrmgr.RegisterCacheMotionData(mode,		chr.MOTION_RUN,					"run.msa")
	chrmgr.RegisterCacheMotionData(mode,		chr.MOTION_DAMAGE,				"damage.msa", 50)
	chrmgr.RegisterCacheMotionData(mode,		chr.MOTION_DAMAGE,				"damage_1.msa", 50)
	chrmgr.RegisterCacheMotionData(mode,		chr.MOTION_DAMAGE_BACK,			"damage_2.msa", 50)
	chrmgr.RegisterCacheMotionData(mode,		chr.MOTION_DAMAGE_BACK,			"damage_3.msa", 50)
	chrmgr.RegisterCacheMotionData(mode,		chr.MOTION_DAMAGE_FLYING,		"damage_flying.msa")
	chrmgr.RegisterCacheMotionData(mode,		chr.MOTION_STAND_UP,			"falling_stand.msa")
	chrmgr.RegisterCacheMotionData(mode,		chr.MOTION_DAMAGE_FLYING_BACK,	"back_damage_flying.msa")
	chrmgr.RegisterCacheMotionData(mode,		chr.MOTION_STAND_UP_BACK,		"back_falling_stand.msa")
	chrmgr.RegisterCacheMotionData(mode,		chr.MOTION_DEAD,				"dead.msa")
	chrmgr.RegisterCacheMotionData(mode,		chr.MOTION_DIG,					"dig.msa")
	
def SetGeneralMotionsForWolfman(mode, folder):
	chrmgr.SetPathName(folder)
	chrmgr.RegisterMotionMode(mode)
	chrmgr.RegisterCacheMotionData(mode,		chr.MOTION_WAIT,				"wait.msa")
	chrmgr.RegisterCacheMotionData(mode,		chr.MOTION_WALK,				"walk.msa")
	chrmgr.RegisterCacheMotionData(mode,		chr.MOTION_RUN,					"run.msa")
	chrmgr.RegisterCacheMotionData(mode,		chr.MOTION_DAMAGE,				"back_damage.msa", 50)
	chrmgr.RegisterCacheMotionData(mode,		chr.MOTION_DAMAGE,				"back_damage.msa", 50)
	chrmgr.RegisterCacheMotionData(mode,		chr.MOTION_DAMAGE_BACK,			"back_damage.msa", 50)
	chrmgr.RegisterCacheMotionData(mode,		chr.MOTION_DAMAGE_BACK,			"back_damage1.msa", 50)
	chrmgr.RegisterCacheMotionData(mode,		chr.MOTION_DAMAGE_FLYING,		"back_damage_flying.msa")
	chrmgr.RegisterCacheMotionData(mode,		chr.MOTION_STAND_UP,			"front_falling_standup.msa")
	chrmgr.RegisterCacheMotionData(mode,		chr.MOTION_DAMAGE_FLYING_BACK,	"back_damage_flying.msa")
	chrmgr.RegisterCacheMotionData(mode,		chr.MOTION_STAND_UP_BACK,		"back_falling_standup.msa")
	chrmgr.RegisterCacheMotionData(mode,		chr.MOTION_DEAD,				"dead.msa")
	chrmgr.RegisterCacheMotionData(mode,		chr.MOTION_DIG,					"dig.msa")

def SetIntroMotions(mode, folder):
	chrmgr.SetPathName(folder)
	chrmgr.RegisterMotionMode(mode)
	chrmgr.RegisterCacheMotionData(mode,		chr.MOTION_INTRO_WAIT,			"wait.msa")
	chrmgr.RegisterCacheMotionData(mode,		chr.MOTION_INTRO_SELECTED,		"selected.msa")
	chrmgr.RegisterCacheMotionData(mode,		chr.MOTION_INTRO_NOT_SELECTED,	"not_selected.msa")



def __InitData():
	global isInitData

	if isInitData:
		return			

	isInitData = 1

	chrmgr.SetDustGap(250)
	chrmgr.SetHorseDustGap(500)

	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_DUST, "", "d:/ymir work/effect/etc/dust/dust.mse")
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_HORSE_DUST, "", "d:/ymir work/effect/etc/dust/running_dust.mse")
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_HIT, "", "d:/ymir work/effect/hit/blow_1/blow_1_low.mse")

	if (app.WJ_COMBAT_ZONE):
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_COMBAT_ZONE_POTION, "", "d:/ymir work/effect/etc/buff/buff_item12.mse")
	
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_HPUP_RED, "", "d:/ymir work/effect/etc/recuperation/drugup_red.mse")
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_SPUP_BLUE, "", "d:/ymir work/effect/etc/recuperation/drugup_blue.mse")
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_SPEEDUP_GREEN, "", "d:/ymir work/effect/etc/recuperation/drugup_green.mse")
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_DXUP_PURPLE, "", "d:/ymir work/effect/etc/recuperation/drugup_purple.mse")

	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_AUTO_HPUP, "", "d:/ymir work/effect/etc/recuperation/autodrugup_red.mse")
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_AUTO_SPUP, "", "d:/ymir work/effect/etc/recuperation/autodrugup_blue.mse")
	
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_RAMADAN_RING_EQUIP, "", "d:/ymir work/effect/etc/buff/buff_item1.mse")
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_EQUIP_RUZGAR, "", "d:/ymir work/effect/etc/ruzgar/ruzgar.mse")
	
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_HALLOWEEN_CANDY_EQUIP, "", "d:/ymir work/effect/etc/buff/buff_item2.mse")
	
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_HAPPINESS_RING_EQUIP, "", "d:/ymir work/effect/etc/buff/buff_item3.mse")

	# ҴƮ  ߵ Ʈ
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_LOVE_PENDANT_EQUIP, "", "d:/ymir work/effect/etc/buff/buff_item4.mse")
	if app.VERSION_162_ENABLED:
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_HEALER, "", "d:/ymir work/effect/monster2/healer/healer_effect.mse")
	
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_DUEL_VICTIM, "", "d:/ymir work/effect/Jin_Han/work/JinHanDuelEffectVictim.mse")
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_DUEL_KILLER, "", "d:/ymir work/effect/Jin_Han/work/JinHanDuelEffectKiller.mse")
	
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_DUEL_SENDER, "", "d:/ymir work/effect/Jin_Han/work/EFECT_DUEL_Jin_Han_Sender.mse")
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_DUEL_RECEIVER, "", "d:/ymir work/effect/Jin_Han/work/EFECT_DUEL_Jin_Han_Receiver.mse")
	
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_DUEL_5, "", "d:/ymir work/effect/Jin_Han/work/Jin_Han_Duel_5.mse")
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_DUEL_4, "", "d:/ymir work/effect/Jin_Han/work/Jin_Han_Duel_4.mse")
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_DUEL_3, "", "d:/ymir work/effect/Jin_Han/work/Jin_Han_Duel_3.mse")
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_DUEL_2, "", "d:/ymir work/effect/Jin_Han/work/Jin_Han_Duel_2.mse")
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_DUEL_1, "", "d:/ymir work/effect/Jin_Han/work/Jin_Han_Duel_1.mse")
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_DUEL_0, "", "d:/ymir work/effect/Jin_Han/work/Jin_Han_Duel_0.mse")
	if app.ENABLE_SASH_SYSTEM:
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_SASH_SUCCEDED, "", "d:/ymir work/effect/etc/buff/buff_item6.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_SASH_EQUIP, "", "d:/ymir work/effect/etc/buff/buff_item7.mse")
	if app.ENABLE_MOUNT_SYSTEM:
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_1, "", "d:/ymir work/effect/etc/buff/mount_1.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_2, "", "d:/ymir work/effect/etc/buff/mount_2.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_3, "", "d:/ymir work/effect/etc/buff/mount_3.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_4, "", "d:/ymir work/effect/etc/buff/mount_4.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_5, "", "d:/ymir work/effect/etc/buff/mount_5.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_6, "", "d:/ymir work/effect/etc/buff/mount_6.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_7, "", "d:/ymir work/effect/etc/buff/mount_7.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_8, "", "d:/ymir work/effect/etc/buff/mount_8.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_9, "", "d:/ymir work/effect/etc/buff/mount_9.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_10, "", "d:/ymir work/effect/etc/buff/mount_10.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_11, "", "d:/ymir work/effect/etc/buff/mount_11.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_12, "", "d:/ymir work/effect/etc/buff/mount_12.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_13, "", "d:/ymir work/effect/etc/buff/mount_13.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_14, "", "d:/ymir work/effect/etc/buff/mount_14.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_15, "", "d:/ymir work/effect/etc/buff/mount_15.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_16, "", "d:/ymir work/effect/etc/buff/mount_16.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_17, "", "d:/ymir work/effect/etc/buff/mount_17.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_18, "", "d:/ymir work/effect/etc/buff/mount_18.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_19, "", "d:/ymir work/effect/etc/buff/mount_19.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_20, "", "d:/ymir work/effect/etc/buff/mount_20.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_21, "", "d:/ymir work/effect/etc/buff/mount_21.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_22, "", "d:/ymir work/effect/etc/buff/mount_22.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_23, "", "d:/ymir work/effect/etc/buff/buff_item11.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_24, "", "d:/ymir work/effect/etc/buff/mount_24.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_25, "", "d:/ymir work/effect/etc/buff/mount_25.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_26, "", "d:/ymir work/effect/etc/buff/mount_26.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_27, "", "d:/ymir work/effect/etc/buff/mount_27.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_28, "", "d:/ymir work/effect/etc/buff/mount_28.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_29, "", "d:/ymir work/effect/etc/buff/mount_29.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_30, "", "d:/ymir work/effect/etc/buff/mount_30.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_31, "", "d:/ymir work/effect/etc/buff/mount_31.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_32, "", "d:/ymir work/effect/etc/buff/mount_32.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_33, "", "d:/ymir work/effect/etc/buff/mount_33.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_34, "", "d:/ymir work/effect/etc/buff/mount_34.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_35, "", "d:/ymir work/effect/etc/buff/mount_35.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_36, "", "d:/ymir work/effect/etc/buff/mount_36.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_37, "", "d:/ymir work/effect/etc/buff/mount_37.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_38, "", "d:/ymir work/effect/etc/buff/mount_38.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_39, "", "d:/ymir work/effect/etc/buff/mount_39.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_40, "", "d:/ymir work/effect/etc/buff/mount_40.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_41, "", "d:/ymir work/effect/etc/buff/mount_41.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_42, "", "d:/ymir work/effect/etc/buff/mount_42.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_43, "", "d:/ymir work/effect/etc/buff/mount_43.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_44, "", "d:/ymir work/effect/etc/buff/mount_44.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_45, "", "d:/ymir work/effect/etc/buff/mount_45.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_46, "", "d:/ymir work/effect/etc/buff/mount_46.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_47, "", "d:/ymir work/effect/etc/buff/mount_47.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_48, "", "d:/ymir work/effect/etc/buff/mount_48.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_49, "", "d:/ymir work/effect/etc/buff/mount_49.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_50, "", "d:/ymir work/effect/etc/buff/mount_50.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_51, "", "d:/ymir work/effect/etc/buff/mount_51.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_52, "", "d:/ymir work/effect/etc/buff/mount_52.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_53, "", "d:/ymir work/effect/etc/buff/mount_53.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_54, "", "d:/ymir work/effect/etc/buff/mount_54.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_55, "", "d:/ymir work/effect/etc/buff/mount_55.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_56, "", "d:/ymir work/effect/etc/buff/mount_56.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_57, "", "d:/ymir work/effect/etc/buff/mount_57.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_58, "", "d:/ymir work/effect/etc/buff/mount_58.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_59, "", "d:/ymir work/effect/etc/buff/mount_59.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_60, "", "d:/ymir work/effect/etc/buff/mount_60.mse")
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MOUNT_61, "", "d:/ymir work/effect/etc/buff/mount_61.mse")						

	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_PENETRATE, "Bip01", "d:/ymir work/effect/hit/gwantong.mse")
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_FIRECRACKER, "", "d:/ymir work/effect/etc/firecracker/newyear_firecracker.mse")
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_SPIN_TOP, "", "d:/ymir work/effect/etc/firecracker/paing_i.mse")
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_SELECT, "", "d:/ymir work/effect/etc/click/click_select.mse")
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_TARGET, "", "d:/ymir work/effect/etc/click/click_glow_select.mse")
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_STUN, "Bip01 Head", "d:/ymir work/effect/etc/stun/stun.mse")
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_SHINSOO, "", "d:/ymir work/effect/world/shinsoo_select.mse")
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_TARGET_SHINSOO, "", "d:/ymir work/effect/world/shinsoo_glow_select.mse")
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_CHUNJO, "", "d:/ymir work/effect/world/chunjo_select.mse")
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_TARGET_CHUNJO, "", "d:/ymir work/effect/world/chunjo_glow_select.mse")
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_JINNOS, "", "d:/ymir work/effect/world/jinnos_select.mse")
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_TARGET_JINNOS, "", "d:/ymir work/effect/world/jinnos_glow_select.mse")
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_MONSTER, "", "d:/ymir work/effect/world/mob_select.mse")
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_TARGET_MONSTER, "", "d:/ymir work/effect/world/mob_glow_select.mse")
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_STONE, "", "d:/ymir work/effect/world/stone_select.mse")
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_TARGET_STONE, "", "d:/ymir work/effect/world/stone_glow_select.mse")	
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_CRITICAL, "Bip01 R Hand", "d:/ymir work/effect/hit/critical.mse")
	player.RegisterCacheEffect(player.EFFECT_PICK, "d:/ymir work/effect/etc/click/click.mse")

	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_DAMAGE_TARGET, "", "d:/ymir work/effect/affect/damagevalue/target.mse")
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_DAMAGE_NOT_TARGET, "", "d:/ymir work/effect/affect/damagevalue/nontarget.mse")
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_DAMAGE_SELFDAMAGE, "", "d:/ymir work/effect/affect/damagevalue/damage.mse")
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_DAMAGE_SELFDAMAGE2, "", "d:/ymir work/effect/affect/damagevalue/damage_1.mse")
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_DAMAGE_POISON, "", "d:/ymir work/effect/affect/damagevalue/poison.mse")
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_DAMAGE_MISS, "", "d:/ymir work/effect/affect/damagevalue/miss.mse")
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_DAMAGE_TARGETMISS, "", "d:/ymir work/effect/affect/damagevalue/target_miss.mse")
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_DAMAGE_CRITICAL, "", "d:/ymir work/effect/affect/damagevalue/critical.mse")
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_DAMAGE_BLEEDING, "", "d:/ymir work/effect/affect/damagevalue/bleed.mse")
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_DAMAGE_FIRE, "", "d:/ymir work/effect/affect/damagevalue/burn.mse")
	
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_LEVELUP_ON_14_FOR_GERMANY, "","season1/effect/paymessage_warning.mse")	# 14϶ (  )
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_LEVELUP_UNDER_15_FOR_GERMANY, "", "season1/effect/paymessage_decide.mse" )# 15϶ (  )

	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_PERCENT_DAMAGE1, "", "d:/ymir work/effect/hit/percent_damage1.mse")
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_PERCENT_DAMAGE2, "", "d:/ymir work/effect/hit/percent_damage2.mse")
	chrmgr.RegisterCacheEffect(chrmgr.EFFECT_PERCENT_DAMAGE3, "", "d:/ymir work/effect/hit/percent_damage3.mse")
	

	##############
	# WARRIOR
	##############
	chrmgr.CreateRace(RACE_WARRIOR_M)
	chrmgr.SelectRace(RACE_WARRIOR_M)	
	chrmgr.LoadLocalRaceData("warrior_m.msm")
	SetIntroMotions(chr.MOTION_MODE_GENERAL, "d:/ymir work/pc/warrior/intro/")

	chrmgr.CreateRace(RACE_WARRIOR_W)
	chrmgr.SelectRace(RACE_WARRIOR_W)	
	chrmgr.LoadLocalRaceData("warrior_w.msm")
	SetIntroMotions(chr.MOTION_MODE_GENERAL, "d:/ymir work/pc2/warrior/intro/")


	##############
	# ASSASSIN
	##############
	chrmgr.CreateRace(RACE_ASSASSIN_W)
	chrmgr.SelectRace(RACE_ASSASSIN_W)
	chrmgr.LoadLocalRaceData("assassin_w.msm")
	SetIntroMotions(chr.MOTION_MODE_GENERAL, "d:/ymir work/pc/assassin/intro/")

	chrmgr.CreateRace(RACE_ASSASSIN_M)
	chrmgr.SelectRace(RACE_ASSASSIN_M)
	chrmgr.LoadLocalRaceData("assassin_m.msm")
	SetIntroMotions(chr.MOTION_MODE_GENERAL, "d:/ymir work/pc2/assassin/intro/")


	##############
	# SURA
	##############
	chrmgr.CreateRace(RACE_SURA_M)
	chrmgr.SelectRace(RACE_SURA_M)	
	chrmgr.LoadLocalRaceData("sura_m.msm")
	SetIntroMotions(chr.MOTION_MODE_GENERAL, "d:/ymir work/pc/sura/intro/")

	chrmgr.CreateRace(RACE_SURA_W)
	chrmgr.SelectRace(RACE_SURA_W)	
	chrmgr.LoadLocalRaceData("sura_w.msm")
	SetIntroMotions(chr.MOTION_MODE_GENERAL, "d:/ymir work/pc2/sura/intro/")


	##############
	# SHAMAN
	##############
	chrmgr.CreateRace(RACE_SHAMAN_W)
	chrmgr.SelectRace(RACE_SHAMAN_W)
	chrmgr.LoadLocalRaceData("shaman_w.msm")
	SetIntroMotions(chr.MOTION_MODE_GENERAL, "d:/ymir work/pc/shaman/intro/")

	chrmgr.CreateRace(RACE_SHAMAN_M)
	chrmgr.SelectRace(RACE_SHAMAN_M)
	chrmgr.LoadLocalRaceData("shaman_m.msm")
	SetIntroMotions(chr.MOTION_MODE_GENERAL, "d:/ymir work/pc2/shaman/intro/")
	
	##############
	# WOLFMAN
	##############
	chrmgr.CreateRace(RACE_WOLFMAN_M)
	chrmgr.SelectRace(RACE_WOLFMAN_M)	
	chrmgr.LoadLocalRaceData("wolfman_m.msm")
	SetIntroMotions(chr.MOTION_MODE_GENERAL, "d:/ymir work/pc3/wolfman/intro/")



def __LoadGameSound():
	item.SetUseSoundFileName(item.USESOUND_DEFAULT, "sound/ui/drop.wav")
	item.SetUseSoundFileName(item.USESOUND_ACCESSORY, "sound/ui/equip_ring_amulet.wav")
	item.SetUseSoundFileName(item.USESOUND_ARMOR, "sound/ui/equip_metal_armor.wav")
	item.SetUseSoundFileName(item.USESOUND_BOW, "sound/ui/equip_bow.wav")
	item.SetUseSoundFileName(item.USESOUND_WEAPON, "sound/ui/equip_metal_weapon.wav")
	item.SetUseSoundFileName(item.USESOUND_POTION, "sound/ui/eat_potion.wav")
	item.SetUseSoundFileName(item.USESOUND_PORTAL, "sound/ui/potal_scroll.wav")

	item.SetDropSoundFileName(item.DROPSOUND_DEFAULT, "sound/ui/drop.wav")
	item.SetDropSoundFileName(item.DROPSOUND_ACCESSORY, "sound/ui/equip_ring_amulet.wav")
	item.SetDropSoundFileName(item.DROPSOUND_ARMOR, "sound/ui/equip_metal_armor.wav")
	item.SetDropSoundFileName(item.DROPSOUND_BOW, "sound/ui/equip_bow.wav")
	item.SetDropSoundFileName(item.DROPSOUND_WEAPON, "sound/ui/equip_metal_weapon.wav")

def __LoadGameEffect():
	chrmgr.RegisterEffect(chrmgr.EFFECT_SPAWN_APPEAR, "Bip01", "d:/ymir work/effect/etc/appear_die/monster_appear.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_SPAWN_DISAPPEAR, "Bip01", "d:/ymir work/effect/etc/appear_die/monster_die.mse")		
	chrmgr.RegisterEffect(chrmgr.EFFECT_FLAME_ATTACK, "equip_right_hand", "d:/ymir work/effect/hit/blow_flame/flame_3_weapon.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_FLAME_HIT, "", "d:/ymir work/effect/hit/blow_flame/flame_3_blow.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_FLAME_ATTACH, "", "d:/ymir work/effect/hit/blow_flame/flame_3_body.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_ELECTRIC_ATTACK, "equip_right", "d:/ymir work/effect/hit/blow_electric/light_1_weapon.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_ELECTRIC_HIT, "", "d:/ymir work/effect/hit/blow_electric/light_1_blow.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_ELECTRIC_ATTACH, "", "d:/ymir work/effect/hit/blow_electric/light_1_body.mse")
	
	chrmgr.RegisterEffect(chrmgr.EFFECT_LEVELUP, "", "d:/ymir work/effect/etc/levelup_1/level_up.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_SKILLUP, "", "d:/ymir work/effect/etc/skillup/skillup_1.mse")

	if localeInfo.IsNEWCIBN():
		chrmgr.RegisterEffect(chrmgr.EFFECT_EMPIRE+1, "Bip01", "locale/newcibn/effect/empire/empire_A.mse")
		chrmgr.RegisterEffect(chrmgr.EFFECT_EMPIRE+2, "Bip01", "locale/newcibn/effect/empire/empire_B.mse")
		chrmgr.RegisterEffect(chrmgr.EFFECT_EMPIRE+3, "Bip01", "locale/newcibn/effect/empire/empire_C.mse")
	else :
		chrmgr.RegisterEffect(chrmgr.EFFECT_EMPIRE+1, "Bip01", "d:/ymir work/effect/etc/empire/empire_A.mse")
		chrmgr.RegisterEffect(chrmgr.EFFECT_EMPIRE+2, "Bip01", "d:/ymir work/effect/etc/empire/empire_B.mse")
		chrmgr.RegisterEffect(chrmgr.EFFECT_EMPIRE+3, "Bip01", "d:/ymir work/effect/etc/empire/empire_C.mse")
 
	chrmgr.RegisterEffect(chrmgr.EFFECT_WEAPON+1, "equip_right_hand", "d:/ymir work/pc/warrior/effect/geom_sword_loop.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_WEAPON+2, "equip_right_hand", "d:/ymir work/pc/warrior/effect/geom_spear_loop.mse")

	# LOCALE
	chrmgr.RegisterEffect(chrmgr.EFFECT_AFFECT+0, "Bip01", localeInfo.FN_GM_MARK)
	chrmgr.RegisterEffect(chrmgr.EFEKT_BOSSA, "", "locale/es/effect/boss.mse")
	if app.ENABLE_AGGREGATE_MONSTER_EFFECT:
		chrmgr.RegisterCacheEffect(chrmgr.EFFECT_AGGREGATE_MONSTER, "", "d:/ymir work/effect/aggregate/aggregate_monster.mse")
	# END_OF_LOCALE
	
	chrmgr.RegisterEffect(chrmgr.EFFECT_AFFECT+3, "Bip01", "d:/ymir work/effect/hit/blow_poison/poison_loop.mse") ## ߵ
	chrmgr.RegisterEffect(chrmgr.EFFECT_AFFECT+4, "", "d:/ymir work/effect/affect/slow.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_AFFECT+5, "Bip01 Head", "d:/ymir work/effect/etc/stun/stun_loop.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_AFFECT+6, "", "d:/ymir work/effect/etc/ready/ready.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_AFFECT+16, "", "d:/ymir work/pc/warrior/effect/gyeokgongjang_loop.mse") ## õ (ؿ ֵ-_-)
	chrmgr.RegisterEffect(chrmgr.EFFECT_AFFECT+17, "", "d:/ymir work/pc/assassin/effect/gyeonggong_loop.mse") ## ڰ - 
	chrmgr.RegisterEffect(chrmgr.EFFECT_AFFECT+19, "Bip01 R Finger2", "d:/ymir work/pc/sura/effect/gwigeom_loop.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_AFFECT+20, "", "d:/ymir work/pc/sura/effect/fear_loop.mse") ##  - 
	chrmgr.RegisterEffect(chrmgr.EFFECT_AFFECT+21, "", "d:/ymir work/pc/sura/effect/jumagap_loop.mse") ##  - ָ
	chrmgr.RegisterEffect(chrmgr.EFFECT_AFFECT+22, "", "d:/ymir work/pc/shaman/effect/3hosin_loop.mse") ##  - ȣ
	chrmgr.RegisterEffect(chrmgr.EFFECT_AFFECT+23, "", "d:/ymir work/pc/shaman/effect/boho_loop.mse") ##  - ȣ
	chrmgr.RegisterEffect(chrmgr.EFFECT_AFFECT+24, "", "d:/ymir work/pc/shaman/effect/10kwaesok_loop.mse") ##  - 
	chrmgr.RegisterEffect(chrmgr.EFFECT_AFFECT+25, "", "d:/ymir work/pc/sura/effect/heuksin_loop.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_AFFECT+26, "", "d:/ymir work/pc/sura/effect/muyeong_loop.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_AFFECT+28, "Bip01", "d:/ymir work/effect/hit/blow_flame/flame_loop.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_AFFECT+29, "Bip01 R Hand", "d:/ymir work/pc/shaman/effect/6gicheon_hand.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_AFFECT+30, "Bip01 L Hand", "d:/ymir work/pc/shaman/effect/jeungryeok_hand.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_AFFECT+32, "Bip01 Head", "d:/ymir work/pc/sura/effect/pabeop_loop.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_AFFECT+33, "", "d:/ymir work/pc/warrior/effect/gyeokgongjang_loop.mse") ## õ (Fallen)
	## 34 Polymoph
	chrmgr.RegisterEffect(chrmgr.EFFECT_AFFECT+35, "", "d:/ymir work/effect/etc/guild_war_flag/flag_red.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_AFFECT+36, "", "d:/ymir work/effect/etc/guild_war_flag/flag_blue.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_AFFECT+37, "", "d:/ymir work/effect/etc/guild_war_flag/flag_yellow.mse")

	chrmgr.RegisterEffect(chrmgr.EFFECT_AFFECT+42, "Bip01", "d:/ymir work/effect/hit/blow_poison/bleeding_loop.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_AFFECT+43, "Bip01", "d:/ymir work/effect/hit/blow_flame/flame_loop_w.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_AFFECT+44, "", "d:/ymir work/pc3/common/effect/gyeokgongjang_loop_w.mse")
		
	if app.ENABLE_MELEY_LAIR_DUNGEON:
		chrmgr.RegisterEffect(chrmgr.EFFECT_AFFECT + 45, "", "d:/ymir work/effect/monster2/redd_moojuk.mse")
		chrmgr.RegisterEffect(chrmgr.EFFECT_AFFECT + 46, "", "d:/ymir work/effect/monster2/redd_moojuk.mse")
		chrmgr.RegisterEffect(chrmgr.EFFECT_AFFECT + 47, "", "d:/ymir work/effect/monster2/redd_moojuk_blue.mse")
		chrmgr.RegisterEffect(chrmgr.EFFECT_AFFECT + 48, "", "d:/ymir work/effect/monster2/redd_moojuk_green.mse")
	
	if app.DRAGON_SOUL_ACTIVE_EFFECT:
		chrmgr.RegisterEffect(chrmgr.EFFECT_AFFECT + 49, "", "d:/ymir work/pc/assassin/effect/kwaegeom_loop.mse")
	
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+1, "PART_WEAPON", "D:/ymir work/pc/common/effect/sword/sword_7.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+2, "PART_WEAPON", "D:/ymir work/pc/common/effect/sword/sword_8.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+3, "PART_WEAPON", "D:/ymir work/pc/common/effect/sword/sword_9.mse")

	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+4, "PART_WEAPON_LEFT", "D:/ymir work/pc/common/effect/sword/sword_7_b.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+5, "PART_WEAPON_LEFT", "D:/ymir work/pc/common/effect/sword/sword_8_b.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+6, "PART_WEAPON_LEFT", "D:/ymir work/pc/common/effect/sword/sword_9_b.mse")

	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+7, "PART_WEAPON", "D:/ymir work/pc/common/effect/sword/sword_7_f.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+8, "PART_WEAPON", "D:/ymir work/pc/common/effect/sword/sword_8_f.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+9, "PART_WEAPON", "D:/ymir work/pc/common/effect/sword/sword_9_f.mse")

	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+10, "PART_WEAPON", "D:/ymir work/pc/common/effect/sword/sword_7_s.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+11, "PART_WEAPON", "D:/ymir work/pc/common/effect/sword/sword_8_s.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+12, "PART_WEAPON", "D:/ymir work/pc/common/effect/sword/sword_9_s.mse")

	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+13, "PART_WEAPON_LEFT", "D:/ymir work/pc/common/effect/sword/sword_7_s.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+14, "PART_WEAPON_LEFT", "D:/ymir work/pc/common/effect/sword/sword_8_s.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+15, "PART_WEAPON_LEFT", "D:/ymir work/pc/common/effect/sword/sword_9_s.mse")

	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+16, "Bip01", "D:/ymir work/pc/common/effect/armor/armor_7.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+17, "Bip01", "D:/ymir work/pc/common/effect/armor/armor_8.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+18, "Bip01", "D:/ymir work/pc/common/effect/armor/armor_9.mse")

	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+19, "Bip01", "D:/ymir work/pc/common/effect/armor/armor-4-2-1.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+20, "Bip01", "D:/ymir work/pc/common/effect/armor/armor-4-2-2.mse")
	if app.VERSION_162_ENABLED:
		chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+21, "Bip01", "d:/ymir work/pc/common/effect/armor/armor-5-1.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+22, "Bip01", "d:/ymir work/pc/common/effect/armor/acc_01.mse")
	if app.ENABLE_SASH_SYSTEM:
		chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED + 23, "Bip01", "d:/ymir work/pc/common/effect/armor/acc_01.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+24, "Bip01", "d:/ymir work/effect/Jin_Han/work/demonica.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+25, "Bip01", "D:/ymir work/pc/common/effect/armor/armor_assassin4.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+26, "Bip01", "D:/ymir work/pc/common/effect/armor/armor_assassin5.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+27, "Bip01", "D:/ymir work/pc/common/effect/armor/armor_assassin6.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+28, "Bip01", "D:/ymir work/pc/common/effect/armor/armor_assassin7.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+29, "Bip01", "D:/ymir work/pc/common/effect/armor/armor_assassin8.mse")

	#chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+30, "Bip01", "D:/ymir work/pc/common/effect/armor/armor-5-1.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+30, "PART_WEAPON", "D:/ymir work/pc/common/effect/sword/sword_9sari.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+31, "PART_WEAPON", "D:/ymir work/pc/common/effect/sword/sword_9turuncu.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+32, "PART_WEAPON", "D:/ymir work/pc/common/effect/sword/sword_9mavi.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+33, "PART_WEAPON", "D:/ymir work/pc/common/effect/sword/sword_9mor.mse")
	
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+34, "PART_WEAPON_LEFT", "D:/ymir work/pc/common/effect/sword/sword_9_bsari.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+35, "PART_WEAPON_LEFT", "D:/ymir work/pc/common/effect/sword/sword_9_bturuncu.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+36, "PART_WEAPON_LEFT", "D:/ymir work/pc/common/effect/sword/sword_9_bmavi.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+37, "PART_WEAPON_LEFT", "D:/ymir work/pc/common/effect/sword/sword_9_bmor.mse")	
	
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+38, "PART_WEAPON", "D:/ymir work/pc/common/effect/sword/sword_9_fsari.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+39, "PART_WEAPON", "D:/ymir work/pc/common/effect/sword/sword_9_fturuncu.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+40, "PART_WEAPON", "D:/ymir work/pc/common/effect/sword/sword_9_fmavi.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+41, "PART_WEAPON", "D:/ymir work/pc/common/effect/sword/sword_9_fmor.mse")	
	
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+42, "PART_WEAPON", "D:/ymir work/pc/common/effect/sword/sword_9_ssari.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+43, "PART_WEAPON", "D:/ymir work/pc/common/effect/sword/sword_9_sturuncu.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+44, "PART_WEAPON", "D:/ymir work/pc/common/effect/sword/sword_9_smavi.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+45, "PART_WEAPON", "D:/ymir work/pc/common/effect/sword/sword_9_smor.mse")	
	
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+46, "PART_WEAPON_LEFT", "D:/ymir work/pc/common/effect/sword/sword_9_ssari.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+47, "PART_WEAPON_LEFT", "D:/ymir work/pc/common/effect/sword/sword_9_sturuncu.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+48, "PART_WEAPON_LEFT", "D:/ymir work/pc/common/effect/sword/sword_9_smavi.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+49, "PART_WEAPON_LEFT", "D:/ymir work/pc/common/effect/sword/sword_9_smor.mse")	
	
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+50, "PART_WEAPON", "D:/ymir work/pc/common/effect/sword/sword_9_wsari.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+51, "PART_WEAPON", "D:/ymir work/pc/common/effect/sword/sword_9_wturuncu.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+52, "PART_WEAPON", "D:/ymir work/pc/common/effect/sword/sword_9_wmavi.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+53, "PART_WEAPON", "D:/ymir work/pc/common/effect/sword/sword_9_wmor.mse")	
	
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+54, "PART_WEAPON_LEFT", "D:/ymir work/pc/common/effect/sword/sword_9_wsari.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+55, "PART_WEAPON_LEFT", "D:/ymir work/pc/common/effect/sword/sword_9_wturuncu.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+56, "PART_WEAPON_LEFT", "D:/ymir work/pc/common/effect/sword/sword_9_wmavi.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+57, "PART_WEAPON_LEFT", "D:/ymir work/pc/common/effect/sword/sword_9_wmor.mse")	

	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+58, "PART_WEAPON", "D:/ymir work/pc/common/effect/sword/sword_7_w.mse") ##saglam efektler###
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+59, "PART_WEAPON", "D:/ymir work/pc/common/effect/sword/sword_8_w.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+60, "PART_WEAPON", "D:/ymir work/pc/common/effect/sword/sword_9_w.mse")

	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+61, "PART_WEAPON_LEFT", "D:/ymir work/pc/common/effect/sword/sword_7_w.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+62, "PART_WEAPON_LEFT", "D:/ymir work/pc/common/effect/sword/sword_8_w.mse")
	chrmgr.RegisterEffect(chrmgr.EFFECT_REFINED+63, "PART_WEAPON_LEFT", "D:/ymir work/pc/common/effect/sword/sword_9_w.mse")

	## FlyData
	effect.RegisterIndexedFlyData(effect.FLY_EXP, effect.INDEX_FLY_TYPE_NORMAL, "d:/ymir work/effect/etc/gathering/ga_piece_yellow_small2.msf")				##  (EXP)
	effect.RegisterIndexedFlyData(effect.FLY_HP_MEDIUM, effect.INDEX_FLY_TYPE_NORMAL, "d:/ymir work/effect/etc/gathering/ga_piece_red_small.msf")			##  (HP) 
	effect.RegisterIndexedFlyData(effect.FLY_HP_BIG, effect.INDEX_FLY_TYPE_NORMAL, "d:/ymir work/effect/etc/gathering/ga_piece_red_big.msf")				##  (HP) ū
	effect.RegisterIndexedFlyData(effect.FLY_SP_SMALL, effect.INDEX_FLY_TYPE_NORMAL, "d:/ymir work/effect/etc/gathering/ga_piece_blue_warrior_small.msf")	## Ķ  ִ°
	effect.RegisterIndexedFlyData(effect.FLY_SP_MEDIUM, effect.INDEX_FLY_TYPE_NORMAL, "d:/ymir work/effect/etc/gathering/ga_piece_blue_small.msf")			## Ķ 
	effect.RegisterIndexedFlyData(effect.FLY_SP_BIG, effect.INDEX_FLY_TYPE_NORMAL, "d:/ymir work/effect/etc/gathering/ga_piece_blue_big.msf")				## Ķ ū
	effect.RegisterIndexedFlyData(effect.FLY_FIREWORK1, effect.INDEX_FLY_TYPE_FIRE_CRACKER, "d:/ymir work/effect/etc/firecracker/firecracker_1.msf")		##  1
	effect.RegisterIndexedFlyData(effect.FLY_FIREWORK2, effect.INDEX_FLY_TYPE_FIRE_CRACKER, "d:/ymir work/effect/etc/firecracker/firecracker_2.msf")		##  2
	effect.RegisterIndexedFlyData(effect.FLY_FIREWORK3, effect.INDEX_FLY_TYPE_FIRE_CRACKER, "d:/ymir work/effect/etc/firecracker/firecracker_3.msf")		##  3
	effect.RegisterIndexedFlyData(effect.FLY_FIREWORK4, effect.INDEX_FLY_TYPE_FIRE_CRACKER, "d:/ymir work/effect/etc/firecracker/firecracker_4.msf")		##  4
	effect.RegisterIndexedFlyData(effect.FLY_FIREWORK5, effect.INDEX_FLY_TYPE_FIRE_CRACKER, "d:/ymir work/effect/etc/firecracker/firecracker_5.msf")		##  5
	effect.RegisterIndexedFlyData(effect.FLY_FIREWORK6, effect.INDEX_FLY_TYPE_FIRE_CRACKER, "d:/ymir work/effect/etc/firecracker/firecracker_6.msf")		##  6
	effect.RegisterIndexedFlyData(effect.FLY_FIREWORK_XMAS, effect.INDEX_FLY_TYPE_FIRE_CRACKER, "d:/ymir work/effect/etc/firecracker/firecracker_xmas.msf")	##  X-Mas
	effect.RegisterIndexedFlyData(effect.FLY_CHAIN_LIGHTNING, effect.INDEX_FLY_TYPE_NORMAL, "d:/ymir work/pc/shaman/effect/pokroe.msf")						## ڰ
	effect.RegisterIndexedFlyData(effect.FLY_HP_SMALL, effect.INDEX_FLY_TYPE_NORMAL, "d:/ymir work/effect/etc/gathering/ga_piece_red_smallest.msf")			##  ſ 
	effect.RegisterIndexedFlyData(effect.FLY_SKILL_MUYEONG, effect.INDEX_FLY_TYPE_AUTO_FIRE, "d:/ymir work/pc/sura/effect/muyeong_fly.msf")					## 

	#########################################################################################
	## Emoticon
	EmoticonStr = "d:/ymir work/effect/etc/emoticon/"
	BuffStr2 = "d:/ymir work/effect/etc/"
	BuffStr3 = "d:/ymir work/effect/etc/buff/"
	BuffStr4 = "locale/es/effect/"
	BuffStr5 = "d:/ymir work/gmtag/"

	chrmgr.RegisterEffect(chrmgr.EFFECT_EMOTICON+0, "", EmoticonStr+"sweat.mse")
	net.RegisterEmoticonString("(Ȳ)")

	chrmgr.RegisterEffect(chrmgr.EFFECT_EMOTICON+1, "", EmoticonStr+"money.mse")
	net.RegisterEmoticonString("()")

	chrmgr.RegisterEffect(chrmgr.EFFECT_EMOTICON+2, "", EmoticonStr+"happy.mse")
	net.RegisterEmoticonString("()")

	chrmgr.RegisterEffect(chrmgr.EFFECT_EMOTICON+3, "", EmoticonStr+"love_s.mse")
	net.RegisterEmoticonString("()")

	chrmgr.RegisterEffect(chrmgr.EFFECT_EMOTICON+4, "", EmoticonStr+"love_l.mse")
	net.RegisterEmoticonString("()")

	chrmgr.RegisterEffect(chrmgr.EFFECT_EMOTICON+5, "", EmoticonStr+"angry.mse")
	net.RegisterEmoticonString("(г)")

	chrmgr.RegisterEffect(chrmgr.EFFECT_EMOTICON+6, "", EmoticonStr+"aha.mse")
	net.RegisterEmoticonString("()")

	chrmgr.RegisterEffect(chrmgr.EFFECT_EMOTICON+7, "", EmoticonStr+"gloom.mse")
	net.RegisterEmoticonString("()")

	chrmgr.RegisterEffect(chrmgr.EFFECT_EMOTICON+8, "", EmoticonStr+"sorry.mse")
	net.RegisterEmoticonString("(˼)")

	chrmgr.RegisterEffect(chrmgr.EFFECT_EMOTICON+9, "", EmoticonStr+"!_mix_back.mse")
	net.RegisterEmoticonString("(!)")

	chrmgr.RegisterEffect(chrmgr.EFFECT_EMOTICON+10, "", EmoticonStr+"question.mse")
	net.RegisterEmoticonString("(?)")

	chrmgr.RegisterEffect(chrmgr.EFFECT_EMOTICON+11, "", EmoticonStr+"fish.mse")
	net.RegisterEmoticonString("(fish)")

	chrmgr.RegisterEffect(chrmgr.EFFECT_EMOTICON+12, "", BuffStr2+"ox/success.mse")
	net.RegisterEmoticonString("(spirit2)")

	"""chrmgr.RegisterEffect(chrmgr.EFFECT_EMOTICON+13, "", BuffStr5+"youtuber.mse")
	net.RegisterEmoticonString("(youtuber)")"""
	
	chrmgr.RegisterEffect(chrmgr.EFFECT_EMOTICON+13, "", BuffStr5+"klicon.mse")
	net.RegisterEmoticonString("(klicon)")

	chrmgr.RegisterEffect(chrmgr.EFFECT_EMOTICON+14, "", BuffStr5+"kralicon.mse")
	net.RegisterEmoticonString("(kralicon)")


	## Emoticon
	#########################################################################################


def __LoadGameWarrior():
	__LoadGameWarriorEx(RACE_WARRIOR_M, "d:/ymir work/pc/warrior/")
	__LoadGameWarriorEx(RACE_WARRIOR_W, "d:/ymir work/pc2/warrior/")

def __LoadGameAssassin():
	__LoadGameAssassinEx(RACE_ASSASSIN_W, "d:/ymir work/pc/assassin/")
	__LoadGameAssassinEx(RACE_ASSASSIN_M, "d:/ymir work/pc2/assassin/")

def __LoadGameSura():
	__LoadGameSuraEx(RACE_SURA_M, "d:/ymir work/pc/sura/")
	__LoadGameSuraEx(RACE_SURA_W, "d:/ymir work/pc2/sura/")

def __LoadGameShaman():
	__LoadGameShamanEx(RACE_SHAMAN_W, "d:/ymir work/pc/shaman/")
	__LoadGameShamanEx(RACE_SHAMAN_M, "d:/ymir work/pc2/shaman/")
	
def __LoadGameWolfman():
	__LoadGameWolfmanEx(RACE_WOLFMAN_M, "d:/ymir work/pc3/wolfman/")

def __LoadGameWarriorEx(race, path):

	## Warrior
	#########################################################################################
	chrmgr.SelectRace(race)

	## GENERAL MODE
	SetGeneralMotions(chr.MOTION_MODE_GENERAL, path + "general/")
	chrmgr.SetMotionRandomWeight(chr.MOTION_MODE_GENERAL, chr.MOTION_WAIT, 0, 70)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_WAIT, "wait_1.msa", 30)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_COMBO_ATTACK_1, "attack.msa", 50)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_COMBO_ATTACK_1, "attack_1.msa", 50)

	## SKILL
	chrmgr.SetPathName(path + "skill/")
	for i in xrange(skill.SKILL_EFFECT_COUNT):
		END_STRING = ""
		if i != 0: END_STRING = "_%d" % (i+1)
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+1, "samyeon" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+2, "palbang" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+3, "jeongwi" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+4, "geomgyeong" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+5, "tanhwan" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+6, "gihyeol" + END_STRING + ".msa")
		if NEW_678TH_SKILL_ENABLE:
			chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+6, "gihyeol" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+16, "gigongcham" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+17, "gyeoksan" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+18, "daejin" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+19, "cheongeun" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+20, "geompung" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+21, "noegeom" + END_STRING + ".msa")
		if NEW_678TH_SKILL_ENABLE:
			chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+21, "noegeom" + END_STRING + ".msa")

	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, GUILD_SKILL_DRAGONBLOOD, "guild_yongsinuipi.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, GUILD_SKILL_DRAGONBLESS, "guild_yongsinuichukbok.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, GUILD_SKILL_BLESSARMOR, "guild_seonghwigap.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, GUILD_SKILL_SPPEDUP, "guild_gasokhwa.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, GUILD_SKILL_DRAGONWRATH, "guild_yongsinuibunno.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, GUILD_SKILL_MAGICUP, "guild_jumunsul.msa")

	chrmgr.ReserveComboAttackNew(chr.MOTION_MODE_GENERAL, COMBO_TYPE_1, 1)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_GENERAL, COMBO_TYPE_1, COMBO_INDEX_1, chr.MOTION_COMBO_ATTACK_1)

	## EMOTION
	emotion.RegisterEmotionAnis(path)

	## ONEHAND_SWORD BATTLE
	chrmgr.SetPathName(path + "onehand_sword/")
	chrmgr.RegisterMotionMode(chr.MOTION_MODE_ONEHAND_SWORD)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_ONEHAND_SWORD, chr.MOTION_WAIT,				"wait.msa", 50)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_ONEHAND_SWORD, chr.MOTION_WAIT,				"wait_1.msa", 50)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_ONEHAND_SWORD, chr.MOTION_WALK,				"walk.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_ONEHAND_SWORD, chr.MOTION_RUN,				"run.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_ONEHAND_SWORD, chr.MOTION_DAMAGE,			"damage.msa", 50)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_ONEHAND_SWORD, chr.MOTION_DAMAGE,			"damage_1.msa", 50)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_ONEHAND_SWORD, chr.MOTION_DAMAGE_BACK,		"damage_2.msa", 50)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_ONEHAND_SWORD, chr.MOTION_DAMAGE_BACK,		"damage_3.msa", 50)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_ONEHAND_SWORD, chr.MOTION_COMBO_ATTACK_1,	"combo_01.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_ONEHAND_SWORD, chr.MOTION_COMBO_ATTACK_2,	"combo_02.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_ONEHAND_SWORD, chr.MOTION_COMBO_ATTACK_3,	"combo_03.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_ONEHAND_SWORD, chr.MOTION_COMBO_ATTACK_4,	"combo_04.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_ONEHAND_SWORD, chr.MOTION_COMBO_ATTACK_5,	"combo_05.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_ONEHAND_SWORD, chr.MOTION_COMBO_ATTACK_6,	"combo_06.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_ONEHAND_SWORD, chr.MOTION_COMBO_ATTACK_7,	"combo_07.msa")

	## Combo Type 1
	chrmgr.ReserveComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_1, 4)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_1, COMBO_INDEX_1, chr.MOTION_COMBO_ATTACK_1)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_1, COMBO_INDEX_2, chr.MOTION_COMBO_ATTACK_2)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_1, COMBO_INDEX_3, chr.MOTION_COMBO_ATTACK_3)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_1, COMBO_INDEX_4, chr.MOTION_COMBO_ATTACK_4)
	## Combo Type 2
	chrmgr.ReserveComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_2, 5)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_2, COMBO_INDEX_1, chr.MOTION_COMBO_ATTACK_1)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_2, COMBO_INDEX_2, chr.MOTION_COMBO_ATTACK_2)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_2, COMBO_INDEX_3, chr.MOTION_COMBO_ATTACK_3)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_2, COMBO_INDEX_4, chr.MOTION_COMBO_ATTACK_5)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_2, COMBO_INDEX_5, chr.MOTION_COMBO_ATTACK_7)
	## Combo Type 3
	chrmgr.ReserveComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_3, 6)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_3, COMBO_INDEX_1, chr.MOTION_COMBO_ATTACK_1)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_3, COMBO_INDEX_2, chr.MOTION_COMBO_ATTACK_2)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_3, COMBO_INDEX_3, chr.MOTION_COMBO_ATTACK_3)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_3, COMBO_INDEX_4, chr.MOTION_COMBO_ATTACK_5)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_3, COMBO_INDEX_5, chr.MOTION_COMBO_ATTACK_6)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_3, COMBO_INDEX_6, chr.MOTION_COMBO_ATTACK_4)

	## TWOHAND_SWORD BATTLE
	chrmgr.SetPathName(path + "twohand_sword/")
	chrmgr.RegisterMotionMode(chr.MOTION_MODE_TWOHAND_SWORD)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_TWOHAND_SWORD, chr.MOTION_WAIT,				"wait.msa", 70)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_TWOHAND_SWORD, chr.MOTION_WAIT,				"wait_1.msa", 30)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_TWOHAND_SWORD, chr.MOTION_WALK,				"walk.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_TWOHAND_SWORD, chr.MOTION_RUN,				"run.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_TWOHAND_SWORD, chr.MOTION_DAMAGE,			"damage.msa", 50)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_TWOHAND_SWORD, chr.MOTION_DAMAGE,			"damage_1.msa", 50)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_TWOHAND_SWORD, chr.MOTION_DAMAGE_BACK,		"damage_2.msa", 50)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_TWOHAND_SWORD, chr.MOTION_DAMAGE_BACK,		"damage_3.msa", 50)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_TWOHAND_SWORD, chr.MOTION_COMBO_ATTACK_1,	"combo_01.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_TWOHAND_SWORD, chr.MOTION_COMBO_ATTACK_2,	"combo_02.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_TWOHAND_SWORD, chr.MOTION_COMBO_ATTACK_3,	"combo_03.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_TWOHAND_SWORD, chr.MOTION_COMBO_ATTACK_4,	"combo_04.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_TWOHAND_SWORD, chr.MOTION_COMBO_ATTACK_5,	"combo_05.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_TWOHAND_SWORD, chr.MOTION_COMBO_ATTACK_6,	"combo_06.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_TWOHAND_SWORD, chr.MOTION_COMBO_ATTACK_7,	"combo_07.msa")

	## Combo Type 1
	chrmgr.ReserveComboAttackNew(chr.MOTION_MODE_TWOHAND_SWORD, COMBO_TYPE_1, 4)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_TWOHAND_SWORD, COMBO_TYPE_1, COMBO_INDEX_1, chr.MOTION_COMBO_ATTACK_1)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_TWOHAND_SWORD, COMBO_TYPE_1, COMBO_INDEX_2, chr.MOTION_COMBO_ATTACK_2)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_TWOHAND_SWORD, COMBO_TYPE_1, COMBO_INDEX_3, chr.MOTION_COMBO_ATTACK_3)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_TWOHAND_SWORD, COMBO_TYPE_1, COMBO_INDEX_4, chr.MOTION_COMBO_ATTACK_4)
	## Combo Type 2
	chrmgr.ReserveComboAttackNew(chr.MOTION_MODE_TWOHAND_SWORD, COMBO_TYPE_2, 5)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_TWOHAND_SWORD, COMBO_TYPE_2, COMBO_INDEX_1, chr.MOTION_COMBO_ATTACK_1)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_TWOHAND_SWORD, COMBO_TYPE_2, COMBO_INDEX_2, chr.MOTION_COMBO_ATTACK_2)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_TWOHAND_SWORD, COMBO_TYPE_2, COMBO_INDEX_3, chr.MOTION_COMBO_ATTACK_3)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_TWOHAND_SWORD, COMBO_TYPE_2, COMBO_INDEX_4, chr.MOTION_COMBO_ATTACK_5)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_TWOHAND_SWORD, COMBO_TYPE_2, COMBO_INDEX_5, chr.MOTION_COMBO_ATTACK_7)
	## Combo Type 3
	chrmgr.ReserveComboAttackNew(chr.MOTION_MODE_TWOHAND_SWORD, COMBO_TYPE_3, 6)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_TWOHAND_SWORD, COMBO_TYPE_3, COMBO_INDEX_1, chr.MOTION_COMBO_ATTACK_1)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_TWOHAND_SWORD, COMBO_TYPE_3, COMBO_INDEX_2, chr.MOTION_COMBO_ATTACK_2)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_TWOHAND_SWORD, COMBO_TYPE_3, COMBO_INDEX_3, chr.MOTION_COMBO_ATTACK_3)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_TWOHAND_SWORD, COMBO_TYPE_3, COMBO_INDEX_4, chr.MOTION_COMBO_ATTACK_5)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_TWOHAND_SWORD, COMBO_TYPE_3, COMBO_INDEX_5, chr.MOTION_COMBO_ATTACK_6)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_TWOHAND_SWORD, COMBO_TYPE_3, COMBO_INDEX_6, chr.MOTION_COMBO_ATTACK_4)

	## FISHING
	chrmgr.SetPathName(path + "fishing/")
	chrmgr.RegisterMotionMode(chr.MOTION_MODE_FISHING)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FISHING, chr.MOTION_WAIT,			"wait.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FISHING, chr.MOTION_WALK,			"walk.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FISHING, chr.MOTION_RUN,				"run.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FISHING, chr.MOTION_FISHING_THROW,	"throw.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FISHING, chr.MOTION_FISHING_WAIT,	"fishing_wait.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FISHING, chr.MOTION_FISHING_STOP,	"fishing_cancel.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FISHING, chr.MOTION_FISHING_REACT,	"fishing_react.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FISHING, chr.MOTION_FISHING_CATCH,	"fishing_catch.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FISHING, chr.MOTION_FISHING_FAIL,	"fishing_fail.msa")

	## HORSE
	chrmgr.SetPathName(path + "horse/")
	chrmgr.RegisterMotionMode(chr.MOTION_MODE_HORSE)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE, chr.MOTION_WAIT,				"wait.msa", 90)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE, chr.MOTION_WAIT,				"wait_1.msa", 9)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE, chr.MOTION_WAIT,				"wait_2.msa", 1)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE, chr.MOTION_WALK,				"walk.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE, chr.MOTION_RUN,				"run.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE, chr.MOTION_DAMAGE,			"damage.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE, chr.MOTION_DAMAGE_BACK,		"damage.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE, chr.MOTION_DEAD,				"dead.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE, HORSE_SKILL_CHARGE,			"skill_charge.msa")

	## HORSE_ONEHAND_SWORD
	chrmgr.SetPathName(path + "horse_onehand_sword/")
	chrmgr.RegisterMotionMode(chr.MOTION_MODE_HORSE_ONEHAND_SWORD)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_ONEHAND_SWORD, chr.MOTION_COMBO_ATTACK_1, "combo_01.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_ONEHAND_SWORD, chr.MOTION_COMBO_ATTACK_2, "combo_02.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_ONEHAND_SWORD, chr.MOTION_COMBO_ATTACK_3, "combo_03.msa")
	chrmgr.ReserveComboAttackNew(chr.MOTION_MODE_HORSE_ONEHAND_SWORD, COMBO_TYPE_1, 3)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_HORSE_ONEHAND_SWORD, COMBO_TYPE_1, COMBO_INDEX_1, chr.MOTION_COMBO_ATTACK_1)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_HORSE_ONEHAND_SWORD, COMBO_TYPE_1, COMBO_INDEX_2, chr.MOTION_COMBO_ATTACK_2)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_HORSE_ONEHAND_SWORD, COMBO_TYPE_1, COMBO_INDEX_3, chr.MOTION_COMBO_ATTACK_3)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_ONEHAND_SWORD, HORSE_SKILL_WILDATTACK, "skill_wildattack.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_ONEHAND_SWORD, HORSE_SKILL_SPLASH, "skill_splash.msa")

	## HORSE_TWOHAND_SWORD
	chrmgr.SetPathName(path + "horse_twohand_sword/")
	chrmgr.RegisterMotionMode(chr.MOTION_MODE_HORSE_TWOHAND_SWORD)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_TWOHAND_SWORD, chr.MOTION_COMBO_ATTACK_1, "combo_01.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_TWOHAND_SWORD, chr.MOTION_COMBO_ATTACK_2, "combo_02.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_TWOHAND_SWORD, chr.MOTION_COMBO_ATTACK_3, "combo_03.msa")
	chrmgr.ReserveComboAttackNew(chr.MOTION_MODE_HORSE_TWOHAND_SWORD, COMBO_TYPE_1, 3)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_HORSE_TWOHAND_SWORD, COMBO_TYPE_1, COMBO_INDEX_1, chr.MOTION_COMBO_ATTACK_1)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_HORSE_TWOHAND_SWORD, COMBO_TYPE_1, COMBO_INDEX_2, chr.MOTION_COMBO_ATTACK_2)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_HORSE_TWOHAND_SWORD, COMBO_TYPE_1, COMBO_INDEX_3, chr.MOTION_COMBO_ATTACK_3)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_TWOHAND_SWORD, HORSE_SKILL_WILDATTACK, "skill_wildattack.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_TWOHAND_SWORD, HORSE_SKILL_SPLASH, "skill_splash.msa")

	## Bone
	if app.ENABLE_SASH_SYSTEM:
		chrmgr.RegisterAttachingBoneName(chr.PART_SASH, "Bip01 Spine2")
	chrmgr.RegisterAttachingBoneName(chr.PART_WEAPON_RIGHT, "equip_right_hand")
	chrmgr.RegisterAttachingBoneName(chr.PART_WEAPON, "equip_right_hand")

def __LoadGameAssassinEx(race, path):
	## Assassin
	#########################################################################################
	chrmgr.SelectRace(race)

	## GENERAL MOTION MODE
	SetGeneralMotions(chr.MOTION_MODE_GENERAL, path + "general/")
	chrmgr.SetMotionRandomWeight(chr.MOTION_MODE_GENERAL, chr.MOTION_WAIT, 0, 70)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_WAIT, "wait_1.msa", 30)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_COMBO_ATTACK_1, "attack.msa", 50)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_COMBO_ATTACK_1, "attack_1.msa", 50)

	chrmgr.ReserveComboAttackNew(chr.MOTION_MODE_GENERAL, COMBO_TYPE_1, 1)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_GENERAL, COMBO_TYPE_1, COMBO_INDEX_1, chr.MOTION_COMBO_ATTACK_1)

	## SKILL
	chrmgr.SetPathName(path + "skill/")
	for i in xrange(skill.SKILL_EFFECT_COUNT):
		END_STRING = ""
		if i != 0: END_STRING = "_%d" % (i+1)
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+1, "amseup" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+2, "gungsin" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+3, "charyun" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+4, "eunhyeong" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+5, "sangong" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+6, "seomjeon" + END_STRING + ".msa")
		if NEW_678TH_SKILL_ENABLE:
			chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+6, "seomjeon" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+16, "yeonsa" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+17, "gwangyeok" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+18, "hwajo" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+19, "gyeonggong" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+20, "dokgigung" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+21, "seomgwang" + END_STRING + ".msa")
		if NEW_678TH_SKILL_ENABLE:
			chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+21, "seomgwang" + END_STRING + ".msa")

	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, GUILD_SKILL_DRAGONBLOOD, "guild_yongsinuipi.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, GUILD_SKILL_DRAGONBLESS, "guild_yongsinuichukbok.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, GUILD_SKILL_BLESSARMOR, "guild_seonghwigap.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, GUILD_SKILL_SPPEDUP, "guild_gasokhwa.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, GUILD_SKILL_DRAGONWRATH, "guild_yongsinuibunno.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, GUILD_SKILL_MAGICUP, "guild_jumunsul.msa")

	## EMOTION
	emotion.RegisterEmotionAnis(path)

	## ONEHAND_SWORD BATTLE
	chrmgr.SetPathName(path + "onehand_sword/")
	chrmgr.RegisterMotionMode(chr.MOTION_MODE_ONEHAND_SWORD)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_ONEHAND_SWORD, chr.MOTION_WAIT,		"wait.msa", 70)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_ONEHAND_SWORD, chr.MOTION_WAIT,		"wait_1.msa", 30)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_ONEHAND_SWORD, chr.MOTION_WALK,		"walk.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_ONEHAND_SWORD, chr.MOTION_RUN,		"run.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_ONEHAND_SWORD, chr.MOTION_DAMAGE,		"damage.msa", 50)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_ONEHAND_SWORD, chr.MOTION_DAMAGE,		"damage_1.msa", 50)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_ONEHAND_SWORD, chr.MOTION_DAMAGE_BACK,	"damage_2.msa", 50)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_ONEHAND_SWORD, chr.MOTION_DAMAGE_BACK,	"damage_3.msa", 50)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_ONEHAND_SWORD, chr.MOTION_COMBO_ATTACK_1, "combo_01.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_ONEHAND_SWORD, chr.MOTION_COMBO_ATTACK_2, "combo_02.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_ONEHAND_SWORD, chr.MOTION_COMBO_ATTACK_3, "combo_03.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_ONEHAND_SWORD, chr.MOTION_COMBO_ATTACK_4, "combo_04.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_ONEHAND_SWORD, chr.MOTION_COMBO_ATTACK_5, "combo_05.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_ONEHAND_SWORD, chr.MOTION_COMBO_ATTACK_6, "combo_06.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_ONEHAND_SWORD, chr.MOTION_COMBO_ATTACK_7, "combo_07.msa")

	## Combo Type 1
	chrmgr.ReserveComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_1, 4)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_1, COMBO_INDEX_1, chr.MOTION_COMBO_ATTACK_1)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_1, COMBO_INDEX_2, chr.MOTION_COMBO_ATTACK_2)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_1, COMBO_INDEX_3, chr.MOTION_COMBO_ATTACK_3)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_1, COMBO_INDEX_4, chr.MOTION_COMBO_ATTACK_4)
	## Combo Type 2
	chrmgr.ReserveComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_2, 5)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_2, COMBO_INDEX_1, chr.MOTION_COMBO_ATTACK_1)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_2, COMBO_INDEX_2, chr.MOTION_COMBO_ATTACK_2)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_2, COMBO_INDEX_3, chr.MOTION_COMBO_ATTACK_3)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_2, COMBO_INDEX_4, chr.MOTION_COMBO_ATTACK_5)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_2, COMBO_INDEX_5, chr.MOTION_COMBO_ATTACK_7)
	## Combo Type 3
	chrmgr.ReserveComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_3, 6)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_3, COMBO_INDEX_1, chr.MOTION_COMBO_ATTACK_1)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_3, COMBO_INDEX_2, chr.MOTION_COMBO_ATTACK_2)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_3, COMBO_INDEX_3, chr.MOTION_COMBO_ATTACK_3)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_3, COMBO_INDEX_4, chr.MOTION_COMBO_ATTACK_5)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_3, COMBO_INDEX_5, chr.MOTION_COMBO_ATTACK_6)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_3, COMBO_INDEX_6, chr.MOTION_COMBO_ATTACK_4)

	## DUALHAND_SWORD BATTLE
	chrmgr.SetPathName(path + "dualhand_sword/")
	chrmgr.RegisterMotionMode(chr.MOTION_MODE_DUALHAND_SWORD)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_DUALHAND_SWORD, chr.MOTION_WAIT,			"wait.msa", 70)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_DUALHAND_SWORD, chr.MOTION_WAIT,			"wait_1.msa", 30)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_DUALHAND_SWORD, chr.MOTION_WALK,			"walk.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_DUALHAND_SWORD, chr.MOTION_RUN,			"run.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_DUALHAND_SWORD, chr.MOTION_DAMAGE,		"damage.msa", 50)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_DUALHAND_SWORD, chr.MOTION_DAMAGE,		"damage_1.msa", 50)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_DUALHAND_SWORD, chr.MOTION_DAMAGE_BACK,	"damage_2.msa", 50)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_DUALHAND_SWORD, chr.MOTION_DAMAGE_BACK,	"damage_3.msa", 50)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_DUALHAND_SWORD, chr.MOTION_COMBO_ATTACK_1, "combo_01.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_DUALHAND_SWORD, chr.MOTION_COMBO_ATTACK_2, "combo_02.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_DUALHAND_SWORD, chr.MOTION_COMBO_ATTACK_3, "combo_03.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_DUALHAND_SWORD, chr.MOTION_COMBO_ATTACK_4, "combo_04.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_DUALHAND_SWORD, chr.MOTION_COMBO_ATTACK_5, "combo_05.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_DUALHAND_SWORD, chr.MOTION_COMBO_ATTACK_6, "combo_06.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_DUALHAND_SWORD, chr.MOTION_COMBO_ATTACK_7, "combo_07.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_DUALHAND_SWORD, chr.MOTION_COMBO_ATTACK_8, "combo_08.msa")

	## Combo Type 1
	chrmgr.ReserveComboAttackNew(chr.MOTION_MODE_DUALHAND_SWORD, COMBO_TYPE_1, 4)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_DUALHAND_SWORD, COMBO_TYPE_1, COMBO_INDEX_1, chr.MOTION_COMBO_ATTACK_1)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_DUALHAND_SWORD, COMBO_TYPE_1, COMBO_INDEX_2, chr.MOTION_COMBO_ATTACK_2)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_DUALHAND_SWORD, COMBO_TYPE_1, COMBO_INDEX_3, chr.MOTION_COMBO_ATTACK_3)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_DUALHAND_SWORD, COMBO_TYPE_1, COMBO_INDEX_4, chr.MOTION_COMBO_ATTACK_4)
	## Combo Type 2
	chrmgr.ReserveComboAttackNew(chr.MOTION_MODE_DUALHAND_SWORD, COMBO_TYPE_2, 5)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_DUALHAND_SWORD, COMBO_TYPE_2, COMBO_INDEX_1, chr.MOTION_COMBO_ATTACK_1)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_DUALHAND_SWORD, COMBO_TYPE_2, COMBO_INDEX_2, chr.MOTION_COMBO_ATTACK_2)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_DUALHAND_SWORD, COMBO_TYPE_2, COMBO_INDEX_3, chr.MOTION_COMBO_ATTACK_3)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_DUALHAND_SWORD, COMBO_TYPE_2, COMBO_INDEX_4, chr.MOTION_COMBO_ATTACK_5)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_DUALHAND_SWORD, COMBO_TYPE_2, COMBO_INDEX_5, chr.MOTION_COMBO_ATTACK_7)
	## Combo Type 3
	chrmgr.ReserveComboAttackNew(chr.MOTION_MODE_DUALHAND_SWORD, COMBO_TYPE_3, 6)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_DUALHAND_SWORD, COMBO_TYPE_3, COMBO_INDEX_1, chr.MOTION_COMBO_ATTACK_1)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_DUALHAND_SWORD, COMBO_TYPE_3, COMBO_INDEX_2, chr.MOTION_COMBO_ATTACK_2)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_DUALHAND_SWORD, COMBO_TYPE_3, COMBO_INDEX_3, chr.MOTION_COMBO_ATTACK_3)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_DUALHAND_SWORD, COMBO_TYPE_3, COMBO_INDEX_4, chr.MOTION_COMBO_ATTACK_5)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_DUALHAND_SWORD, COMBO_TYPE_3, COMBO_INDEX_5, chr.MOTION_COMBO_ATTACK_6)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_DUALHAND_SWORD, COMBO_TYPE_3, COMBO_INDEX_6, chr.MOTION_COMBO_ATTACK_8)

	## BOW BATTLE
	chrmgr.SetPathName(path + "bow/")
	chrmgr.RegisterMotionMode(chr.MOTION_MODE_BOW)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_BOW, chr.MOTION_WAIT,			"wait.msa", 70)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_BOW, chr.MOTION_WAIT,			"wait_1.msa", 30)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_BOW, chr.MOTION_WALK,			"walk.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_BOW, chr.MOTION_RUN,			"run.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_BOW, chr.MOTION_DAMAGE,		"damage.msa", 50)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_BOW, chr.MOTION_DAMAGE,		"damage_1.msa", 50)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_BOW, chr.MOTION_DAMAGE_BACK,	"damage_2.msa", 50)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_BOW, chr.MOTION_DAMAGE_BACK,	"damage_3.msa", 50)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_BOW, chr.MOTION_COMBO_ATTACK_1,		"attack.msa")
	chrmgr.ReserveComboAttackNew(chr.MOTION_MODE_BOW, COMBO_TYPE_1, 1)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_BOW, COMBO_TYPE_1, COMBO_INDEX_1, chr.MOTION_COMBO_ATTACK_1)

	if app.WJ_QUIVER_SYSTEM:
		chrmgr.SetPathName(path + "bow/")
		chrmgr.RegisterMotionMode(chr.MOTION_MODE_BOW_SPECIAL)
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_BOW_SPECIAL, chr.MOTION_WAIT, "wait.msa", 70)
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_BOW_SPECIAL, chr.MOTION_WAIT, "wait_1.msa", 30)
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_BOW_SPECIAL, chr.MOTION_WALK, "walk.msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_BOW_SPECIAL, chr.MOTION_RUN, "run.msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_BOW_SPECIAL, chr.MOTION_DAMAGE, "damage.msa", 50)
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_BOW_SPECIAL, chr.MOTION_DAMAGE, "damage_1.msa", 50)
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_BOW_SPECIAL, chr.MOTION_DAMAGE_BACK, "damage_2.msa", 50)
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_BOW_SPECIAL, chr.MOTION_DAMAGE_BACK, "damage_3.msa", 50)
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_BOW_SPECIAL, chr.MOTION_COMBO_ATTACK_1, "attack_special.msa")
		chrmgr.ReserveComboAttackNew(chr.MOTION_MODE_BOW_SPECIAL, COMBO_TYPE_1, 1)
		chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_BOW_SPECIAL, COMBO_TYPE_1, COMBO_INDEX_1, chr.MOTION_COMBO_ATTACK_1)
	
	## FISHING
	chrmgr.SetPathName(path + "fishing/")
	chrmgr.RegisterMotionMode(chr.MOTION_MODE_FISHING)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FISHING, chr.MOTION_WAIT,					"wait.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FISHING, chr.MOTION_WALK,					"walk.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FISHING, chr.MOTION_RUN,					"run.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FISHING, chr.MOTION_FISHING_THROW,		"throw.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FISHING, chr.MOTION_FISHING_WAIT,			"fishing_wait.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FISHING, chr.MOTION_FISHING_STOP,			"fishing_cancel.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FISHING, chr.MOTION_FISHING_REACT,		"fishing_react.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FISHING, chr.MOTION_FISHING_CATCH,		"fishing_catch.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FISHING, chr.MOTION_FISHING_FAIL,			"fishing_fail.msa")

	## HORSE
	chrmgr.SetPathName(path + "horse/")
	chrmgr.RegisterMotionMode(chr.MOTION_MODE_HORSE)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE, chr.MOTION_WAIT,				"wait.msa", 90)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE, chr.MOTION_WAIT,				"wait_1.msa", 9)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE, chr.MOTION_WAIT,				"wait_2.msa", 1)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE, chr.MOTION_WALK,				"walk.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE, chr.MOTION_RUN,				"run.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE, chr.MOTION_DAMAGE,			"damage.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE, chr.MOTION_DAMAGE_BACK,		"damage.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE, chr.MOTION_DEAD,				"dead.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE, HORSE_SKILL_CHARGE, "skill_charge.msa")

	## HORSE_ONEHAND_SWORD
	chrmgr.SetPathName(path + "horse_onehand_sword/")
	chrmgr.RegisterMotionMode(chr.MOTION_MODE_HORSE_ONEHAND_SWORD)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_ONEHAND_SWORD, chr.MOTION_COMBO_ATTACK_1, "combo_01.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_ONEHAND_SWORD, chr.MOTION_COMBO_ATTACK_2, "combo_02.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_ONEHAND_SWORD, chr.MOTION_COMBO_ATTACK_3, "combo_03.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_ONEHAND_SWORD, HORSE_SKILL_WILDATTACK, "skill_wildattack.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_ONEHAND_SWORD, HORSE_SKILL_SPLASH, "skill_splash.msa")
	chrmgr.ReserveComboAttackNew(chr.MOTION_MODE_HORSE_ONEHAND_SWORD, COMBO_TYPE_1, 3)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_HORSE_ONEHAND_SWORD, COMBO_TYPE_1, COMBO_INDEX_1, chr.MOTION_COMBO_ATTACK_1)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_HORSE_ONEHAND_SWORD, COMBO_TYPE_1, COMBO_INDEX_2, chr.MOTION_COMBO_ATTACK_2)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_HORSE_ONEHAND_SWORD, COMBO_TYPE_1, COMBO_INDEX_3, chr.MOTION_COMBO_ATTACK_3)

	## HORSE_DUALHAND_SWORD
	chrmgr.SetPathName(path + "horse_dualhand_sword/")
	chrmgr.RegisterMotionMode(chr.MOTION_MODE_HORSE_DUALHAND_SWORD)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_DUALHAND_SWORD, chr.MOTION_COMBO_ATTACK_1, "combo_01.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_DUALHAND_SWORD, chr.MOTION_COMBO_ATTACK_2, "combo_02.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_DUALHAND_SWORD, chr.MOTION_COMBO_ATTACK_3, "combo_03.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_DUALHAND_SWORD, HORSE_SKILL_WILDATTACK, "skill_wildattack.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_DUALHAND_SWORD, HORSE_SKILL_SPLASH, "skill_splash.msa")
	chrmgr.ReserveComboAttackNew(chr.MOTION_MODE_HORSE_DUALHAND_SWORD, COMBO_TYPE_1, 3)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_HORSE_DUALHAND_SWORD, COMBO_TYPE_1, COMBO_INDEX_1, chr.MOTION_COMBO_ATTACK_1)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_HORSE_DUALHAND_SWORD, COMBO_TYPE_1, COMBO_INDEX_2, chr.MOTION_COMBO_ATTACK_2)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_HORSE_DUALHAND_SWORD, COMBO_TYPE_1, COMBO_INDEX_3, chr.MOTION_COMBO_ATTACK_3)

	## HORSE_BOW
	chrmgr.SetPathName(path + "horse_bow/")
	chrmgr.RegisterMotionMode(chr.MOTION_MODE_HORSE_BOW)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_BOW, chr.MOTION_WAIT,				"wait.msa", 90)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_BOW, chr.MOTION_WAIT,				"wait_1.msa", 9)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_BOW, chr.MOTION_WAIT,				"wait_2.msa", 1)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_BOW, chr.MOTION_RUN,				"run.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_BOW, chr.MOTION_DAMAGE,			"damage.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_BOW, chr.MOTION_DEAD,				"dead.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_BOW, chr.MOTION_COMBO_ATTACK_1,	"attack.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_BOW, HORSE_SKILL_WILDATTACK,		"skill_wildattack.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_BOW, HORSE_SKILL_SPLASH,			"skill_splash.msa")
	chrmgr.ReserveComboAttackNew(chr.MOTION_MODE_HORSE_BOW, COMBO_TYPE_1, 1)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_HORSE_BOW, COMBO_TYPE_1, COMBO_INDEX_1, chr.MOTION_COMBO_ATTACK_1)

	if app.WJ_QUIVER_SYSTEM:
		chrmgr.SetPathName(path + "horse_bow/")
		chrmgr.RegisterMotionMode(chr.MOTION_MODE_HORSE_BOW_SPECIAL)
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_BOW_SPECIAL, chr.MOTION_WAIT,				"wait.msa", 90)
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_BOW_SPECIAL, chr.MOTION_WAIT,				"wait_1.msa", 9)
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_BOW_SPECIAL, chr.MOTION_WAIT,				"wait_2.msa", 1)
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_BOW_SPECIAL, chr.MOTION_RUN,				"run.msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_BOW_SPECIAL, chr.MOTION_DAMAGE,			"damage.msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_BOW_SPECIAL, chr.MOTION_DEAD,				"dead.msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_BOW_SPECIAL, chr.MOTION_COMBO_ATTACK_1,	"attack_special.msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_BOW_SPECIAL, HORSE_SKILL_WILDATTACK,		"skill_wildattack.msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_BOW_SPECIAL, HORSE_SKILL_SPLASH,			"skill_splash.msa")
		chrmgr.ReserveComboAttackNew(chr.MOTION_MODE_HORSE_BOW_SPECIAL, COMBO_TYPE_1, 1)
		chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_HORSE_BOW_SPECIAL, COMBO_TYPE_1, COMBO_INDEX_1, chr.MOTION_COMBO_ATTACK_1)
	
	chrmgr.RegisterAttachingBoneName(chr.PART_WEAPON, "equip_right")
	chrmgr.RegisterAttachingBoneName(chr.PART_WEAPON_LEFT, "equip_left")
	if app.ENABLE_SASH_SYSTEM:
		chrmgr.RegisterAttachingBoneName(chr.PART_SASH, "Bip01 Spine2")
	chrmgr.RegisterAttachingBoneName(chr.PART_WEAPON_RIGHT, "equip_right")

def __LoadGameSuraEx(race, path):
	## Sura
	#########################################################################################
	chrmgr.SelectRace(race)

	## GENERAL MOTION MODE
	SetGeneralMotions(chr.MOTION_MODE_GENERAL, path + "general/")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_COMBO_ATTACK_1,	"attack.msa", 50)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_COMBO_ATTACK_1,	"attack_1.msa", 50)

	chrmgr.ReserveComboAttackNew(chr.MOTION_MODE_GENERAL, COMBO_TYPE_1, 1)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_GENERAL, COMBO_TYPE_1, COMBO_INDEX_1, chr.MOTION_COMBO_ATTACK_1)

	## SKILL
	chrmgr.SetPathName(path + "skill/")
	# chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+4, "geongon.msa")

	for i in xrange(skill.SKILL_EFFECT_COUNT):
		END_STRING = ""
		if i != 0: END_STRING = "_%d" % (i+1)
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+1, "swaeryeong" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+2, "yonggwon" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+3, "gwigeom" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+4, "gongpo" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+5, "jumagap" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+6, "pabeop" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+16, "maryeong" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+17, "hwayeom" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+18, "muyeong" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+19, "heuksin" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+20, "tusok" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+21, "mahwan" + END_STRING + ".msa")

	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, GUILD_SKILL_DRAGONBLOOD, "guild_yongsinuipi.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, GUILD_SKILL_DRAGONBLESS, "guild_yongsinuichukbok.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, GUILD_SKILL_BLESSARMOR, "guild_seonghwigap.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, GUILD_SKILL_SPPEDUP, "guild_gasokhwa.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, GUILD_SKILL_DRAGONWRATH, "guild_yongsinuibunno.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, GUILD_SKILL_MAGICUP, "guild_jumunsul.msa")

	## EMOTION
	emotion.RegisterEmotionAnis(path)

	## ONEHAND_SWORD BATTLE
	chrmgr.SetPathName(path + "onehand_sword/")
	chrmgr.RegisterMotionMode(chr.MOTION_MODE_ONEHAND_SWORD)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_ONEHAND_SWORD, chr.MOTION_WAIT,				"wait.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_ONEHAND_SWORD, chr.MOTION_WALK,				"walk.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_ONEHAND_SWORD, chr.MOTION_RUN,				"run.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_ONEHAND_SWORD, chr.MOTION_DAMAGE,			"damage.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_ONEHAND_SWORD, chr.MOTION_DAMAGE,			"damage.msa", 50)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_ONEHAND_SWORD, chr.MOTION_DAMAGE,			"damage_1.msa", 50)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_ONEHAND_SWORD, chr.MOTION_DAMAGE_BACK,		"damage_2.msa", 50)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_ONEHAND_SWORD, chr.MOTION_DAMAGE_BACK,		"damage_3.msa", 50)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_ONEHAND_SWORD, chr.MOTION_COMBO_ATTACK_1,	"combo_01.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_ONEHAND_SWORD, chr.MOTION_COMBO_ATTACK_2,	"combo_02.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_ONEHAND_SWORD, chr.MOTION_COMBO_ATTACK_3,	"combo_03.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_ONEHAND_SWORD, chr.MOTION_COMBO_ATTACK_4,	"combo_04.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_ONEHAND_SWORD, chr.MOTION_COMBO_ATTACK_5,	"combo_05.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_ONEHAND_SWORD, chr.MOTION_COMBO_ATTACK_6,	"combo_06.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_ONEHAND_SWORD, chr.MOTION_COMBO_ATTACK_7,	"combo_07.msa")

	## Combo Type 1
	chrmgr.ReserveComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_1, 4)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_1, COMBO_INDEX_1, chr.MOTION_COMBO_ATTACK_1)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_1, COMBO_INDEX_2, chr.MOTION_COMBO_ATTACK_2)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_1, COMBO_INDEX_3, chr.MOTION_COMBO_ATTACK_3)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_1, COMBO_INDEX_4, chr.MOTION_COMBO_ATTACK_4)
	## Combo Type 2
	chrmgr.ReserveComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_2, 5)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_2, COMBO_INDEX_1, chr.MOTION_COMBO_ATTACK_1)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_2, COMBO_INDEX_2, chr.MOTION_COMBO_ATTACK_2)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_2, COMBO_INDEX_3, chr.MOTION_COMBO_ATTACK_3)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_2, COMBO_INDEX_4, chr.MOTION_COMBO_ATTACK_5)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_2, COMBO_INDEX_5, chr.MOTION_COMBO_ATTACK_7)
	## Combo Type 3
	chrmgr.ReserveComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_3, 6)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_3, COMBO_INDEX_1, chr.MOTION_COMBO_ATTACK_1)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_3, COMBO_INDEX_2, chr.MOTION_COMBO_ATTACK_2)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_3, COMBO_INDEX_3, chr.MOTION_COMBO_ATTACK_3)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_3, COMBO_INDEX_4, chr.MOTION_COMBO_ATTACK_5)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_3, COMBO_INDEX_5, chr.MOTION_COMBO_ATTACK_6)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_ONEHAND_SWORD, COMBO_TYPE_3, COMBO_INDEX_6, chr.MOTION_COMBO_ATTACK_4)

	## FISHING
	chrmgr.SetPathName(path + "fishing/")
	chrmgr.RegisterMotionMode(chr.MOTION_MODE_FISHING)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FISHING, chr.MOTION_WAIT,					"wait.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FISHING, chr.MOTION_WALK,					"walk.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FISHING, chr.MOTION_RUN,						"run.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FISHING, chr.MOTION_FISHING_THROW,			"throw.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FISHING, chr.MOTION_FISHING_WAIT,			"fishing_wait.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FISHING, chr.MOTION_FISHING_STOP,			"fishing_cancel.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FISHING, chr.MOTION_FISHING_REACT,			"fishing_react.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FISHING, chr.MOTION_FISHING_CATCH,			"fishing_catch.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FISHING, chr.MOTION_FISHING_FAIL,			"fishing_fail.msa")

	## HORSE
	chrmgr.SetPathName(path + "horse/")
	chrmgr.RegisterMotionMode(chr.MOTION_MODE_HORSE)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE, chr.MOTION_WAIT,				"wait.msa", 90)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE, chr.MOTION_WAIT,				"wait_1.msa", 9)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE, chr.MOTION_WAIT,				"wait_2.msa", 1)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE, chr.MOTION_WALK,				"walk.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE, chr.MOTION_RUN,				"run.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE, chr.MOTION_DAMAGE,			"damage.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE, chr.MOTION_DAMAGE_BACK,		"damage.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE, chr.MOTION_DEAD,				"dead.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE, HORSE_SKILL_CHARGE,			"skill_charge.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE, HORSE_SKILL_SPLASH,			"skill_splash.msa")

	## HORSE_ONEHAND_SWORD
	chrmgr.SetPathName(path + "horse_onehand_sword/")
	chrmgr.RegisterMotionMode(chr.MOTION_MODE_HORSE_ONEHAND_SWORD)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_ONEHAND_SWORD, chr.MOTION_COMBO_ATTACK_1, "combo_01.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_ONEHAND_SWORD, chr.MOTION_COMBO_ATTACK_2, "combo_02.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_ONEHAND_SWORD, chr.MOTION_COMBO_ATTACK_3, "combo_03.msa")
	chrmgr.ReserveComboAttackNew(chr.MOTION_MODE_HORSE_ONEHAND_SWORD, COMBO_TYPE_1, 3)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_HORSE_ONEHAND_SWORD, COMBO_TYPE_1, COMBO_INDEX_1, chr.MOTION_COMBO_ATTACK_1)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_HORSE_ONEHAND_SWORD, COMBO_TYPE_1, COMBO_INDEX_2, chr.MOTION_COMBO_ATTACK_2)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_HORSE_ONEHAND_SWORD, COMBO_TYPE_1, COMBO_INDEX_3, chr.MOTION_COMBO_ATTACK_3)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_ONEHAND_SWORD, HORSE_SKILL_WILDATTACK, "skill_wildattack.msa")

	chrmgr.RegisterAttachingBoneName(chr.PART_WEAPON, "equip_right")
	if app.ENABLE_SASH_SYSTEM:
		chrmgr.RegisterAttachingBoneName(chr.PART_SASH, "Bip01 Spine2")
	chrmgr.RegisterAttachingBoneName(chr.PART_WEAPON_RIGHT, "equip_right")

def __LoadGameShamanEx(race, path):
	## Shaman
	#########################################################################################
	chrmgr.SelectRace(race)

	## GENERAL MOTION MODE
	SetGeneralMotions(chr.MOTION_MODE_GENERAL, path + "general/")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_COMBO_ATTACK_1,	"attack.msa", 50)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_COMBO_ATTACK_1,	"attack_1.msa", 50)

	chrmgr.ReserveComboAttackNew(chr.MOTION_MODE_GENERAL, COMBO_TYPE_1, 1)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_GENERAL, COMBO_TYPE_1, COMBO_INDEX_1, chr.MOTION_COMBO_ATTACK_1)

	## EMOTION
	emotion.RegisterEmotionAnis(path)

	## Fan
	chrmgr.SetPathName(path + "fan/")
	chrmgr.RegisterMotionMode(chr.MOTION_MODE_FAN)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FAN, chr.MOTION_WAIT,			"wait.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FAN, chr.MOTION_WALK,			"walk.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FAN, chr.MOTION_RUN,				"run.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FAN, chr.MOTION_DAMAGE,			"damage.msa", 50)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FAN, chr.MOTION_DAMAGE,			"damage_1.msa", 50)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FAN, chr.MOTION_DAMAGE_BACK,		"damage_2.msa", 50)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FAN, chr.MOTION_DAMAGE_BACK,		"damage_3.msa", 50)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FAN, chr.MOTION_COMBO_ATTACK_1,	"combo_01.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FAN, chr.MOTION_COMBO_ATTACK_2,	"combo_02.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FAN, chr.MOTION_COMBO_ATTACK_3,	"combo_03.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FAN, chr.MOTION_COMBO_ATTACK_4,	"combo_04.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FAN, chr.MOTION_COMBO_ATTACK_5,	"combo_05.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FAN, chr.MOTION_COMBO_ATTACK_6,	"combo_06.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FAN, chr.MOTION_COMBO_ATTACK_7,	"combo_07.msa")

	## Combo Type 1
	chrmgr.ReserveComboAttackNew(chr.MOTION_MODE_FAN, COMBO_TYPE_1, 4)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_FAN, COMBO_TYPE_1, COMBO_INDEX_1, chr.MOTION_COMBO_ATTACK_1)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_FAN, COMBO_TYPE_1, COMBO_INDEX_2, chr.MOTION_COMBO_ATTACK_2)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_FAN, COMBO_TYPE_1, COMBO_INDEX_3, chr.MOTION_COMBO_ATTACK_3)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_FAN, COMBO_TYPE_1, COMBO_INDEX_4, chr.MOTION_COMBO_ATTACK_4)
	## Combo Type 2
	chrmgr.ReserveComboAttackNew(chr.MOTION_MODE_FAN, COMBO_TYPE_2, 5)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_FAN, COMBO_TYPE_2, COMBO_INDEX_1, chr.MOTION_COMBO_ATTACK_1)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_FAN, COMBO_TYPE_2, COMBO_INDEX_2, chr.MOTION_COMBO_ATTACK_2)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_FAN, COMBO_TYPE_2, COMBO_INDEX_3, chr.MOTION_COMBO_ATTACK_3)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_FAN, COMBO_TYPE_2, COMBO_INDEX_4, chr.MOTION_COMBO_ATTACK_5)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_FAN, COMBO_TYPE_2, COMBO_INDEX_5, chr.MOTION_COMBO_ATTACK_7)
	## Combo Type 3
	chrmgr.ReserveComboAttackNew(chr.MOTION_MODE_FAN, COMBO_TYPE_3, 6)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_FAN, COMBO_TYPE_3, COMBO_INDEX_1, chr.MOTION_COMBO_ATTACK_1)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_FAN, COMBO_TYPE_3, COMBO_INDEX_2, chr.MOTION_COMBO_ATTACK_2)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_FAN, COMBO_TYPE_3, COMBO_INDEX_3, chr.MOTION_COMBO_ATTACK_3)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_FAN, COMBO_TYPE_3, COMBO_INDEX_4, chr.MOTION_COMBO_ATTACK_5)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_FAN, COMBO_TYPE_3, COMBO_INDEX_5, chr.MOTION_COMBO_ATTACK_6)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_FAN, COMBO_TYPE_3, COMBO_INDEX_6, chr.MOTION_COMBO_ATTACK_4)

	## Bell
	chrmgr.SetPathName(path + "Bell/")
	chrmgr.RegisterMotionMode(chr.MOTION_MODE_BELL)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_BELL, chr.MOTION_WAIT,			"wait.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_BELL, chr.MOTION_WALK,			"walk.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_BELL, chr.MOTION_RUN,			"run.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_BELL, chr.MOTION_DAMAGE,			"damage.msa", 50)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_BELL, chr.MOTION_DAMAGE,			"damage_1.msa", 50)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_BELL, chr.MOTION_DAMAGE_BACK,	"damage_2.msa", 50)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_BELL, chr.MOTION_DAMAGE_BACK,	"damage_3.msa", 50)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_BELL, chr.MOTION_COMBO_ATTACK_1,	"combo_01.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_BELL, chr.MOTION_COMBO_ATTACK_2,	"combo_02.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_BELL, chr.MOTION_COMBO_ATTACK_3,	"combo_03.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_BELL, chr.MOTION_COMBO_ATTACK_4,	"combo_04.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_BELL, chr.MOTION_COMBO_ATTACK_5,	"combo_05.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_BELL, chr.MOTION_COMBO_ATTACK_6,	"combo_06.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_BELL, chr.MOTION_COMBO_ATTACK_7,	"combo_07.msa")

	## Combo Type 1
	chrmgr.ReserveComboAttackNew(chr.MOTION_MODE_BELL, COMBO_TYPE_1, 4)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_BELL, COMBO_TYPE_1, COMBO_INDEX_1, chr.MOTION_COMBO_ATTACK_1)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_BELL, COMBO_TYPE_1, COMBO_INDEX_2, chr.MOTION_COMBO_ATTACK_2)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_BELL, COMBO_TYPE_1, COMBO_INDEX_3, chr.MOTION_COMBO_ATTACK_3)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_BELL, COMBO_TYPE_1, COMBO_INDEX_4, chr.MOTION_COMBO_ATTACK_4)
	## Combo Type 2
	chrmgr.ReserveComboAttackNew(chr.MOTION_MODE_BELL, COMBO_TYPE_2, 5)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_BELL, COMBO_TYPE_2, COMBO_INDEX_1, chr.MOTION_COMBO_ATTACK_1)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_BELL, COMBO_TYPE_2, COMBO_INDEX_2, chr.MOTION_COMBO_ATTACK_2)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_BELL, COMBO_TYPE_2, COMBO_INDEX_3, chr.MOTION_COMBO_ATTACK_3)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_BELL, COMBO_TYPE_2, COMBO_INDEX_4, chr.MOTION_COMBO_ATTACK_5)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_BELL, COMBO_TYPE_2, COMBO_INDEX_5, chr.MOTION_COMBO_ATTACK_7)
	## Combo Type 3
	chrmgr.ReserveComboAttackNew(chr.MOTION_MODE_BELL, COMBO_TYPE_3, 6)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_BELL, COMBO_TYPE_3, COMBO_INDEX_1, chr.MOTION_COMBO_ATTACK_1)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_BELL, COMBO_TYPE_3, COMBO_INDEX_2, chr.MOTION_COMBO_ATTACK_2)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_BELL, COMBO_TYPE_3, COMBO_INDEX_3, chr.MOTION_COMBO_ATTACK_3)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_BELL, COMBO_TYPE_3, COMBO_INDEX_4, chr.MOTION_COMBO_ATTACK_5)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_BELL, COMBO_TYPE_3, COMBO_INDEX_5, chr.MOTION_COMBO_ATTACK_6)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_BELL, COMBO_TYPE_3, COMBO_INDEX_6, chr.MOTION_COMBO_ATTACK_4)

	## SKILL
	chrmgr.SetPathName(path + "skill/")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+1,		"bipabu.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+2,		"yongpa.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+3,		"paeryong.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+4,		"hosin_target.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+5,	"boho_target.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+6,	"gicheon_target.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+16,	"noejeon.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+17,	"byeorak.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+18,		"pokroe.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+19,		"jeongeop_target.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+20,		"kwaesok_target.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+21,	"jeungryeok_target.msa")
	#chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+10,	"budong.msa")

	START_INDEX = 0
	#skill.SKILL_EFFECT_COUNT //
	for i in (1, 2, 3):
		END_STRING = ""
		if i != 0: END_STRING = "_%d" % (i+1)
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+1,	"bipabu" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+2,	"yongpa" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+3,	"paeryong" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+4,	"hosin" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+5,	"boho" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+6,	"gicheon" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+16,	"noejeon" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+17,	"byeorak" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+18,	"pokroe" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+19,	"jeongeop" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+20,	"kwaesok" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+21,	"jeungryeok" + END_STRING + ".msa")
		#chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+10,	"budong" + END_STRING + ".msa")

	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, GUILD_SKILL_DRAGONBLOOD, "guild_yongsinuipi.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, GUILD_SKILL_DRAGONBLESS, "guild_yongsinuichukbok.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, GUILD_SKILL_BLESSARMOR, "guild_seonghwigap.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, GUILD_SKILL_SPPEDUP, "guild_gasokhwa.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, GUILD_SKILL_DRAGONWRATH, "guild_yongsinuibunno.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, GUILD_SKILL_MAGICUP, "guild_jumunsul.msa")

	## FISHING
	chrmgr.SetPathName(path + "fishing/")
	chrmgr.RegisterMotionMode(chr.MOTION_MODE_FISHING)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FISHING, chr.MOTION_WAIT,				"wait.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FISHING, chr.MOTION_WALK,				"walk.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FISHING, chr.MOTION_RUN,					"run.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FISHING, chr.MOTION_FISHING_THROW,		"throw.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FISHING, chr.MOTION_FISHING_WAIT,		"fishing_wait.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FISHING, chr.MOTION_FISHING_STOP,		"fishing_cancel.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FISHING, chr.MOTION_FISHING_REACT,		"fishing_react.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FISHING, chr.MOTION_FISHING_CATCH,		"fishing_catch.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FISHING, chr.MOTION_FISHING_FAIL,		"fishing_fail.msa")

	## HORSE
	chrmgr.SetPathName(path + "horse/")
	chrmgr.RegisterMotionMode(chr.MOTION_MODE_HORSE)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE, chr.MOTION_WAIT,				"wait.msa", 90)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE, chr.MOTION_WAIT,				"wait_1.msa", 9)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE, chr.MOTION_WAIT,				"wait_2.msa", 1)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE, chr.MOTION_WALK,				"walk.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE, chr.MOTION_RUN,				"run.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE, chr.MOTION_DAMAGE,			"damage.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE, chr.MOTION_DAMAGE_BACK,		"damage.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE, chr.MOTION_DEAD,				"dead.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE, HORSE_SKILL_CHARGE,			"skill_charge.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE, HORSE_SKILL_SPLASH,			"skill_splash.msa")

	## HORSE_FAN
	chrmgr.SetPathName(path + "horse_fan/")
	chrmgr.RegisterMotionMode(chr.MOTION_MODE_HORSE_FAN)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_FAN, chr.MOTION_COMBO_ATTACK_1, "combo_01.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_FAN, chr.MOTION_COMBO_ATTACK_2, "combo_02.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_FAN, chr.MOTION_COMBO_ATTACK_3, "combo_03.msa")
	chrmgr.ReserveComboAttackNew(chr.MOTION_MODE_HORSE_FAN, COMBO_TYPE_1, 3)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_HORSE_FAN, COMBO_TYPE_1, COMBO_INDEX_1, chr.MOTION_COMBO_ATTACK_1)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_HORSE_FAN, COMBO_TYPE_1, COMBO_INDEX_2, chr.MOTION_COMBO_ATTACK_2)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_HORSE_FAN, COMBO_TYPE_1, COMBO_INDEX_3, chr.MOTION_COMBO_ATTACK_3)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_FAN, HORSE_SKILL_WILDATTACK, "skill_wildattack.msa")

	## HORSE_BELL
	chrmgr.SetPathName(path + "horse_bell/")
	chrmgr.RegisterMotionMode(chr.MOTION_MODE_HORSE_BELL)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_BELL, chr.MOTION_COMBO_ATTACK_1, "combo_01.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_BELL, chr.MOTION_COMBO_ATTACK_2, "combo_02.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_BELL, chr.MOTION_COMBO_ATTACK_3, "combo_03.msa")
	chrmgr.ReserveComboAttackNew(chr.MOTION_MODE_HORSE_BELL, COMBO_TYPE_1, 3)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_HORSE_BELL, COMBO_TYPE_1, COMBO_INDEX_1, chr.MOTION_COMBO_ATTACK_1)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_HORSE_BELL, COMBO_TYPE_1, COMBO_INDEX_2, chr.MOTION_COMBO_ATTACK_2)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_HORSE_BELL, COMBO_TYPE_1, COMBO_INDEX_3, chr.MOTION_COMBO_ATTACK_3)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_BELL, HORSE_SKILL_WILDATTACK, "skill_wildattack.msa")

	chrmgr.RegisterAttachingBoneName(chr.PART_WEAPON, "equip_right")
	chrmgr.RegisterAttachingBoneName(chr.PART_WEAPON_LEFT, "equip_left")
	if app.ENABLE_SASH_SYSTEM:
		chrmgr.RegisterAttachingBoneName(chr.PART_SASH, "Bip01 Spine2")
	chrmgr.RegisterAttachingBoneName(chr.PART_WEAPON_RIGHT, "equip_right")

def __LoadGameWolfmanEx(race, path):

	## Wolfman
	#########################################################################################
	chrmgr.SelectRace(race)

	## GENERAL MODE
	SetGeneralMotionsForWolfman(chr.MOTION_MODE_GENERAL, path + "general/")
	chrmgr.SetMotionRandomWeight(chr.MOTION_MODE_GENERAL, chr.MOTION_WAIT, 0, 70)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_WAIT, "wait.msa", 30)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_WAIT, "wait1.msa", 30)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_WAIT, "wait2.msa", 30)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_COMBO_ATTACK_1, "attack1.msa", 50)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_COMBO_ATTACK_1, "attack2.msa", 50)

	chrmgr.ReserveComboAttackNew(chr.MOTION_MODE_GENERAL, COMBO_TYPE_1, 6)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_GENERAL, COMBO_TYPE_1, COMBO_INDEX_1, chr.MOTION_COMBO_ATTACK_1)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_GENERAL, COMBO_TYPE_1, COMBO_INDEX_2, chr.MOTION_COMBO_ATTACK_1)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_GENERAL, COMBO_TYPE_1, COMBO_INDEX_3, chr.MOTION_COMBO_ATTACK_1)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_GENERAL, COMBO_TYPE_1, COMBO_INDEX_4, chr.MOTION_COMBO_ATTACK_1)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_GENERAL, COMBO_TYPE_1, COMBO_INDEX_5, chr.MOTION_COMBO_ATTACK_1)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_GENERAL, COMBO_TYPE_1, COMBO_INDEX_6, chr.MOTION_COMBO_ATTACK_1)
	
	## SKILL
	chrmgr.SetPathName(path + "skill/")
	for i in xrange(skill.SKILL_EFFECT_COUNT):
		END_STRING = ""
		if i != 0: END_STRING = "_%d" % (i)
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+1, "split_slash" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+2, "wind_death" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+3, "reef_attack" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+4, "wreckage" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+5, "red_possession" + END_STRING + ".msa")
		chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SKILL+(i*skill.SKILL_GRADEGAP)+6, "blue_possession" + END_STRING + ".msa")	

	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, GUILD_SKILL_DRAGONBLOOD, "guild_yongsinuipi.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, GUILD_SKILL_DRAGONBLESS, "guild_yongsinuichukbok.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, GUILD_SKILL_BLESSARMOR, "guild_seonghwigap.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, GUILD_SKILL_SPPEDUP, "guild_gasokhwa.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, GUILD_SKILL_DRAGONWRATH, "guild_yongsinuibunno.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_GENERAL, GUILD_SKILL_MAGICUP, "guild_jumunsul.msa")

	chrmgr.ReserveComboAttackNew(chr.MOTION_MODE_GENERAL, COMBO_TYPE_1, 1)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_GENERAL, COMBO_TYPE_1, COMBO_INDEX_1, chr.MOTION_COMBO_ATTACK_1)

	## EMOTION
	emotion.RegisterEmotionAnis(path)

	## CLAW
	chrmgr.SetPathName(path + "claw/")
	chrmgr.RegisterMotionMode(chr.MOTION_MODE_CLAW)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_CLAW, chr.MOTION_WAIT, "wait1.msa", 50)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_CLAW, chr.MOTION_WAIT, "wait2.msa", 50)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_CLAW, chr.MOTION_WAIT, "wait.msa", 50)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_CLAW, chr.MOTION_WALK, "walk.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_CLAW, chr.MOTION_RUN, "run.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_CLAW, chr.MOTION_DAMAGE, "front_damage.msa", 50)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_CLAW, chr.MOTION_DAMAGE, "back_damage.msa", 50)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_CLAW, chr.MOTION_DAMAGE_BACK, "back_damage.msa", 50)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_CLAW, chr.MOTION_DAMAGE_BACK, "back_damage1.msa", 50)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_CLAW, chr.MOTION_COMBO_ATTACK_1,	"combo_01.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_CLAW, chr.MOTION_COMBO_ATTACK_2,	"combo_02.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_CLAW, chr.MOTION_COMBO_ATTACK_3,	"combo_03.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_CLAW, chr.MOTION_COMBO_ATTACK_4,	"combo_04.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_CLAW, chr.MOTION_COMBO_ATTACK_5,	"combo_05.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_CLAW, chr.MOTION_COMBO_ATTACK_6,	"combo_06.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_CLAW, chr.MOTION_COMBO_ATTACK_7,	"combo_07.msa")

	## Combo Type 1
	chrmgr.ReserveComboAttackNew(chr.MOTION_MODE_CLAW, COMBO_TYPE_1, 4)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_CLAW, COMBO_TYPE_1, COMBO_INDEX_1, chr.MOTION_COMBO_ATTACK_1)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_CLAW, COMBO_TYPE_1, COMBO_INDEX_2, chr.MOTION_COMBO_ATTACK_2)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_CLAW, COMBO_TYPE_1, COMBO_INDEX_3, chr.MOTION_COMBO_ATTACK_3)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_CLAW, COMBO_TYPE_1, COMBO_INDEX_4, chr.MOTION_COMBO_ATTACK_4)
	## Combo Type 2
	chrmgr.ReserveComboAttackNew(chr.MOTION_MODE_CLAW, COMBO_TYPE_2, 5)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_CLAW, COMBO_TYPE_2, COMBO_INDEX_1, chr.MOTION_COMBO_ATTACK_1)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_CLAW, COMBO_TYPE_2, COMBO_INDEX_2, chr.MOTION_COMBO_ATTACK_2)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_CLAW, COMBO_TYPE_2, COMBO_INDEX_3, chr.MOTION_COMBO_ATTACK_3)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_CLAW, COMBO_TYPE_2, COMBO_INDEX_4, chr.MOTION_COMBO_ATTACK_5)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_CLAW, COMBO_TYPE_2, COMBO_INDEX_5, chr.MOTION_COMBO_ATTACK_7)
	## Combo Type 3
	chrmgr.ReserveComboAttackNew(chr.MOTION_MODE_CLAW, COMBO_TYPE_3, 6)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_CLAW, COMBO_TYPE_3, COMBO_INDEX_1, chr.MOTION_COMBO_ATTACK_1)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_CLAW, COMBO_TYPE_3, COMBO_INDEX_2, chr.MOTION_COMBO_ATTACK_2)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_CLAW, COMBO_TYPE_3, COMBO_INDEX_3, chr.MOTION_COMBO_ATTACK_3)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_CLAW, COMBO_TYPE_3, COMBO_INDEX_4, chr.MOTION_COMBO_ATTACK_5)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_CLAW, COMBO_TYPE_3, COMBO_INDEX_5, chr.MOTION_COMBO_ATTACK_6)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_CLAW, COMBO_TYPE_3, COMBO_INDEX_6, chr.MOTION_COMBO_ATTACK_4)

	
	## FISHING
	chrmgr.SetPathName(path + "fishing/")
	chrmgr.RegisterMotionMode(chr.MOTION_MODE_FISHING)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FISHING, chr.MOTION_WAIT,			"wait.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FISHING, chr.MOTION_WALK,			"walk.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FISHING, chr.MOTION_RUN,				"run.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FISHING, chr.MOTION_FISHING_THROW,	"throw.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FISHING, chr.MOTION_FISHING_WAIT,	"fishing_wait.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FISHING, chr.MOTION_FISHING_STOP,	"fishing_cancel.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FISHING, chr.MOTION_FISHING_REACT,	"fishing_react.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FISHING, chr.MOTION_FISHING_CATCH,	"fishing_catch.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_FISHING, chr.MOTION_FISHING_FAIL,	"fishing_fail.msa")

	## HORSE
	chrmgr.SetPathName(path + "horse/")
	chrmgr.RegisterMotionMode(chr.MOTION_MODE_HORSE)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE, chr.MOTION_WAIT,				"wait.msa", 90)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE, chr.MOTION_WAIT,				"wait1.msa", 9)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE, chr.MOTION_WAIT,				"wait2.msa", 1)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE, chr.MOTION_WALK,				"walk.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE, chr.MOTION_RUN,				"run.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE, chr.MOTION_DAMAGE,			"front_damage.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE, chr.MOTION_DAMAGE_BACK,		"front_damage.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE, chr.MOTION_DEAD,				"dead.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE, HORSE_SKILL_CHARGE,			"skill_charge.msa")

	## HORSE_CLAW
	chrmgr.SetPathName(path + "horse_claw/")
	chrmgr.RegisterMotionMode(chr.MOTION_MODE_HORSE_CLAW)
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_CLAW, chr.MOTION_COMBO_ATTACK_1, "combo_01.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_CLAW, chr.MOTION_COMBO_ATTACK_2, "combo_02.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_CLAW, chr.MOTION_COMBO_ATTACK_3, "combo_03.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_CLAW, HORSE_SKILL_WILDATTACK, "skill_wildattack.msa")
	chrmgr.RegisterCacheMotionData(chr.MOTION_MODE_HORSE_CLAW, HORSE_SKILL_SPLASH, "skill_splash.msa")
	chrmgr.ReserveComboAttackNew(chr.MOTION_MODE_HORSE_CLAW, COMBO_TYPE_1, 3)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_HORSE_CLAW, COMBO_TYPE_1, COMBO_INDEX_1, chr.MOTION_COMBO_ATTACK_1)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_HORSE_CLAW, COMBO_TYPE_1, COMBO_INDEX_2, chr.MOTION_COMBO_ATTACK_2)
	chrmgr.RegisterComboAttackNew(chr.MOTION_MODE_HORSE_CLAW, COMBO_TYPE_1, COMBO_INDEX_3, chr.MOTION_COMBO_ATTACK_3)

	## Bone
	chrmgr.RegisterAttachingBoneName(chr.PART_WEAPON, "equip_right_weapon")
	chrmgr.RegisterAttachingBoneName(chr.PART_WEAPON_LEFT, "equip_left_weapon")
	if app.ENABLE_SASH_SYSTEM:
			chrmgr.RegisterAttachingBoneName(chr.PART_SASH, "Bip01 Spine2")
	chrmgr.RegisterAttachingBoneName(chr.PART_WEAPON_RIGHT, "equip_right")

def __LoadGameSkill():

	try:
		skill.LoadSkillData()
	except:
		import exception
		exception.Abort("__LoadGameSkill")

def __LoadGameEnemy():
	pass

def __LoadGameNPC():
	try:
		lines = pack_open("npclist.txt", "r").readlines()
	except IOError:
		import dbg
		dbg.LogBox("LoadLocaleError(%(srcFileName)s)" % locals())
		app.Abort()

	for line in lines:
		tokens = line[:-1].split("\t")
		if len(tokens) == 0 or not tokens[0]:
			continue

		try:
			vnum = int(tokens[0])
		except ValueError:
			import dbg
			dbg.LogBox("LoadGameNPC() - %s - line #%d: %s" % (tokens, lines.index(line), line))
			app.Abort()			

		try:
			if vnum:
				chrmgr.RegisterRaceName(vnum, tokens[1].strip())
			else:
				chrmgr.RegisterRaceSrcName(tokens[1].strip(), tokens[2].strip())
		except IndexError:
			import dbg
			dbg.LogBox("LoadGameNPC() - %d, %s - line #%d: %s " % (vnum, tokens, lines.index(line), line))
			app.Abort()

if app.ENABLE_RACE_HEIGHT:			
	def __LoadRaceHeight():
		try:
			lines = open("race_height.txt", "r").readlines()
		except IOError:
			return
			
		for line in lines:
			tokens = line[:-1].split("\t")
			if len(tokens) == 0 or not tokens[0]:
				continue
				
			vnum = int(tokens[0])
			height = float(tokens[1])
			
			chrmgr.SetRaceHeight(vnum, height)

# GUILD_BUILDING
def LoadGuildBuildingList(filename):
	import uiGuild
	uiGuild.BUILDING_DATA_LIST = []

	handle = app.OpenTextFile(filename)
	count = app.GetTextFileLineCount(handle)
	for i in xrange(count):
		line = app.GetTextFileLine(handle, i)
		tokens = line.split("\t")

		TOKEN_VNUM = 0
		TOKEN_TYPE = 1
		TOKEN_NAME = 2
		TOKEN_LOCAL_NAME = 3
		NO_USE_TOKEN_SIZE_1 = 4
		NO_USE_TOKEN_SIZE_2 = 5
		NO_USE_TOKEN_SIZE_3 = 6
		NO_USE_TOKEN_SIZE_4 = 7
		TOKEN_X_ROT_LIMIT = 8
		TOKEN_Y_ROT_LIMIT = 9
		TOKEN_Z_ROT_LIMIT = 10
		TOKEN_PRICE = 11
		TOKEN_MATERIAL = 12
		TOKEN_NPC = 13
		TOKEN_GROUP = 14
		TOKEN_DEPEND_GROUP = 15
		TOKEN_ENABLE_FLAG = 16
		LIMIT_TOKEN_COUNT = 17

		if not tokens[TOKEN_VNUM].isdigit():
			continue

		if len(tokens) < LIMIT_TOKEN_COUNT:
			import dbg
			dbg.TraceError("Strange token count [%d/%d] [%s]" % (len(tokens), LIMIT_TOKEN_COUNT, line))
			continue

		ENABLE_FLAG_TYPE_NOT_USE = False
		ENABLE_FLAG_TYPE_USE = True
		ENABLE_FLAG_TYPE_USE_BUT_HIDE = 2

		if ENABLE_FLAG_TYPE_NOT_USE == int(tokens[TOKEN_ENABLE_FLAG]):
			continue

		vnum = int(tokens[TOKEN_VNUM])
		type = tokens[TOKEN_TYPE]
		name = tokens[TOKEN_NAME]
		localName = tokens[TOKEN_LOCAL_NAME]
		xRotLimit = int(tokens[TOKEN_X_ROT_LIMIT])
		yRotLimit = int(tokens[TOKEN_Y_ROT_LIMIT])
		zRotLimit = int(tokens[TOKEN_Z_ROT_LIMIT])
		price = tokens[TOKEN_PRICE]
		material = tokens[TOKEN_MATERIAL]

		folderName = ""
		if "HEADQUARTER" == type:
			folderName = "headquarter"
		elif "FACILITY" == type:
			folderName = "facility"
		elif "OBJECT" == type:
			folderName = "object"
		elif "WALL" == type:
			folderName = "fence"

		materialList = ["0", "0", "0"]
		if material:
			if material[0] == "\"":
				material = material[1:]
			if material[-1] == "\"":
				material = material[:-1]
			for one in material.split("/"):
				data = one.split(",")
				if 2 != len(data):
					continue
				itemID = int(data[0])
				count = data[1]

				if itemID == uiGuild.MATERIAL_STONE_ID:
					materialList[uiGuild.MATERIAL_STONE_INDEX] = count
				elif itemID == uiGuild.MATERIAL_LOG_ID:
					materialList[uiGuild.MATERIAL_LOG_INDEX] = count
				elif itemID == uiGuild.MATERIAL_PLYWOOD_ID:
					materialList[uiGuild.MATERIAL_PLYWOOD_INDEX] = count

		## GuildSymbol  Ϲ NPC  Բ Ѵ.
		import chrmgr
		chrmgr.RegisterRaceSrcName(name, folderName)
		chrmgr.RegisterRaceName(vnum, name)

		appendingData = { "VNUM":vnum,
						  "TYPE":type,
						  "NAME":name,
						  "LOCAL_NAME":localName,
						  "X_ROT_LIMIT":xRotLimit,
						  "Y_ROT_LIMIT":yRotLimit,
						  "Z_ROT_LIMIT":zRotLimit,
						  "PRICE":price,
						  "MATERIAL":materialList,
						  "SHOW" : True }

		if ENABLE_FLAG_TYPE_USE_BUT_HIDE == int(tokens[TOKEN_ENABLE_FLAG]):
			appendingData["SHOW"] = False

		uiGuild.BUILDING_DATA_LIST.append(appendingData)

	app.CloseTextFile(handle)

# END_OF_GUILD_BUILDING

loadGameDataDict={
	"INIT" : __InitData,
	"SOUND" : __LoadGameSound,
	"EFFECT" : __LoadGameEffect,
	"WARRIOR" : __LoadGameWarrior,
	"ASSASSIN" : __LoadGameAssassin,
	"SURA" : __LoadGameSura,
	"SHAMAN" : __LoadGameShaman,
	"WOLFMAN": __LoadGameWolfman,
	"SKILL" : __LoadGameSkill,
	"ENEMY" : __LoadGameEnemy,
	"NPC" : __LoadGameNPC,
	#if app.ENABLE_RACE_HEIGHT:
	#"RACE_HEIGHT" : __LoadRaceHeight,
}

def LoadGameData(name):
	global loadGameDataDict

	load=loadGameDataDict.get(name, 0)
	if load:
		loadGameDataDict[name]=0
		try:
			load()
		except:
			print name
			import exception
			exception.Abort("LoadGameData")
			raise


## NPC

def SetMovingNPC(race, name):
	chrmgr.CreateRace(race)
	chrmgr.SelectRace(race)

	## RESERVED
	chrmgr.SetPathName("d:/ymir work/npc/" + name + "/")
	chrmgr.RegisterMotionMode(chr.MOTION_MODE_GENERAL)
	chrmgr.RegisterMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_WAIT, "wait.msa")
	chrmgr.RegisterMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_WALK, "walk.msa")
	chrmgr.RegisterMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_RUN, "run.msa")
	chrmgr.RegisterMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_DEAD, "die.msa")
	chrmgr.LoadRaceData(name + ".msm")

def SetOneNPC(race, name):
	chrmgr.CreateRace(race)
	chrmgr.SelectRace(race)

	## RESERVED
	chrmgr.SetPathName("d:/ymir work/npc/" + name + "/")
	chrmgr.RegisterMotionMode(chr.MOTION_MODE_GENERAL)
	chrmgr.RegisterMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_WAIT, "wait.msa")
	chrmgr.LoadRaceData(name + ".msm")

def SetGuard(race, name):
	chrmgr.CreateRace(race)
	chrmgr.SelectRace(race)

	## Script Data
	chrmgr.SetPathName("d:/ymir work/npc/" + name + "/")
	chrmgr.LoadRaceData(name + ".msm")

	## GENERAL
	chrmgr.RegisterMotionMode(chr.MOTION_MODE_GENERAL)
	chrmgr.RegisterMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_SPAWN,		"00.msa")
	chrmgr.RegisterMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_WAIT,			"00.msa")
	chrmgr.RegisterMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_RUN,			"03.msa")

	chrmgr.RegisterMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_DAMAGE,		"30.msa", 50)
	chrmgr.RegisterMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_DAMAGE,		"30_1.msa", 50)

	chrmgr.RegisterMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_DAMAGE_BACK,	"34.msa", 50)
	chrmgr.RegisterMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_DAMAGE_BACK,	"34_1.msa", 50)

	chrmgr.RegisterMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_DAMAGE_FLYING,"32.msa")
	chrmgr.RegisterMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_STAND_UP,		"33.msa")

	chrmgr.RegisterMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_DAMAGE_FLYING_BACK,	"35.msa")
	chrmgr.RegisterMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_STAND_UP_BACK,		"36.msa")

	chrmgr.RegisterMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_DEAD,					"31.msa")
	chrmgr.RegisterMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_DEAD_BACK,			"37.msa")

	chrmgr.RegisterMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_NORMAL_ATTACK,		"20.msa")

	## Attacking Data
	chrmgr.RegisterNormalAttack(chr.MOTION_MODE_GENERAL, chr.MOTION_NORMAL_ATTACK)

def SetWarp(race):
	chrmgr.CreateRace(race)
	chrmgr.SelectRace(race)

	chrmgr.SetPathName("d:/ymir work/npc/warp/")
	chrmgr.LoadRaceData("warp.msm")

	## GENERAL
	chrmgr.RegisterMotionMode(chr.MOTION_MODE_GENERAL)
	chrmgr.RegisterMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_WAIT, "wait.msa")

def SetDoor(race, name):
	chrmgr.CreateRace(race)
	chrmgr.SelectRace(race)
	chrmgr.SetPathName("d:/ymir work/npc/"+name+"/")
	chrmgr.LoadRaceData(name + ".msm")
	chrmgr.RegisterMotionMode(chr.MOTION_MODE_GENERAL)
	chrmgr.RegisterMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_WAIT, "close_wait.msa")
	chrmgr.RegisterMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_DEAD, "open.msa")

def SetGuildBuilding(race, name, grade):
	chrmgr.CreateRace(race)
	chrmgr.SelectRace(race)
	chrmgr.SetPathName("d:/ymir work/guild/building/%s/" % name)
	chrmgr.LoadRaceData("%s%02d.msm" % (name, grade))
	chrmgr.RegisterMotionMode(chr.MOTION_MODE_GENERAL)
	#chrmgr.RegisterMotionData(chr.MOTION_MODE_GENERAL, chr.MOTION_DEAD, name + "_destruction.msa")

def OLD_SetNPC():
	SetOneNPC(9001, "arms")
	SetOneNPC(9002, "defence")
	SetOneNPC(9003, "goods")
	SetOneNPC(9004, "bank")
	SetOneNPC(9005, "hotel_grandfa")
	SetOneNPC(9006, "hotel_grandma")
	SetOneNPC(9007, "arms")
	SetOneNPC(9008, "defence")
	SetOneNPC(9009, "sailor")

	SetMovingNPC(20001, "alchemist")
	SetMovingNPC(20002, "auntie")
	SetMovingNPC(20003, "baby_and_mom")
	SetMovingNPC(20004, "beggar")
	SetMovingNPC(20005, "ceramist")
	SetMovingNPC(20006, "girl_lost_elder_brother")
	SetMovingNPC(20007, "hotel_grandfa")
	SetMovingNPC(20008, "mr_restaurant")
	SetMovingNPC(20009, "oldster")
	SetMovingNPC(20010, "peddler")
	SetMovingNPC(20011, "plant_researcher")
	SetMovingNPC(20012, "rice_cake_seller")
	SetMovingNPC(20013, "sailor")
	SetMovingNPC(20014, "timid_boy")
	SetMovingNPC(20015, "woodcutter")
	SetMovingNPC(20016, "blacksmith")
	SetMovingNPC(20017, "musician")
	SetMovingNPC(20018, "doctor")
	SetMovingNPC(20019, "hunter")
	SetMovingNPC(20020, "old_pirate")
	SetMovingNPC(20021, "widow")
	SetMovingNPC(20022, "young_merchant")
	SetMovingNPC(20023, "bookworm")
	SetMovingNPC(20024, "yu_hwa_rang")
	SetMovingNPC(20041, "beggar")
	SetMovingNPC(20042, "peddler")

	SetGuard(20300, "sinsu_patrol_spear")
	SetGuard(20301, "sinsu_patrol_spear")
	SetGuard(20302, "sinsu_patrol_spear")
	SetGuard(20303, "sinsu_patrol_spear")
	SetGuard(20304, "sinsu_patrol_spear")
	SetGuard(20305, "sinsu_patrol_spear")
	SetGuard(20306, "sinsu_patrol_spear")
	SetGuard(20307, "sinsu_patrol_spear")

	SetGuard(20320, "gangyo_patrol_spear")
	SetGuard(20321, "gangyo_patrol_spear")
	SetGuard(20322, "gangyo_patrol_spear")
	SetGuard(20323, "gangyo_patrol_spear")
	SetGuard(20324, "gangyo_patrol_spear")
	SetGuard(20325, "gangyo_patrol_spear")
	SetGuard(20326, "gangyo_patrol_spear")
	SetGuard(20327, "gangyo_patrol_spear")

	SetGuard(20340, "jinno_patrol_spear")
	SetGuard(20341, "jinno_patrol_spear")
	SetGuard(20342, "jinno_patrol_spear")
	SetGuard(20343, "jinno_patrol_spear")
	SetGuard(20344, "jinno_patrol_spear")
	SetGuard(20345, "jinno_patrol_spear")
	SetGuard(20346, "jinno_patrol_spear")
	SetGuard(20347, "jinno_patrol_spear")

	## Warp
	for i in xrange(18):
		SetWarp(10001 + i)

	SetGuard(11000, "gangyo_patrol_spear")
	SetGuard(11001, "gangyo_patrol_bow")
	SetGuard(11002, "jinno_patrol_spear")
	SetGuard(11003, "jinno_patrol_bow")
	SetGuard(11004, "sinsu_patrol_spear")
	SetGuard(11005, "sinsu_patrol_bow")

	## Campfire (Bonfire)
	chrmgr.CreateRace(12000)
	chrmgr.SelectRace(12000)
	chrmgr.SetPathName("d:/ymir Work/npc/campfire/")
	chrmgr.LoadRaceData("campfire.msm")

	## Door
	SetDoor(13000, "wooden_door")
	SetDoor(13001, "stone_door")
