import ui
import chat
import app
import player
import snd
import item
import net
import game
import localeInfo

class BonusBoardDialog(ui.ScriptWindow):
	MaxBoni = { "1": 16000, "2": 320, "3": 32, "4": 32, "5": 32, "6": 32, "7": 16, "9": 40, "10": 60, "11": 60, "12": 16, "13": 24, "14": 16, "15": 30, "16": 30, "17": 50, "18": 100, "19": 100, "20": 100, "21": 100, "22": 100, "23": 20, "24": 40, "27": 15, "28": 30, "29": 72, "30": 72, "31": 72, "32": 72, "33": 72, "34": 72, "35": 60, "36": 60, "37": 40, "38": 60, "39": 20, "41": 10, "43": 60, "44": 60, "45": 40, "48": 1, "53": 50 }
	BonusDict = ["PvP Bonus", "PvM Bonus", "Dier"]
	BonusIDListe = [
		[""									, 0, 0],
		["Maks HP"							, 1, 0],
		["Maks SP"							, 2, 0],
		["HP"								, 3, 0],
		[localeInfo.EBONUS_ZEKA				, 4, 0],
		[localeInfo.EBONUS_GUC				, 5, 0],
		[localeInfo.EBONUS_CEVIKLIK			, 6, 0],
		[localeInfo.EBONUS_SALDIRIHIZI		, 7, 0],
		[localeInfo.EBONUS_HAREKETHIZI		, 8, 0],
		[localeInfo.EBONUS_BUYUHIZI			, 9, 0],
		[localeInfo.EBONUS_HPURETIM			, 10, 32],
		[localeInfo.EBONUS_SPURETIM			, 11, 33],
		[localeInfo.EBONUS_ZEHIRLEMEDEGISIM	, 12, 37],
		[localeInfo.EBONUS_SERSEMLETMESANSI	, 13, 38],
		[localeInfo.EBONUS_YAVASLATMASANSI	, 14, 39],
		[localeInfo.EBONUS_KRITIKSANSI		, 15, 40],
		[localeInfo.EBONUS_DELICISANSI		, 16, 41],
		[localeInfo.EBONUS_YARIINSAN		, 17, 43],
		[localeInfo.EBONUS_HAYVANLARAKARSI	, 18, 44],
		[localeInfo.EBONUS_ORKLARAKARSI		, 19, 45],
		[localeInfo.EBONUS_MISTIKLEREKARSI	, 20, 46],
		[localeInfo.EBONUS_OLUMSUZLEREKARSI	, 21, 47],
		[localeInfo.EBONUS_OLUMSUZLEREKARSI	, 22, 48],
		[localeInfo.EBONUS_HPEMILIMI		, 23, 63],
		[localeInfo.EBONUS_SPEMILIMI		, 24, 64],
		[localeInfo.EBONUS_SPCALMA			, 25, 65],
		[localeInfo.EBONUS_SPCALMAVURUSILE	, 26, 66],
		[localeInfo.EBONUS_BEDENBLOKLAMA	, 27, 67],
		[localeInfo.EBONUS_OKLARDANKORUNMASANS, 28, 68],
		[localeInfo.EBONUS_KILICSAVUNMASI	, 29, 69],
		[localeInfo.EBONUS_CIFTELSAVUNMASI	, 30, 70],
		[localeInfo.EBONUS_BICAKSAVUNMASI, 31, 71],
		[localeInfo.EBONUS_CANSAVUNMASI, 32, 72],
		[localeInfo.EBONUS_YELPAZESAVUNMASI, 33, 73],
		[localeInfo.EBONUS_OKSAVUNMASI, 34, 74],
		[localeInfo.EBONUS_ATESDAYANIKLILIK, 35, 75],
		[localeInfo.EBONUS_SIMSEKDAYANIKLILIK, 36, 76],
		[localeInfo.EBONUS_BUYUDAYANIKLILIK, 37, 77],
		[localeInfo.EBONUS_RUZGARDAYANIKLILIK, 38, 78],
		[localeInfo.EBONUS_YANSITMA, 39, 79],
		[localeInfo.EBONUS_LANETYANSITMA, 40, 80],
		[localeInfo.EBONUS_ZEHIREKARSIKOYMA, 41, 81],
		[localeInfo.EBONUS_SPYUKDEGISIM, 42, 82],
		[localeInfo.EBONUS_EXPBONUS, 43, 83],
		["Yang-Drop", 44, 84],
		["Item-Drop", 45, 85],
		[localeInfo.EBONUS_IXIRETKISI, 46, 86],["HP Ykselmesi Deiti", 47, 87],["Sersemlik Karsnda Baklk", 48, 88],["Yavalk Karsnda Baklk", 49, 89],["Yere Dme Karsnda Baklk", 50, 90],["APPLY_SKILL", 51, 0],["Yay Menzili", 52, 95],["Saldr Deeri", 53, 0],["Savunma", 54, 96],["Byl Saldr Deeri", 55, 97],["By Savunmas", 56, 98],["", 57, 0],["Maks. Dayanklk", 58, 0],["Savalara Kar Gl", 59, 54],["Ninjalara Kar Gl", 60, 55],["Suralara Kar Gl", 61, 56],["amanlara Kar Gl", 62, 57],["Canavarlara Kar Gl", 63, 53],["Saldr", 64, 114],["Savunma", 65, 115],["Itemshop Exp-Bonus", 66, 116],["Itemshop Item-Bonus", 67, 117],["Itemshop Yang-Bonus", 68, 118],["APPLY_MAX_HP_PCT", 69, 119],["APPLY_MAX_SP_PCT", 70, 120],["Beceri Hasar", 71, 121],["Ortalama Hasar", 72, 122],["Beceri Hasarna Direni", 73, 123],["Ortalama Hasara Direni", 74, 124],["", 75, 0],["iCafe EXP-Bonus", 76, 125],["iCafe Item-Bonus", 77, 126],["Sava Saldrlarna Savunma", 78, 59],["Ninja Saldrlarna Savunma", 79, 60],["Sura Saldrlarna Savunma", 80, 61],["aman Saldrlarna Savunma", 81, 62]]
	SpecialBoni = { 1: "Norm.State", 2: "Norm.State", 3: "Norm.State", 4: "Norm.State", 5: "Norm.State", 6: "Norm.State", 55: "Norm.State", 56: "Norm.State", 58: "Norm.State" }
	PvPOffenseBoni = [localeInfo.localeInfo.EBONUS_YARIINSAN, localeInfo.EBONUS_KRITIKSANSI, localeInfo.EBONUS_DELICISANSI, "Ortalama Hasar", "Beceri Hasar", "HP", localeInfo.EBONUS_ZEKA, localeInfo.EBONUS_GUC, localeInfo.EBONUS_CEVIKLIK, localeInfo.EBONUS_BUYUHIZI]
	PvPDefenseBoni = [localeInfo.EBONUS_KILICSAVUNMASI, localeInfo.EBONUS_CIFTELSAVUNMASI, localeInfo.EBONUS_BICAKSAVUNMASI, localeInfo.EBONUS_CANSAVUNMASI, localeInfo.EBONUS_YELPAZESAVUNMASI, localeInfo.EBONUS_OKSAVUNMASI, localeInfo.EBONUS_OKLARDANKORUNMASANS, localeInfo.EBONUS_BUYUDAYANIKLILIK, localeInfo.EBONUS_BEDENBLOKLAMA, "Sersemlik Karsnda Baklk"]
	PvMOffenseBoni = ["Canavarlara Kar Gl", "eytanlara Kar Gl", localeInfo.EBONUS_OLUMSUZLEREKARSI, "Hayvanlara Kar Gl", "Orklara Kar Gl", "Mistiklere Kar Gl", "Sersemletme ans", "Zehirleme Deiimi", localeInfo.EBONUS_SALDIRIHIZI, "Saldr Deeri"]
	PvMDefenseBoni = ["Maks HP", "Maks SP", localeInfo.EBONUS_BEDENBLOKLAMA, localeInfo.EBONUS_HPURETIM, localeInfo.EBONUS_SPURETIM, localeInfo.EBONUS_HPEMILIMI, localeInfo.EBONUS_SPEMILIMI, "Exp-Bonus", "Yang-Drop", "Item-Drop"]
	LeftoversOffenseBoni = ["Savalara Kar Gl", "Ninjalara Kar Gl", "Suralara Kar Gl", "amanlara Kar Gl"]
	LeftoversDefenseBoni = ["Sava Saldrlarna Savunma", "Ninja Saldrlarna Savunma", "Sura Saldrlarna Savunma", "aman Saldrlarna Savunma", ]

	BonusList = []
	UI = []
	
	TestSystem = 0
	ProcessTimeStamp = 0
	
	def __init__(self):
		ui.ScriptWindow.__init__(self)
		self.LoadUI()
		game.BPisLoaded = 1
		
	def __del__(self):
		ui.ScriptWindow.__del__(self)
		self.Board.Hide()
		game.BPisLoaded = 0

	def LoadUI(self):
		self.Board = ui.BoardWithTitleBar()
		self.Board.SetSize(343, 418)
		self.Board.SetCenterPosition()
		self.Board.AddFlag("movable")
		self.Board.AddFlag("float")
		self.Board.SetTitleName("Efsun Tablosu")
		self.Board.SetCloseEvent(self.__del__)
		self.Board.Show()
		
		Vertical = ui.Line()
		Vertical.SetParent(self.Board)
		Vertical.SetPosition(23, 60)
		Vertical.SetSize(298, 0)
		Vertical.SetColor(0xff777777)
		Vertical.Show()
		self.UI.append(Vertical)
		
		x = 25
		for i in xrange(3):
			ChangeBonusDict = ui.Button()
			ChangeBonusDict.SetParent(self.Board)
			ChangeBonusDict.SetUpVisual("d:/ymir work/ui/public/large_button_01.sub")
			ChangeBonusDict.SetOverVisual("d:/ymir work/ui/public/large_button_02.sub")
			ChangeBonusDict.SetDownVisual("d:/ymir work/ui/public/large_button_03.sub")
			ChangeBonusDict.SetText(self.BonusDict[i])
			ChangeBonusDict.SetPosition(x, 380)
			ChangeBonusDict.SetEvent(lambda arg = ChangeBonusDict.GetText(): self.ChangeBonusDict(arg))
			ChangeBonusDict.Show()
			x += 97
			self.UI.append(ChangeBonusDict)
			
		x = 50
		Type = ["Saldr", "Defans"]
		for i in xrange(2):
			BonusDescription = ui.TextLine()
			BonusDescription.SetParent(self.Board)
			BonusDescription.SetPosition(x, 35)
			BonusDescription.SetText(str(Type[i]))
			BonusDescription.SetFontColor(4.0, 0.83, 0)
			BonusDescription.Show()			
			x += 150
			self.UI.append(BonusDescription)

		self.SetBoni(self.BonusDict[0])
		self.dict = self.BonusDict[0]
		
	def SetBoni(self, type):
		Offense = [[25, 70], [25, 100], [25, 130], [25, 160], [25, 190], [25, 220], [25, 250], [25, 280], [25, 310], [25, 340]]
		Defense = [[170, 70], [170, 100], [170, 130], [170, 160], [170, 190], [170, 220], [170, 250], [170, 280], [170, 310], [170, 340]]
		for bonus in self.BonusIDListe:
			if type == self.BonusDict[0]:
				self.CheckBonus(bonus, self.PvPOffenseBoni, Offense)
				self.CheckBonus(bonus, self.PvPDefenseBoni, Defense)
			elif type == self.BonusDict[1]:
				self.CheckBonus(bonus, self.PvMOffenseBoni, Offense)
				self.CheckBonus(bonus, self.PvMDefenseBoni, Defense)
			elif type == self.BonusDict[2]:
				self.CheckBonus(bonus, self.LeftoversOffenseBoni, Offense)
				self.CheckBonus(bonus, self.LeftoversDefenseBoni, Defense)
			else:
				return
				
	def CheckBonus(self, bonus, bonuslist, offset):
		for boni in bonuslist:
			if bonus[0] == boni:
				try:
					Index = bonuslist.index(boni)
					BonusDescription = ui.TextLine()
					BonusDescription.SetParent(self.Board)
					BonusDescription.SetPosition(offset[Index][0], offset[Index][1])
					BonusDescription.SetText(str(bonus[0]))
					BonusDescription.Show()
					
					BonusSlotBar = ui.SlotBar()
					BonusSlotBar.SetParent(self.Board)
					BonusSlotBar.SetSize(125, 15)
					BonusSlotBar.SetPosition(offset[Index][0], offset[Index][1] + 15)
					BonusSlotBar.Show()
					
					BonusAttrLine = ui.TextLine()
					BonusAttrLine.SetParent(self.Board)
					BonusAttrLine.SetPosition(offset[Index][0] + 5, offset[Index][1] + 15)
					
					try:
						Type = self.SpecialBoni[bonus[1]]
						Attribute = self.EquipAttribute(bonus)
					except:
						Attribute = player.GetStatus(int(bonus[2]))
					if self.TestSystem != 1:
						BonusAttrLine.SetText(str(Attribute))
						try:
							if int(Attribute) >= int(self.MaxBoni[str(bonus[1])]):
								BonusAttrLine.SetFontColor(1.0, 0.63, 0)
							else:
								BonusAttrLine.SetFontColor(1, 1, 1)
						except:
							BonusAttrLine.SetFontColor(1, 1, 1)
					else:
						BonusAttrLine.SetText("Test system is active")
						BonusAttrLine.SetFontColor(0.1, 0.7, 1.0)
					
					BonusAttrLine.Show()
					self.BonusList.append([BonusDescription, BonusAttrLine, BonusSlotBar])
				except:
					pass		
				
	def EquipAttribute(self, bonus):
		value = 0
		for slot in xrange(90, 101):
			for attr in xrange(0, 7):
				attr, val = player.GetItemAttribute(slot, attr)
				if int(attr) == bonus[1]:
					value += int(val)
		return int(value)

	def ChangeBonusDict(self, dict):
		self.dict = dict
		for bonus in self.BonusList:
			try:
				for array in bonus:
					array.Hide()
			except:
				pass			
		self.SetBoni(dict)
		
	def OnUpdate(self):
		import item
		if int(app.GetTime()) > int(self.ProcessTimeStamp) + 6:
			self.SetBoni(self.dict)
			self.ProcessTimeStamp = app.GetTime()

#BonusBoardDialog().Show()
