import ui
import dbg
import app
import chat
import constInfo
import net
import event

class MountWindow(ui.Window):
	def __init__(self):
		ui.Window.__init__(self)
		self.Hide()
		self.Start = 0
		self.Pic = [ "loewe.tga", "tiger.tga", "wolf.tga", "keiler.tga" ]
		self.Loaded = 0

	def BuildWindow(self):
		if self.Loaded > 0:
			self.Show()
			self.Board.Show()
			return

		self.Loaded = 1

		self.Board = ui.BoardWithTitleBar()
		self.Board.SetSize(238, 200)
		self.Board.SetCenterPosition()
		self.Board.AddFlag("float")
		self.Board.SetTitleName("Panou Control Mount")
		self.Board.SetCloseEvent(self.Open)
		self.Board.Show()

		self.Foreground = ui.ExpandedImageBox()
		self.Foreground.SetParent(self.Board)
		self.Foreground.LoadImage("mounting/" + self.Pic[self.Start])
		self.Foreground.SetPosition(60,40)
		self.Foreground.AddFlag("not_pick")
		self.Foreground.Show()

		self.GUI = []
		Buttons = [ [10,90, "small", "<<"], [185, 90, "small", ">>"],  [75,165, "large", "Imblanzeste"]]

		for i in xrange(len(Buttons)):
			Button = ui.Button()
			Button.SetParent(self.Board)
			Button.SetEvent(ui.__mem_func__(self.__Button), i)
			Button.SetPosition(Buttons[i][0], Buttons[i][1])
			Button.SetUpVisual("d:/ymir work/ui/public/" + Buttons[i][2] + "_button_01.sub")
			Button.SetOverVisual("d:/ymir work/ui/public/" + Buttons[i][2] + "_button_02.sub")
			Button.SetDownVisual("d:/ymir work/ui/public/" + Buttons[i][2] + "_button_03.sub")
			Button.SetText(Buttons[i][3])
			Button.Show()
			self.GUI.append(Button)
		self.Show()

	def __Button(self, arg):
		if arg<=1:
			if arg==1:
				if self.Start==len(self.Pic)-1:
					self.Start=0
				else:
					self.Start= self.Start+1
			else:
				if self.Start==0:
					self.Start=3
				else:
					self.Start= self.Start-1
			self.Foreground.LoadImage("mounting/" + self.Pic[self.Start])
		else:
			self.Open()
			#chat.AppendChat(1, "ClientQuest")
			constInfo.MountSystem["CMD"] = str(self.Start)
			event.QuestButtonClick(constInfo.MountSystem["index"])


	def Open(self):
		if self.IsShow():
			self.Board.Hide()
			self.Hide()
			return
		self.BuildWindow()
