import dbg
import app
import net
import ui
import ime
import snd
import wndMgr
import musicInfo
import serverInfo
import systemSetting
import ServerStateChecker
import localeInfo
import constInfo
import uiCommon
import time
import ServerCommandParser
import ime
import uiScriptLocale
import chat
import sys
import background
import os
import constinfo
import configparser
app.loggined = False
account_parser = configparser.ConfigParser()
STATE_DICT = {
	0 : "....",
	1 : "NORM",
	2 : "BUSY",
	3 : "FULL"
}

class ConnectingDialog(ui.ScriptWindow):

	def __init__(self):
		ui.ScriptWindow.__init__(self)
		self.__LoadDialog()
		self.eventTimeOver = lambda *arg: None
		self.eventExit = lambda *arg: None

	def __del__(self):
		ui.ScriptWindow.__del__(self)

	def __LoadDialog(self):
		try:
			PythonScriptLoader = ui.PythonScriptLoader()
			PythonScriptLoader.LoadScriptFile(self, "UIScript/ConnectingDialog.py")
			self.board = self.GetChild("board")
			self.message = self.GetChild("message")
			self.countdownMessage = self.GetChild("countdown_message")
		except:
			import exception
			exception.Abort("ConnectingDialog.LoadDialog.BindObject")

	def Open(self, waitTime):
		self.Lock()
		self.SetCenterPosition()
		self.SetTop()
		self.Show()

	def Close(self):
		self.Unlock()
		self.Hide()

	def Destroy(self):
		self.Hide()
		self.ClearDictionary()

	def SetText(self, text):
		self.message.SetText(text)

	def OnPressExitKey(self):
		return True


class LoginWindow(ui.ScriptWindow):

	def __init__(self, stream):
		print "NEW LOGIN WINDOW  ----------------------------------------------------------------------------"
		ui.ScriptWindow.__init__(self)
		net.SetPhaseWindow(net.PHASE_WINDOW_LOGIN, self)
		net.SetAccountConnectorHandler(self)
		self.isDeletingAccount = False
		self.backgroundImage = 0
		self.inputDialog = None
		self.connectingDialog = None
		self.GuardInput = None
		self.stream = stream
		self.channelButtonList = []

	def __del__(self):
		net.ClearPhaseWindow(net.PHASE_WINDOW_LOGIN, self)
		net.SetAccountConnectorHandler(0)
		ui.ScriptWindow.__del__(self)
		print "---------------------------------------------------------------------------- DELETE LOGIN WINDOW"

	def Open(self):
		ServerStateChecker.Create(self)
		ServerStateChecker.Initialize()
		ServerStateChecker.AddChannel(1, serverInfo.SERVER_IP, serverInfo.CH_1)
		ServerStateChecker.AddChannel(2, serverInfo.SERVER_IP, serverInfo.CH_2)
		ServerStateChecker.AddChannel(3, serverInfo.SERVER_IP, serverInfo.CH_3)
		ServerStateChecker.AddChannel(4, serverInfo.SERVER_IP, serverInfo.CH_4)
		ServerStateChecker.Request()
		print "LOGIN WINDOW OPEN ----------------------------------------------------------------------------"
		self.loginFailureMsgDict={
			"ALREADY"	: localeInfo.LOGIN_FAILURE_ALREAY,
			"NOID"		: localeInfo.LOGIN_FAILURE_NOT_EXIST_ID,
			"WRONGPWD"	: localeInfo.LOGIN_FAILURE_WRONG_PASSWORD,
			"FULL"		: localeInfo.LOGIN_FAILURE_TOO_MANY_USER,
			"SHUTDOWN"	: localeInfo.LOGIN_FAILURE_SHUTDOWN,
			"REPAIR"	: localeInfo.LOGIN_FAILURE_REPAIR_ID,
			"BLOCK"		: localeInfo.LOGIN_FAILURE_BLOCK_ID,
			"WRONGMAT"	: localeInfo.LOGIN_FAILURE_WRONG_MATRIX_CARD_NUMBER,
			"QUIT"		: localeInfo.LOGIN_FAILURE_WRONG_MATRIX_CARD_NUMBER_TRIPLE,
			"BESAMEKEY"	: localeInfo.LOGIN_FAILURE_BE_SAME_KEY,
			"NOTAVAIL"	: localeInfo.LOGIN_FAILURE_NOT_AVAIL,
			"NOBILL"	: localeInfo.LOGIN_FAILURE_NOBILL,
			"BLKLOGIN"	: localeInfo.LOGIN_FAILURE_BLOCK_LOGIN,
			"WEBBLK"	: localeInfo.LOGIN_FAILURE_WEB_BLOCK,
			"BADSCLID"	: localeInfo.LOGIN_FAILURE_WRONG_SOCIALID,
			"AGELIMIT"	: localeInfo.LOGIN_FAILURE_SHUTDOWN_TIME,
			"IPBAN"		: localeInfo.LOGIN_FAILURE_IP_BLOCK,
			"BAKIMVAR"	: localeInfo.LOGIN_FAILURE_DISABLE,
		}
	
		self.loginFailureFuncDict = {
			"QUIT"		: app.Exit,
		}
		self.SetSize(wndMgr.GetScreenWidth(), wndMgr.GetScreenHeight())
		self.SetWindowName("LoginWindow")
		if not self.__LoadScript("UIScript/LoginWindow.py"):
			dbg.TraceError("LoginWindow.Open - __LoadScript Error")
			return
		if app.loggined:
			self.loginFailureFuncDict = {
				"QUIT"		: app.Exit,
			}
		if musicInfo.loginMusic != "":
			snd.SetMusicVolume(systemSetting.GetMusicVolume())
			snd.FadeInMusic("BGM/" + musicInfo.loginMusic)
		snd.SetSoundVolume(systemSetting.GetSoundVolume())
		ime.AddExceptKey(91)
		ime.AddExceptKey(93)
		self.Show()
		connectingIP = self.stream.GetConnectAddr()
		if connectingIP:
			self.__OpenConnectBoard()
		app.ShowCursor()
		self.SetIDEditLineFocus()
		self.__SetChannel(1)
		self.AccountDeleteAbort.Hide()
		self.RefreshAccounts()

	def Close(self):
		if self.connectingDialog:
			self.connectingDialog.Close()
		self.connectingDialog = None
		ServerStateChecker.Initialize(self)
		print "---------------------------------------------------------------------------- CLOSE LOGIN WINDOW "
		if musicInfo.loginMusic != "" and musicInfo.selectMusic != "":
			snd.FadeOutMusic("BGM/" + musicInfo.loginMusic)
		self.idEditLine.SetTabEvent(0)
		self.idEditLine.SetReturnEvent(0)
		self.pwdEditLine.SetReturnEvent(0)
		self.pwdEditLine.SetTabEvent(0)
		self.connectBoard = None
		self.idEditLine = None
		self.pwdEditLine = None
		self.inputDialog = None
		self.connectingDialog = None
		self.GuardInput = None
		self.KillFocus()
		self.Hide()
		self.isDeletingAccount = False
		self.backgroundImage = 0
		self.stream.popupWindow.Close()
		self.loginFailureFuncDict = None
		ime.ClearExceptKey()
		app.HideCursor()

	def __ExitGame(self):
		app.Exit()

	def SetIDEditLineFocus(self):
		if self.idEditLine != None:
			self.idEditLine.SetFocus()

	def SetPasswordEditLineFocus(self):
		if self.idEditLine != None:
			self.idEditLine.SetText("")
			self.idEditLine.SetFocus()
		if self.pwdEditLine != None:
			self.pwdEditLine.SetText("")

	def OnConnectFailure(self):
		snd.PlaySound("sound/ui/loginfail.wav")
		if self.connectingDialog:
			self.connectingDialog.Close()
		self.connectingDialog = None
		if app.loggined:
			self.PopupNotifyMessage(localeInfo.LOGIN_CONNECT_FAILURE, self.__ExitGame)
		else:
			self.PopupNotifyMessage(localeInfo.LOGIN_CONNECT_FAILURE, self.SetPasswordEditLineFocus)

	def OnHandShake(self):
		snd.PlaySound("sound/ui/loginok.wav")
		self.PopupDisplayMessage(localeInfo.LOGIN_CONNECT_SUCCESS)

	def OnLoginStart(self):
		self.PopupDisplayMessage(localeInfo.LOGIN_PROCESSING)

	def OnLoginFailure(self, error):
		if self.connectingDialog:
			self.connectingDialog.Close()
		self.connectingDialog = None
		try:
			loginFailureMsg = self.loginFailureMsgDict[error]
		except KeyError:
			loginFailureMsg = localeInfo.LOGIN_FAILURE_UNKNOWN + error

		loginFailureFunc = self.loginFailureFuncDict.get(error, self.SetPasswordEditLineFocus)
		if app.loggined:
			self.PopupNotifyMessage(loginFailureMsg, self.__ExitGame)
		else:
			self.PopupNotifyMessage(loginFailureMsg, loginFailureFunc)
		snd.PlaySound("sound/ui/loginfail.wav")

	def __DisconnectAndInputID(self):
		if self.connectingDialog:
			self.connectingDialog.Close()
		self.connectingDialog = None
		self.SetIDEditLineFocus()
		net.Disconnect()

	def __DisconnectAndInputPassword(self):
		if self.connectingDialog:
			self.connectingDialog.Close()
		self.connectingDialog = None
		self.SetPasswordEditLineFocus()
		net.Disconnect()

	def SAFE_SetEvent(self, func, *args):
		self.eventFunc = __mem_func__(func)
		self.eventArgs = args

	def __LoadScript(self, fileName):
		try:
			pyScrLoader = ui.PythonScriptLoader()
			pyScrLoader.LoadScriptFile(self, fileName)
		except:
			import exception
			exception.Abort("LoginWindow.__LoadScript.LoadObject")

		try:
			GetObject = self.GetChild
			self.backgroundImage = GetObject("BackGround")
			self.connectBoard = GetObject("ConnectBoard")
			self.idEditLine = GetObject("ID_EditLine")
			self.pwdEditLine = GetObject("Password_EditLine")
			self.channelButtonList.append(GetObject("Channel1Button"))
			self.channelButtonList.append(GetObject("Channel2Button"))
			self.channelButtonList.append(GetObject("Channel3Button"))
			self.channelButtonList.append(GetObject("Channel4Button"))
			self.Channel1Status = GetObject("Channel1Status")
			self.Channel2Status = GetObject("Channel2Status")
			self.Channel3Status = GetObject("Channel3Status")
			self.Channel4Status = GetObject("Channel4Status")
			self.loginButton = GetObject("LoginButton")
			self.loginExitButton = GetObject("LoginExitButton")
			self.acc1loginButton = GetObject("Acc1Login")
			self.acc2loginButton = GetObject("Acc2Login")
			self.acc3loginButton = GetObject("Acc3Login")
			self.acc4loginButton = GetObject("Acc4Login")
			self.LoginSaveButton = GetObject("LoginSaveButton")
			self.AccountDeleteButton = GetObject("AccountDeleteButton")
			self.AccountDeleteAbort = GetObject("AccountDeleteAbort")
		except:
			import exception
			exception.Abort("LoginWindow.__LoadScript.BindObject")

		imgFileNameDict = {
			0: "locale/es/ui/login/1.sub",
		}
		try:
			imgFileName = imgFileNameDict[app.GetRandom(0, len(imgFileNameDict) - 1)]
			self.backgroundImage.LoadImage(imgFileName)
		except:
			print "LoadingWindow.Open.LoadImage - %s File Load Error" % imgFileName
			self.backgroundImage.Hide()

		width = float(wndMgr.GetScreenWidth()) / float(self.backgroundImage.GetWidth())
		height = float(wndMgr.GetScreenHeight()) / float(self.backgroundImage.GetHeight())
		self.backgroundImage.SetScale(width, height)
		self.loginButton.SetEvent(ui.__mem_func__(self.__OnClickLoginButton))
		self.loginExitButton.SetEvent(ui.__mem_func__(self.__OnClickExitButton))
		self.idEditLine.SetReturnEvent(ui.__mem_func__(self.pwdEditLine.SetFocus))
		self.idEditLine.SetTabEvent(ui.__mem_func__(self.pwdEditLine.SetFocus))
		self.pwdEditLine.SetReturnEvent(ui.__mem_func__(self.__OnClickLoginButton))
		self.pwdEditLine.SetTabEvent(ui.__mem_func__(self.idEditLine.SetFocus))
		self.channelButtonList[0].SAFE_SetEvent(self.__SetChannel, 1)
		self.channelButtonList[1].SAFE_SetEvent(self.__SetChannel, 2)
		self.channelButtonList[2].SAFE_SetEvent(self.__SetChannel, 3)
		self.channelButtonList[3].SAFE_SetEvent(self.__SetChannel, 4)
		self.acc1loginButton.SAFE_SetEvent(self.__LoadAccountAndConnect, 1)
		self.acc2loginButton.SAFE_SetEvent(self.__LoadAccountAndConnect, 2)
		self.acc3loginButton.SAFE_SetEvent(self.__LoadAccountAndConnect, 3)
		self.acc4loginButton.SAFE_SetEvent(self.__LoadAccountAndConnect, 4)
		self.LoginSaveButton.SetEvent(ui.__mem_func__(self.__OnClickLoginSaveButton))
		self.AccountDeleteButton.SetEvent(ui.__mem_func__(self.__OnClickAccountDeleteButton))
		self.AccountDeleteAbort.SetEvent(ui.__mem_func__(self.__OnClickAccountDeleteAbort))
		return 1

	def __ClickRadioButton(self, buttonList, buttonIndex):
		try:
			selButton = buttonList[buttonIndex]
		except IndexError:
			return

		for eachButton in buttonList:
			eachButton.SetUp()

		selButton.Down()

	def __SetChannel(self, index):
		if index == 1:
			self.stream.SetConnectInfo(serverInfo.SERVER_IP, serverInfo.CH_1, serverInfo.SERVER_IP, serverInfo.AUTH)
			self.__ClickRadioButton(self.channelButtonList, 0)
			self.__SetServerInfo("%s - %s " % (serverInfo.SERVER_NAME, serverInfo.CH_1_NAME))
		elif index == 2:
			self.stream.SetConnectInfo(serverInfo.SERVER_IP, serverInfo.CH_2, serverInfo.SERVER_IP, serverInfo.AUTH)
			self.__ClickRadioButton(self.channelButtonList, 1)
			self.__SetServerInfo("%s - %s " % (serverInfo.SERVER_NAME, serverInfo.CH_2_NAME))
		elif index == 3:
			self.stream.SetConnectInfo(serverInfo.SERVER_IP, serverInfo.CH_3, serverInfo.SERVER_IP, serverInfo.AUTH)
			self.__ClickRadioButton(self.channelButtonList, 2)
			self.__SetServerInfo("%s - %s " % (serverInfo.SERVER_NAME, serverInfo.CH_3_NAME))
		elif index == 4:
			self.stream.SetConnectInfo(serverInfo.SERVER_IP, serverInfo.CH_4, serverInfo.SERVER_IP, serverInfo.AUTH)
			self.__ClickRadioButton(self.channelButtonList, 3)
			self.__SetServerInfo("%s - %s " % (serverInfo.SERVER_NAME, serverInfo.CH_4_NAME))
		else:
			self.stream.SetConnectInfo(serverInfo.SERVER_IP, serverInfo.CH_1, serverInfo.SERVER_IP, serverInfo.AUTH)
			self.__SetServerInfo("%s - %s " % (serverInfo.SERVER_NAME, serverInfo.CH_1_NAME))
			self.channelButtonList[0].Down()
			self.channelButtonList[1].SetUp()
			self.channelButtonList[2].SetUp()
		net.SetMarkServer(serverInfo.SERVER_IP, serverInfo.MARKADDR)
		app.SetGuildMarkPath("10.tga")
		app.SetGuildSymbolPath("10")

	def Connect(self, id, pwd):
		net.ACC_ID = id
		net.ACC_PWD = pwd
		if constInfo.SEQUENCE_PACKET_ENABLE:
			net.SetPacketSequenceMode()
		self.stream.popupWindow.Close()
		self.stream.popupWindow.Open(localeInfo.LOGIN_CONNETING, self.SetPasswordEditLineFocus, localeInfo.UI_CANCEL)
		self.stream.SetLoginInfo(id, pwd)
		self.stream.Connect()

	def RefreshAccounts(self):
		account_1 = account_2 = account_3 = account_4 = 0
		account_parser.read("accounts.ini")
		try:
			account_1 = account_parser.get("ACCOUNT_1", "id")
		except:
			self.acc1loginButton.SetText(localeInfo.ACCOUNT_EMPTY)

		try:
			account_2 = account_parser.get("ACCOUNT_2", "id")
		except:
			self.acc2loginButton.SetText(localeInfo.ACCOUNT_EMPTY)

		try:
			account_3 = account_parser.get("ACCOUNT_3", "id")
		except:
			self.acc3loginButton.SetText(localeInfo.ACCOUNT_EMPTY)

		try:
			account_4 = account_parser.get("ACCOUNT_4", "id")
		except:
			self.acc4loginButton.SetText(localeInfo.ACCOUNT_EMPTY)

		if account_1 != 0:
			self.acc1loginButton.SetText(account_1)
		if account_2 != 0:
			self.acc2loginButton.SetText(account_2)
		if account_3 != 0:
			self.acc3loginButton.SetText(account_3)
		if account_4 != 0:
			self.acc4loginButton.SetText(account_4)

	def __LoadAccountAndConnect(self, account_id):
		if self.isDeletingAccount == True:
			try:
				account_1 = account_parser.get("ACCOUNT_" + str(account_id), "id")
			except:
				self.PopupNotifyMessage("Slotul (" + str(account_id) + ") este deja gol!")
				return

			self.RemoveAccountSlotFromSection(account_id)
			self.PopupNotifyMessage("Informatiile de pe slotul (" + str(account_id) + ") au fost sterse.")
			self.AccountDeleteAbort.Hide()
			self.isDeletingAccount = False
			self.RefreshAccounts()
		else:
			id = pw = 0
			try:
				id = account_parser.get("ACCOUNT_" + str(account_id), "id")
				pw = account_parser.get("ACCOUNT_" + str(account_id), "pw")
			except:
				self.PopupNotifyMessage("Nu a fost gasit nici un cont pe acest slot!")
				return

			self.Connect(id, pw)

	def __OnClickLoginSaveButton(self):
		account_1 = account_2 = account_3 = account_4 = 0
		try:
			account_1 = account_parser.get("ACCOUNT_1", "id")
		except:
			pass

		try:
			account_2 = account_parser.get("ACCOUNT_2", "id")
		except:
			pass

		try:
			account_3 = account_parser.get("ACCOUNT_3", "id")
		except:
			pass

		try:
			account_4 = account_parser.get("ACCOUNT_4", "id")
		except:
			pass

		if account_1 == 0:
			slotToWrite = "ACCOUNT_1"
		elif account_2 == 0:
			slotToWrite = "ACCOUNT_2"
		elif account_3 == 0:
			slotToWrite = "ACCOUNT_3"
		elif account_4 == 0:
			slotToWrite = "ACCOUNT_4"
		else:
			self.PopupNotifyMessage("Nu mai ai nici un slot gol pentu a salva acest cont!")
			return
		id = self.idEditLine.GetText()
		pw = self.pwdEditLine.GetText()
		with open("accounts.ini", "w") as f:
			account_parser.add_section(slotToWrite)
			account_parser.set(slotToWrite, "id", id)
			account_parser.set(slotToWrite, "pw", pw)
			account_parser.write(f)
		self.PopupNotifyMessage("Contul a fost salvat cu success!")
		self.RefreshAccounts()

	def __OnClickAccountDeleteButton(self):
		self.PopupNotifyMessage("Selectati un slot pentru a sterge.")
		self.AccountDeleteAbort.Show()
		self.isDeletingAccount = True

	def __OnClickAccountDeleteAbort(self):
		self.AccountDeleteAbort.Hide()
		self.isDeletingAccount = False

	def RemoveAccountSlotFromSection(self, n):
		with open("accounts.ini", "r") as f:
			account_parser.read(f)
		account_parser.remove_section("ACCOUNT_" + str(n))
		with open("accounts.ini", "w") as f:
			account_parser.write(f)

	def __OnClickExitButton(self):
		self.stream.SetPhaseWindow(0)

	def PopupDisplayMessage(self, msg):
		self.stream.popupWindow.Close()
		self.stream.popupWindow.Open(msg)

	def PopupNotifyMessage(self, msg, func = 0):
		if not func:
			func = self.EmptyFunc
		self.stream.popupWindow.Close()
		self.stream.popupWindow.Open(msg, func, localeInfo.UI_OK)

	def __OnCloseInputDialog(self):
		if self.inputDialog:
			self.inputDialog.Close()
		self.inputDialog = None
		return True

	def OnPressExitKey(self):
		self.stream.popupWindow.Close()
		self.stream.SetPhaseWindow(0)
		return True

	def OnExit(self):
		self.stream.popupWindow.Close()

	def OnUpdate(self):
		ServerStateChecker.Update()

	def EmptyFunc(self):
		pass

	def __OpenConnectBoard(self):
		if app.loggined:
			self.Connect(self.id, self.pwd)
			self.connectBoard.Hide()
		elif not self.stream.isAutoLogin:
			self.connectBoard.Show()
		if self.idEditLine == None:
			self.idEditLine.SetText("")
		if self.pwdEditLine == None:
			self.pwdEditLine.SetText("")
		self.idEditLine.SetFocus()
		return

	def __OnClickLoginButton(self):
		id = self.idEditLine.GetText()
		pwd = self.pwdEditLine.GetText()
		if len(id) == 0:
			self.PopupNotifyMessage(localeInfo.LOGIN_INPUT_ID, self.SetIDEditLineFocus)
			return
		if len(pwd) == 0:
			self.PopupNotifyMessage(localeInfo.LOGIN_INPUT_PASSWORD, self.SetPasswordEditLineFocus)
			return
		self.Connect(id, pwd)

	def NotifyChannelState(self, addrKey, state):
		if addrKey == 1:
			if state != 3:
				self.Channel1Status.SetFontColor(0.0, 1.0, 0.0)
			self.Channel1Status.SetText(STATE_DICT[state])
		if addrKey == 2:
			if state != 3:
				self.Channel2Status.SetFontColor(0.0, 1.0, 0.0)
			self.Channel2Status.SetText(STATE_DICT[state])
		if addrKey == 3:
			if state != 3:
				self.Channel3Status.SetFontColor(0.0, 1.0, 0.0)
			self.Channel3Status.SetText(STATE_DICT[state])
		if addrKey == 4:
			if state != 3:
				self.Channel4Status.SetFontColor(0.0, 1.0, 0.0)
			self.Channel4Status.SetText(STATE_DICT[state])
		
	def __SetServerInfo(self, name):
		net.SetServerInfo(name.strip())
		
